/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  SCSCSI.H
 *
 * DESCRIPTIVE NAME =  ADD/DM include file
 *                     Interface data structures between OS2SCSI.DMD
 *                     (SCSI.SYS) and Device-Class Drivers.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 * FUNCTIONS  :
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**
**   Interface between SCSI Driver and Device-Class Driver
**
*/

#define MAX_SCSI_DEVICES        58

/*
** INPUT
**   Read Device Parameters
**   Enable Intelligent Buffer
**   Disable Interlligent Buffer
**   Return Intelligent Buffer Status
**   Deallocate Device
**   Read Device Timeout
*/

typedef struct _SCSI_IN
{
  USHORT   hDev;
} SCSI_IN;

typedef SCSI_IN far *PSCSI_IN;


/*
** INPUT
**   Reset / Initialize
*/

typedef struct _SCSI_IN_RESET_INIT
{
  USHORT   hDev;
  USHORT   lnSenseData;
} SCSI_IN_RESET_INIT;

typedef SCSI_IN_RESET_INIT far *PSCSI_IN_RESET_INIT;

/*
** INPUT
**   Set Device Timeout
*/

typedef struct _SCSI_IN_SETTIMEOUT
{
  USHORT   hDev;
  ULONG    vTimeout;
} SCSI_IN_SETTIMEOUT;

typedef SCSI_IN_SETTIMEOUT far *PSCSI_IN_SETTIMEOUT;

/*
** INPUT
**   Transfer SCB
*/

typedef struct _SCSI_IN_XFERSCB
{
  USHORT   hDev;
  USHORT   lnSenseData;
  ULONG    ppSCB;
  PSCBHDR  lpSCBH;
  UCHAR    flags;
} SCSI_IN_XFERSCB;

typedef SCSI_IN_XFERSCB far *PSCSI_IN_XFERSCB;

/*
** INPUT
**   Allocate Device
*/

typedef struct _SCSI_IN_ALLOCDEV
{
  UCHAR    DevType;
  UCHAR    fDevType;
  USHORT   nAvailable;
} SCSI_IN_ALLOCDEV;

typedef SCSI_IN_ALLOCDEV far *PSCSI_IN_ALLOCDEV;

#define   SCSI_REMOVABLE   0x80

/*
** INPUT
**   Return Peripheral Type Count
*/

typedef struct _SCSI_IN_RTNDEVCNT
{
  UCHAR    DevType;
  UCHAR    fDevType;
} SCSI_IN_RTNDEVCNT;

typedef SCSI_IN_RTNDEVCNT far *PSCSI_IN_RTNDEVCNT;

/*
** INPUT
**   Send Abort
*/

typedef struct _SCSI_IN_SENDABORT
{
  USHORT   hDev;
  USHORT   lnSenseData;
  ULONG    Reserved;
} SCSI_IN_SENDABORT;

typedef SCSI_IN_SENDABORT far *PSCSI_IN_SENDABORT;

/*
** OUTPUT
**   General
*/

typedef struct _SCSI_OUT
{
  BYTE    Data;
} SCSI_OUT;

typedef SCSI_OUT far *PSCSI_OUT;

/*
** OUTPUT
**   Read Device Parameters
*/

typedef struct _SCSI_OUT_READPARM
{
  USHORT   indexDeviceKey;
  UCHAR    levelSCBArcCard;
  UCHAR    indexAdapter;
  USHORT   fDevice;
  UCHAR    LUN;
  UCHAR    PUN;
} SCSI_OUT_READPARM;

typedef SCSI_OUT_READPARM  far *PSCSI_OUT_READPARM;

/*
** OUTPUT
**   Return Intelligent Buffer status
*/

typedef struct _SCSI_OUT_RTNBUFSTATUS
{
  UCHAR    StatusBuff;
} SCSI_OUT_RTNBUFSTATUS;

typedef SCSI_OUT_RTNBUFSTATUS far *PSCSI_OUT_RTNBUFSTATUS;


/*
** OUTPUT
**   Read Device Timeout
*/

typedef struct _SCSI_OUT_READTIMEOUT
{
  ULONG    vTimeout;
} SCSI_OUT_READTIMEOUT;

typedef SCSI_OUT_READTIMEOUT far *PSCSI_OUT_READTIMEOUT;

/*
** OUTPUT
**   Allocate Device
*/

typedef struct _SCSI_OUT_ALLOCDEV
{
  USHORT   hDev;
} SCSI_OUT_ALLOCDEV;

typedef SCSI_OUT_ALLOCDEV far *PSCSI_OUT_ALLOCDEV;


/*
** OUTPUT
**   Return Peripheral Type Count
*/

typedef struct _SCSI_OUT_RTNDEVCNT
{
  USHORT   numDev;
} SCSI_OUT_RTNDEVCNT;

typedef SCSI_OUT_RTNDEVCNT far *PSCSI_OUT_RTNDEVCNT;


/*
** Generic IOCtl function
**   Function Category Code
*/

#define    ABIOS_SERVICE                  0x80

/*
** Generic IOCtl function
**   Adding value for SCSI function
*/

#define    SCSI_PLUS_VALUE                0x40

/*
**   Device Flags Definitiom
*/

#define    DEVICE_POWER_OFF               0x0002
#define    DEVICE_DEFECTIVE               0x0001
#define    INTELLIGENT_BUFFER_SUPPORTED   0x0010


/*
**   Intelligent Buffer Status
*/

#define    INTELLIGENT_BUFFER_ENABLED     0x01
#define    INTELLIGENT_BUFFER_DISABLED    0x00


/*
**
** SCSI Error Definition between Device-Class Driver and OS2SCSI
*/

#define     SCSI_ERR_DEVICE               0x80 /* Device error                */
#define     SCSI_ERR_TIMEOUT              0x81 /* Timeout error               */
#define     SCSI_ERR_UNUSUAL_WAKEUP       0x82 /* Unusual wakeup error        */
#define     SCSI_ERR_DEVHELP              0x83 /* DevHelp error               */
#define     SCSI_ERR_REQ_BLOCK            0x84 /* Request block not available */
#define     SCSI_ERR_MAX_DEVICE           0x85 /* Max device support exceeded */
#define     SCSI_ERR_INT NOT_AVAILABLE    0x86 /* Interrupt level not available */
#define     SCSI_ERR_DEV_NOT_AVAILABLE    0x87 /* Device not available        */
#define     SCSI_ERR_MORE_IRQ             0x88 /* More IRQ levels than adapters */
#define     SCSI_ERR_DEV_BUSY             0x89 /* Device busy                 */
#define     SCSI_ERR_REQ_SENSE_FAILED     0x8A /* Request sense failed        */
#define     SCSI_ERR_INT_BUFF_NOT_SUPPORT 0x8B /* Intelligent buffer not supported */


