/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/diskh/aspi.h, aha, r202 92/08/14";*/

/************************************************************************/
/*                                                                      */
/* Driver Name: OS2ASPI.DMD - OS/2 ASPI Device Manager                  */
/*              --------------------------------------                  */
/*                                                                      */
/* Source File Name: ASPI.H                                             */
/*                                                                      */
/* Descriptive Name: ASPI External Interface Structures                 */
/*                                                                      */
/* Function: Define ASPI to Device Module shared structures             */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/* provided to you solely for the purpose of assisting you in           */
/* the development of your applications. The code is provided           */
/* "AS IS", without warranty of any kind. IBM shall not be liable       */
/* for any damages arising out of your use of this code, even if        */
/* they have been advised of the possibility of such damages.           */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/* Change Log                                                           */
/*                                                                      */
/* Mark    Date      Programmer  Comment                                */
/* ----    ----      ----------  -------                                */
/* @53040  08/14/92  JHL         Define extensions to ASPI for reporting*/
/*                               residual byte counts and limitations   */
/*                               on HBA scatter/gather lists.           */
/*                                                                      */
/*         06/22/94  JHL/TA      Added support for VASPI (DOS execute   */
/*                               I/O SRB)                               */
/*                                                                      */
/* @104639 11/29/94  JHL/TA      ASPI_SRB_ABORT_IO structure defined    */
/*                               the PPSRB as a UCHAR - should be ULONG */
/************************************************************************/


#define ASPI_CMD_LIMIT    6

/*
** ASPI SRB Header
*/


typedef struct _ASPI_SRBHDR {                 /* ASHD */

  UCHAR         CommandCode;
  UCHAR         ASPIStatus;
  UCHAR         AdapterIndex;
  UCHAR         ASPIReqFlags;

} ASPI_SRB_HEADER,*NPASPI_SRB_HEADER, FAR *PASPI_SRB_HEADER;

/* ASM

ASPI_SRB_HEADER EQU ASPI_SRBHDR

*/

/*
** Command Values in ASPI_SRB_HEADER->CommandCode
*/

#define ASPI_CMD_ADAPTER_INQUIRY        0x00
#define ASPI_CMD_GET_DEVICE_TYPE        0x01
#define ASPI_CMD_EXECUTE_IO             0x02
#define ASPI_CMD_ABORT_IO               0x03
#define ASPI_CMD_RESET_DEVICE           0x04
#define ASPI_CMD_SET_ADAPTER_PARMS      0x05

/*
** ASPI Status Values in ASPI_SRB_HEADER->ASPIStatus
*/

#define ASPI_STATUS_IN_PROGRESS         0x00
#define ASPI_STATUS_NO_ERROR            0x01
#define ASPI_STATUS_ABORTED             0x02
#define ASPI_STATUS_ERROR               0x04
#define ASPI_STATUS_INVALID_COMMAND     0x80
#define ASPI_STATUS_INVALID_ADAPTER     0x81
#define ASPI_STATUS_INVALID_TARGET      0x82
#define ASPI_STATUS_MANAGER_BUSY        0xE5
#define ASPI_STATUS_BUFFER_TOO_BIG      0xE6

/*
** ASPI Flags in ASPI_SRB_HEADER->ASPIReqFlags
*/

#define ASPI_REQFLAG_POST_ENABLE        0x01
#define ASPI_REQFLAG_LINKED_SRB         0x02
#define ASPI_REQFLAG_RESIDUAL           0x04

#define ASPI_REQFLAG_DIRECTION_BITS     0x18
#define ASPI_REQFLAG_DIR_TO_HOST        0x08
#define ASPI_REQFLAG_DIR_TO_TARGET      0x10
#define ASPI_REQFLAG_DIR_NO_DATA_XFER   0x18

#define ASPI_REQFLAG_SG_ENABLE          0x20


/*
** ASPI ADAPTER INQUIRY SRB            (for ASPI_CMD_ADAPTER_INQUIRY)
*/

typedef struct _ASPI_SRB_ADAPTER_INQUIRY {           /* ASAI */

  ASPI_SRB_HEADER          SRBHdr;
  UCHAR                    Reserved_1[4];
  UCHAR                    AdapterCount;
  UCHAR                    AdapterTargetID;
  UCHAR                    ManagerName[16];
  UCHAR                    AdapterName[16];
  UCHAR                    AdapterParms[16];

/*
**New fields for an EXTENDED adapter inquiry                     @V53040
*/

  USHORT                   AdapterFeatures;                   /* @V53040  */
  USHORT                   MaximumSGList;                     /* @V53040  */
  ULONG                    MaximumCDBTransfer;                /* @V53040  */

} ASPI_SRB_INQUIRY, *NPASPI_SRB_INQUIRY, FAR *PASPI_SRB_INQUIRY;

/*
** Number of bytes in the extended fields -  @V53040
*/

#define MAX_EXTENDED_ADAPTER_COUNT    0x08                            /* @V53040  */

/*
** Features in ASPI_SRB_ADAPTER_INQUIRY->AdapterFeatures
*/

#define ASPI_SCATTER_GATHER   0x01                            /* @V53040  */
#define ASPI_RESIDUAL_BYTE    0x02                            /* @V53040  */
#define ASPI_ADDRESS_LIMITED  0x04

/*
** ASPI GET DEVICE TYPE SRB          (for ASPI_CMD_DEVICE_TYPE)
*/


typedef struct _ASPI_SRB_DEVICE_TYPE {               /* ASDT */

  ASPI_SRB_HEADER        SRBHdr;
  UCHAR                  Reserved_1[4];
  UCHAR                  DeviceTargetID;
  UCHAR                  DeviceTargetLUN;
  UCHAR                  DeviceType;

/*New fields for EXTENDED target information*/
  USHORT                 TargetFeatures;
} ASPI_SRB_DEVICE_TYPE, *NPASPI_SRB_DEVICE_TYPE, FAR *PASPI_SRB_DEVICE_TYPE;

/*
** Number of bytes in the extended fields
*/
#define MAX_EXTENDED_TARGET_COUNT    0x01

/*
** Features in ASPI_SRB_DEVICE_TYPE->TargetFeatures
*/
#define ASPI_DEVICE_ALLOCATION_SHARED  0x01


/*
** ASPI EXECUTE IO SRB               (for ASPI_CMD_EXECUTE_IO)
*/


typedef struct _ASPI_SRB_EXECUTE_IO {                /* ASEI */

  ASPI_SRB_HEADER        SRBHdr;
  USHORT                 SGListLen;
  UCHAR                  Reserved_1[2];
  UCHAR                  DeviceTargetID;
  UCHAR                  DeviceTargetLUN;
  ULONG                  DataXferLen;
  UCHAR                  SenseDataLen;
  ULONG                  ppDataBuffer;
  ULONG                  ppNxtSRB;
  UCHAR                  SCSICDBLen;
  UCHAR                  HostStatus;
  UCHAR                  TargetStatus;
  VOID                  (FAR *RM_PostAddress)(USHORT DataSeg,PASPI_SRB_HEADER pSRBH);
  USHORT                 RM_DataSeg;
  VOID                  (FAR *PM_PostAddress)(USHORT DataSeg,PASPI_SRB_HEADER pSRBH);
  USHORT                 PM_DataSeg;
  ULONG                  ppSRB;
  UCHAR                  ASPIWorkSpace[22];
  UCHAR                  SCSICDBStart[1];

} ASPI_SRB_EXECUTE_IO, *NPASPI_SRB_EXECUTE_IO, FAR *PASPI_SRB_EXECUTE_IO;


/*
** DOS ASPI EXECUTE IO SRB           (for ASPI_CMD_EXECUTE_IO)
*/


typedef struct _DOS_ASPI_SRB_EXECUTE_IO {                /* DASEI */

  ASPI_SRB_HEADER        SRBHdr;
  UCHAR                  Reserved_1[4];
  UCHAR                  DeviceTargetID;
  UCHAR                  DeviceTargetLUN;
  ULONG                  DataXferLen;
  UCHAR                  SenseDataLen;
  ULONG                  pDataBuffer;
  ULONG                  pNxtSRB;
  UCHAR                  SCSICDBLen;
  UCHAR                  HostStatus;
  UCHAR                  TargetStatus;
  VOID                   (FAR *RM_PostAddress)(PASPI_SRB_HEADER pSRBH);
  UCHAR                  ASPIWorkSpace[34];
  UCHAR                  SCSICDBStart[1];

} DASPI_SRB_EXECUTE_IO, *NPDASPI_SRB_EXECUTE_IO, FAR *PDASPI_SRB_EXECUTE_IO;


/*
** Status returned in ASPI_SRB_EXECUTE_IO->HostStatus
*/

#define ASPI_HSTATUS_NO_ERROR               0x00
#define ASPI_HSTATUS_SELECTION_TIMEOUT      0x11
#define ASPI_HSTATUS_DATA_OVERRUN           0x12
#define ASPI_HSTATUS_BUS_FREE               0x13
#define ASPI_HSTATUS_BUS_PHASE_ERROR        0x14
#define ASPI_HSTATUS_BAD_SGLIST             0x1A              /* @V53040  */

/*
** Status returned in ASPI_SRB_EXECUTE_IO->TargetStatus
*/

#define ASPI_TSTATUS_NO_ERROR             0x00
#define ASPI_TSTATUS_CHECK_CONDITION      0x02
#define ASPI_TSTATUS_BUSY                 0x08
#define ASPI_TSTATUS_RESERV_CONFLICT      0x18



/*
** ASPI ABORT IO SRB                 (for ASPI_CMD_ABORT_IO)
*/

typedef struct _ASPI_SRB_ABORT_IO {                  /* ASAB */

  ASPI_SRB_HEADER          SRBHdr;
  UCHAR                    Reserved_1[4];
  ULONG                    ppSRB;                                       /*@104639*/

} ASPI_SRB_ABORT_IO, *NPASPI_SRB_ABORT_IO, FAR *PASPI_SRB_ABORT_IO;


/*
** ASPI RESET DEVICE SRB             (for ASPI_RESET_DEVICE)
*/


typedef struct _ASPI_SRB_RESET_DEVICE {              /* ASRD */

  ASPI_SRB_HEADER        SRBHdr;
  UCHAR                  Reserved_1[4];
  UCHAR                  DeviceTargetID;
  UCHAR                  DeviceTargetLUN;
  UCHAR                  Reserved_2[14];
  UCHAR                  HostStatus;
  UCHAR                  TargetStatus;
  VOID                   (FAR *RM_PostAddress)(USHORT DataSeg,PASPI_SRB_HEADER pSRBH);
  USHORT                 RM_DataSeg;
  VOID                   (FAR *PM_PostAddress)(USHORT DataSeg,PASPI_SRB_HEADER pSRBH);
  USHORT                 PM_DataSeg;
  UCHAR                  ASPIWorkSpace[22];

} ASPI_SRB_RESET_DEVICE, *NPASPI_SRB_RESET_DEVICE, FAR *PASPI_SRB_RESET_DEVICE;

/*
** ASPI SET HOST ADAPTER PARAMETERS  (for ASPI_CMD_SET_ADAPTER_PARMS)
*/

typedef struct _ASPI_SRB_ADAPTER_PARMS {             /* ASAP */

  ASPI_SRB_HEADER          SRBHdr;
  UCHAR                    Reserved_1[4];
  UCHAR                    AdapterParms[16];

}  ASPI_SRB_ADAPTER_PARMS, *NPASPI_SRB_ADAPTER_PARMS,
   FAR *PASPI_SRB_ADAPTER_PARMS;
