;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;**************************************************************************
;*
;* SOURCE FILE NAME = DHMACS.INC
;*
;* DESCRIPTIVE NAME = DH calls private macros
;*
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* Macros     :   DHDef
;*                DHArgs
;*                DHCall
;*                DHCallES
;*                DHRet1
;*                DHRet2
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
;*
;*
;*
;*
;*
;****************************************************************************


;*
;*
;* Device Help Library Macros
;*
;*

include devhlp.inc

;*
;* To define a Device Help Thunk:
;*
;*
;*  DHDef   Name
;*
;*  DHArgs  Type, ArgName1
;*    .
;*    .
;*    .
;*  DHArgs  Type, ArgNameN
;*
;*  DHCall
;*
;*  DHRet1
;*

;***************************************************************************
;*
;* MACRO NAME    =  DHDef
;*
;*
;* DESCRIPTION   =
;*
;*   Purpose:
;*
;*
;*   Function Calls:
;*
;*
;*
;*
;* INPUT         =
;*
;*
;*
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;****************************************************************************

DHDef   Macro   DHName, Code

        public  DevHelp_&DHName
DevHelp_&DHName  label   far

DHCode  =       DevHlp_&DHName
Frame   =        0
Disp    =       -6
        push    bp
        mov     bp, sp
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es

        Endm

DSReg   equ     -12             ; DS Reg image on stack
ESReg   equ     -14             ; ES Reg image on stack

;***************************************************************************
;*
;* MACRO NAME    =  DHArgs
;*
;*
;* DESCRIPTION   =
;*
;*   Purpose:
;*
;*
;*   Function Calls:
;*
;*
;*
;*
;* INPUT         =
;*
;*
;*
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;****************************************************************************

DHArgs  Macro  Type,ArgName


Field = 0
IFIDN <&Type>,<USHORT>
  Field = 2
ENDIF
IFIDN <&TYPE>,<PUSHORT>
  Field = 4
ENDIF
IFIDN <&TYPE>,<ULONG>
  Field = 4
ENDIF
IFIDN <&TYPE>,<PULONG>
  Field = 4
ENDIF
IFIDN <&TYPE>,<PSEL>
  Field = 4
ENDIF
IFIDN <&TYPE>,<LIN>
  Field = 4
ENDIF
IFIDN <&TYPE>,<PLIN>
  Field = 4
ENDIF
IFIDN <&TYPE>,<PFN>
  Field = 4
ENDIF
IFIDN <&TYPE>,<PPBYTE>
  Field = 4
ENDIF
IFIDN <&TYPE>,<SEL>
  Field = 2
ENDIF
IFIDN <&TYPE>,<PVOID>
  Field = 4
ENDIF
IFIDN <&TYPE>,<NPFN>
  Field = 2
ENDIF
IFIDN <&TYPE>,<NPSZ>
  Field = 2
ENDIF
IFIDN <&TYPE>,<NPVOID>
  Field = 2
ENDIF
IFIDN <&TYPE>,<NPBYTE>
  Field = 2
ENDIF
IFIDN <&TYPE>,<NPPFN>
  Field = 2
ENDIF
IFIDN <&TYPE>,<PBYTE>
  Field = 4
ENDIF
IFIDN <&TYPE>,<UCHAR>
  Field = 2
ENDIF
IFIDN <&TYPE>,<NPUSHORT>
  Field = 2
ENDIF
IFE Field
  %OUT Unknown Argument: &Type
  .ERR
ENDIF

Disp  = Disp+Field
&ArgName = -Disp                   ;* Offset to variable from FRAME
Frame = Frame+Field

        Endm

;***************************************************************************
;*
;* MACRO NAME    =  DHCall
;*
;*
;* DESCRIPTION   =
;*
;*   Purpose:
;*
;*
;*   Function Calls:
;*
;*
;*
;*
;* INPUT         =
;*
;*
;*
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;****************************************************************************

DHCall  Macro

IFNDEF  Device_Help
_DATA   segment dword public 'DATA'
        extrn   _Device_Help:dword
_DATA   ends
ENDIF

        mov     dl, DHCode
        call    [_Device_Help]

        Endm

;***************************************************************************
;*
;* MACRO NAME    =  DHCallES
;*
;*
;* DESCRIPTION   =
;*
;*   Purpose:
;*
;*
;*   Function Calls:
;*
;*
;*
;*
;* INPUT         =
;*
;*
;*
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;****************************************************************************

DHCallES Macro

IFNDEF  Device_Help
_DATA   segment dword public 'DATA'
        extrn   _Device_Help:dword
_DATA   ends
ENDIF

        mov     dl, DHCode
        call    es:[_Device_Help]

        Endm

;***************************************************************************
;*
;* MACRO NAME    =  DHRet1
;*
;*
;* DESCRIPTION   =
;*
;*   Purpose:
;*
;*
;*   Function Calls:
;*
;*
;*
;*
;* INPUT         =
;*
;*
;*
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;****************************************************************************

DHRet1  Macro

        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        DHRet2  %Frame

        Endm

;***************************************************************************
;*
;* MACRO NAME    =  DHRet2
;*
;*
;* DESCRIPTION   =
;*
;*   Purpose:
;*
;*
;*   Function Calls:
;*
;*
;*
;*
;* INPUT         =
;*
;*
;*
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;****************************************************************************

DHRet2  Macro   FrameSize

IFNDEF  DHRET_&FrameSize
        extrn   DHRET_&FrameSize:near
ENDIF
        jmp     DHRET_&FrameSize

        Endm



Stk     equ     <[BP].Frame>
