;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL7.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp Interface
;*                    Semaphore Management DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979     74979  Change return type to USHORT
;*
;*
;****************************************************************************

        .xlist
        include dhmacs.inc
        .list

;*
;*  Semaphore Management
;*



Code    segment dword public 'CODE'
        assume  CS:Code,DS:_DATA

;*
;*
;*  USHORT APIENTRY DevHlp_SemHandle( ULONG SemKey, USHORT SemUseFlag,
;*                                    PULONG SemHandle );
;*
;*

        DHDef   SemHandle
        DHArgs  ULONG,   SemKey
        DHArgs  USHORT,  SemUseFlag
        DHArgs  PULONG,  SemHandle

        mov     bx, Stk.SemKey[0]
        mov     ax, Stk.SemKey[2]
        mov     dh, Stk.SemUseFlag

        DHCall

        les     si, Stk.SemHandle
        mov     es:[si][0], bx
        mov     es:[si][2], ax

        DHRet1

;*
;*
;*  USHORT APIENTRY DevHlp_SemClear( ULONG SemHandle );
;*
;*

        DHDef   SemClear
        DHArgs  ULONG,   SemHandle

        mov     bx, Stk.SemKey[0]
        mov     ax, Stk.SemKey[2]

        DHCall

        DHRet1

;*
;*
;*  USHORT APIENTRY DevHlp_SemRequest( ULONG SemHandle, ULONG SemTimeout );
;*
;*

        DHDef   SemRequest
        DHArgs  ULONG,   SemHandle
        DHArgs  ULONG,   SemTimeout

        mov     bx, Stk.SemHandle[0]
        mov     ax, Stk.SemHandle[2]
        mov     cx, Stk.SemTimeout[0]
        mov     di, Stk.SemTimeout[2]

        DHCall

        DHRet1

;*
;*
;*  USHORT APIENTRY DevHlp_SendEvent( USHORT EventType, USHORT Parm );
;*
;*


        DHDef   SendEvent
        DHArgs  USHORT,  EventType
        DHArgs  USHORT,  Parm

        mov     ah, Stk.EventType
        mov     bx, Stk.Parm

        DHCall

        DHRet1


Code    Ends


        End
