;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL6A.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp Interface
;*		      Interrupt/Thread Management DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   08/25/93  @V73138	   73138  Change made to DevHlp_ProcBlock routine
;*				  to clear AH register before returning.
;*				  This synchronizes the error return code
;*				  for ProcBlock in DHCALLS.H.  This problem
;*				  caused OS2SCSI.DMD to not properly
;*				  identify when a request timed out or was
;*				  interrupted.	   - Tony Abbondanzio
;*
;*   10/22/93  @V74979	   74979  Change return type to USHORT
;*    2/ 5/94		   78794  File created
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  Thread Management
;*

Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA

;*
;*
;*  USHORT APIENTRY DevHlp_ProcBlock( ULONG EventId, ULONG WaitTime,		  ;
;*				      USHORT IntWaitFlag );
;*
;*

	DHDef	ProcBlock
	DHArgs	ULONG,	 EventId
	DHArgs	ULONG,	 WaitTime
	DHArgs	USHORT,  IntWaitFlag

	mov	bx, Stk.EventId[0]
	mov	ax, Stk.EventId[2]
	mov	cx, Stk.WaitTime[0]
	mov	di, Stk.WaitTime[2]
	mov	dh, Stk.IntWaitFlag

	DHCall

	mov	ah, 0				;@V73138

	DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_ProcRun( ULONG EventId, PUSHORT AwakeCount );
;*
;*

	DHDef	ProcRun
	DHArgs	ULONG,	 EventId
	DHArgs	PUSHORT, AwakeCount

	mov	bx, Stk.EventId[0]
	mov	ax, Stk.EventId[2]

	DHCall

	les	bx, Stk.AwakeCount
	mov	es:[bx], ax

	DHRet1




Code	Ends
	End
