;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL5.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp Interface
;*		      IDC and Kernel Function DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979	   74979  Change return type to USHORT
;*   12/02/93  @V76282	   76282  Add DevHelp_DynamicAPI
;*    2/ 5/94		   78794  File broken apart.
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  Inter-Device Driver Communications & Kernel Functions
;*

Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA

;*
;*
;* USHORT APIENTRY DevHlp_InternalError( NPSZ MsgText, USHORT MsgLength );
;*
;*

	DHDef	InternalError
	DHArgs	NPSZ,	 MsgText
	DHArgs	USHORT,  MsgLength

	mov	si, Stk.MsgText
	mov	di, Stk.MsgLength

	DHCall

	DHRet1

;*
;*
;* USHORT APIENTRY DevHlp_RAS( USHORT Major, USHORT Minor, USHORT TraceSize,
;*			       PBYTE TraceData);
;*

	DHDef	RAS
	DHArgs	USHORT,  Major
	DHArgs	USHORT,  Minor
	DHArgs	USHORT,  TraceSize
	DHArgs	PBYTE,	 TraceData

	push	ds
	pop	es

	mov	ax, Stk.Major
	mov	cx, Stk.Minor
	mov	bx, Stk.TraceSize
	lds	si, Stk.TraceData

	DHCallES

	DHRet1

;*
;*
;* USHORT APIENTRY DevHlp_RegisterPerfCtrs(NPBYTE pDataBlock, NPBYTE pTextBlock,
;*					   USHORT Flags);
;*

	DHDef	RegisterPerfCtrs
	DHArgs	NPBYTE,  pDataBlock
	DHArgs	NPBYTE,  pTextBlock
	DHArgs	USHORT,  Flags

	mov	si, ds
	mov	ax, Stk.pDataBlock
	mov	di, ds
	mov	bx, Stk.pTextBlock
	mov	cx, Stk.Flags

	DHCall

	DHRet1



Code	Ends
	End

