;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL4.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp Interface
;*                    Character Queue Management DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979     74979  Change return type to USHORT
;*
;*
;****************************************************************************

        .xlist
        include dhmacs.inc
        .list

;*
;*  Character Queue Management
;*

Code    segment dword public 'CODE'
        assume  CS:Code,DS:_DATA


;*
;*
;*  USHORT APIENTRY DevHlp_QueueInit( NPBYTE Queue );
;*
;*

        DHDef   QueueInit
        DHArgs  NPBYTE,  Queue

        mov     bx, Stk.Queue

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_QueueRead( NPBYTE Queue, PBYTE Char );
;*
;*

        DHDef   QueueRead
        DHArgs  NPBYTE,  Queue
        DHArgs  PBYTE,   Char

        mov     bx, Stk.Queue

        DHCall

        les     bx, Stk.Char
        mov     es:[bx], al

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_QueueWrite( NPBYTE Queue, UCHAR Char );
;*
;*

        DHDef   QueueWrite
        DHArgs  NPBYTE,  Queue
        DHArgs  UCHAR,   Char

        mov     bx, Stk.Queue
        mov     al, Stk.Char

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_QueueFlush( NPBYTE Queue );
;*
;*

        DHDef   QueueFlush
        DHArgs  NPBYTE,  Queue

        mov     bx, Stk.Queue

        DHCall

        DHRet1

Code    Ends


        End
