;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL2B.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      Memory Management Related DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979	   74979  Fix DevHelp_PhysToUVirt
;*   10/22/93  @V74979	   74979  Change return type to USHORT
;*    2/ 5/94		   78794  File created
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  Memory Management
;*

Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA

;*
;*
;* USHORT APIENTRY DevHlp_PhysToUVirt( ULONG PhysAddr, USHORT usLength,
;*				       USHORT Flags, USHORT TagType,
;*				       PVOID SelOffset);
;*
;*
;*


	DHDef	PhysToUVirt
	DHArgs	ULONG,	 PhysAddr
	DHArgs	USHORT,  usLength
	DHArgs	USHORT,  Flags
	DHArgs	USHORT,  TagType
	DHArgs	PVOID,	 SelOffset


	mov	ax, Stk.PhysAddr[2]
	mov	bx, Stk.PhysAddr[0]
	mov	cx, Stk.usLength
	mov	dh, Stk.Flags
	mov	si, Stk.TagType

	DHCall

	push	es
	push	bx
	les	si, Stk.SelOffset				       ;@V74979
	pop	es:[si][0]
	pop	es:[si][2]

	DHRet1


;*
;*
;* USHORT APIENTRY DevHlp_PhysToVirt( ULONG PhysAddr, USHORT usLength,
;*				      PVOID SelOffset, PUSHORT ModeFlag );
;*
;*

	DHDef	PhysToVirt
	DHArgs	ULONG,	 PhysAddr
	DHArgs	USHORT,  usLength
	DHArgs	PULONG,  SelOffset
	DHArgs	PUSHORT, ModeFlag

	mov	ax, Stk.PhysAddr[2]
	mov	bx, Stk.PhysAddr[0]
	mov	cx, Stk.usLength
	mov	dh, 1

	DHCall

	push	es
	push	di
	les	si, Stk.SelOffset
	pop	es:[si][0]
	pop	es:[si][2]

	mov	bx, 1
	les	si, Stk.ModeFlag
	jz	ptov0010
	mov	bx, 0
ptov0010:
	mov	es:[si], bx

	DHRet1

;*
;*
;* USHORT APIENTRY DevHlp_UnPhysToVirt( PUSHORT ModeFlag );
;*
;*

	DHDef	UnPhysToVirt
	DHArgs	PUSHORT, ModeFlag

	DHCall

	mov	bx, 1
	les	si, Stk.ModeFlag
	jz	uptv0010
	mov	bx, 0
uptv0010:
	mov	es:[si], bx

	DHRet1



Code	Ends
	End

