;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL2.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      Memory Management Related DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979	   74979  Fix DevHelp_PhysToUVirt
;*   10/22/93  @V74979	   74979  Change return type to USHORT
;*   12/02/93  @V76282	   76282  Moved DevHelp_PhysToGDTSel from DHCALL12
;*    2/ 5/94		   78794  Broke file apart, also moved FreeGDTSelector
;*				  from DHCALL11.
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  Memory Management
;*

Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA

;*
;*
;* USHORT APIENTRY DevHlp_AllocGDTSelector( PSEL Selectors, USHORT Count );
;*
;*

	DHDef	AllocGDTSelector
	DHArgs	PSEL,	 Selectors
	DHArgs	USHORT,  Count

	les	di, Stk.Selectors
	mov	cx, Stk.Count

	DHCall

	DHRet1

;*
;*
;*  USHORT APIENTRY DevHlp_FreeGDTSelector( SEL Selector );
;*
;*

	DHDef	FreeGDTSelector
	DHArgs	SEL,   Selector

	mov	ax, Stk.Selector

	cmp	ax, [BP].DSReg
	jne	FGDT0010

	mov	word ptr [BP].DSReg, 0
FGDT0010:

	cmp	ax, [BP].ESReg
	jne	FGDT0020

	mov	word ptr [BP].ESReg, 0
FGDT0020:


	DHCall

	DHRet1


;*
;*
;* USHORT APIENTRY DevHlp_PhysToGDTSelector( ULONG PhysAddr, USHORT Count,
;*					     SEL Selector );
;*
;*

	DHDef	PhysToGDTSelector
	DHArgs	ULONG,	 PhysAddr
	DHArgs	USHORT,  Count
	DHArgs	SEL,	 Selector

	mov	ax, Stk.PhysAddr[2]
	mov	bx, Stk.PhysAddr[0]
	mov	cx, Stk.Count
	mov	si, Stk.Selector

	DHCall

	DHRet1

;*									;@V76282
;*
;* USHORT APIENTRY DevHlp_PhysToGDTSel( ULONG PhysAddr, ULONG Count,
;*					SEL Selector, UCHAR Access );
;*
;* @6087 Added for Feature 26087.
;*

	DHDef	PhysToGDTSel
	DHArgs	ULONG,	 PhysAddr
	DHArgs	ULONG,	 Count
	DHArgs	SEL,	 Selector
	DHArgs	UCHAR,	 Access

       .386p
	push	ecx
	mov	eax, Stk.PhysAddr
	mov	ecx, Stk.Count
       .286p

	mov	si,  Stk.Selector
	mov	dh,  Stk.Access

	DHCall

       .386p
	pop	ecx
       .286p

	DHRet1



Code	Ends
	End
