;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL12.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp Interface
;*                    Event Semaphores
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979     74979  Change return type to USHORT
;*   12/02/93  @V76282     76282  Moved DevHelp_PhysToGDTSel to DHCALL2
;*
;*
;****************************************************************************

        .xlist
        include dhmacs.inc
        .list

Code    segment dword public 'CODE'
        assume  CS:Code,DS:_DATA


;*
;*  32 bit Semaphore Management
;*

;*
;*
;*  USHORT APIENTRY DevHlp_OpenEventSem( ULONG hEvent );
;*
;*

        DHDef   OpenEventSem
        DHArgs  ULONG,   hEvent

       .386p
        mov     eax, Stk.hEvent
       .286p

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_CloseEventSem( ULONG hEvent );
;*
;*

        DHDef   CloseEventSem
        DHArgs  ULONG,   hEvent

       .386p
        mov     eax, Stk.hEvent
       .286p

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_PostEventSem( ULONG hEvent );
;*
;*

        DHDef   PostEventSem
        DHArgs  ULONG,   hEvent

       .386p
        mov     eax, Stk.hEvent
       .286p

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_ResetEventSem( ULONG hEvent, PULONG pNumPosts );
;*
;*

        DHDef   ResetEventSem
        DHArgs  ULONG,   hEvent
        DHArgs  PULONG,  pNumPosts

       .386p
        push    edi
        mov     eax, Stk.hEvent
        mov     edi, Stk.pNumPosts
       .286p

        DHCall

       .386p
        pop     edi
       .286p
        DHRet1


Code    Ends


        End
