;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL11.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      32-Bit DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES      : These DevHelps are unique to OS/2 2.x.
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   07/26/93  @V72103	   72103  Fix DevHlp_LinToGDTSelector
;*   10/22/93  @V74979	   74979  Change return type to USHORT.
;*   10/22/93  @V74979	   74979  Add DevHlp_VMSetMem
;*				      DevHlp_Beep
;*				      DevHlp_RegisterBeep
;*    2/ 5/94		   78794  File broken apart
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  32-Bit DevHelps
;*


Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA


;*
;*
;* USHORT APIENTRY DevHlp_RegisterPDD( NPSZ PhysDevName, PFN HandlerRoutine );
;*
;*

	DHDef	RegisterPDD
	DHArgs	NPSZ,  PhysDevName
	DHArgs	PFN,   HandlerRoutine

	mov	si, Stk.PhysDevName
	les	di, Stk.HandlerRoutine

	DHCall

	DHRet1


;*
;*
;* USHORT APIENTRY DevHelp_RegisterBeep( PFN BeepHandler );
;*
;*
	DHDef	RegisterBeep						;@V74979
	DHArgs	PFN,	BeepHandler					;@V74979
									;@V74979
	mov	cx, Stk.BeepHandler[2]					;@V74979
	mov	di, Stk.BeepHandler[0]					;@V74979
									;@V74979
	DHCall								;@V74979
									;@V74979
	DHRet1								;@V74979


;*
;*
;* USHORT APIENTRY DevHelp_Beep( USHORT Frequency, USHORT DurationMS );
;*
;*									;@V74979
	DHDef	Beep							;@V74979
	DHArgs	USHORT, Frequency					;@V74979
	DHArgs	USHORT, DurationMS					;@V74979
									;@V74979
	mov	bx, Stk.Frequency					;@V74979
	mov	cx, Stk.DurationMS					;@V74979
									;@V74979
	DHCall								;@V74979
									;@V74979
	DHRet1								;@V74979


;*
;*
;* USHORT APIENTRY DevHlp_RegisterDeviceClass( NPSZ    DeviceString,
;*					       PFN     DriverEP,						   ;
;*					       USHORT  DeviceFlags,
;*					       USHORT  DeviceClass,
;*					       PUSHORT DeviceHandle);
;*

	DHDef	RegisterDeviceClass
	DHArgs	NPSZ,	 DeviceString
	DHArgs	PFN,	 DriverEP
	DHArgs	USHORT,  DeviceFlags
	DHArgs	USHORT,  DeviceClass
	DHARGS	PUSHORT, DeviceHandle

	mov	si, Stk.DeviceString
	mov	bx, word ptr Stk.DriverEP
	mov	ax, word ptr Stk.DriverEP+2
	mov	di, Stk.DeviceFlags
	mov	cx, Stk.DeviceClass

	DHCall

	les	si, Stk.DeviceHandle
	mov	es:[si], ax

	DHRet1



Code	Ends
	End
