;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL10.ASM
;*
;* DESCRIPTIVE NAME = C Callable DevHelp interface
;*                    Character Monitor related DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979     74979  Change return type to USHORT
;*   10/22/93  @V74979     74979  Fix DevHelp_DeRegister
;*   12/02/93  @V76282     76282  Fix DevHelp_MonWrite
;*
;****************************************************************************

        .xlist
        include dhmacs.inc
        .list

;*
;*  Monitors
;*

Code    segment dword public 'CODE'
        assume  CS:Code,DS:_DATA


;*
;*
;*  USHORT APIENTRY DevHlp_MonFlush( USHORT MonitorHandle );
;*
;*

        DHDef   MonFlush
        DHArgs  USHORT,  MonitorHandle

        mov     ax, Stk.MonitorHandle

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_Register( USHORT MonitorHandle, USHORT MonitorPID,
;*                                   PBYTE InputBuffer, NPBYTE OutputBuffer,
;*                                   USHORT ChainFlag );
;*
;*

        DHDef   Register
        DHArgs  USHORT,  MonitorHandle
        DHArgs  USHORT,  MonitorPID
        DHArgs  PBYTE,   InputBuffer
        DHArgs  NPBYTE,  OutputBuffer
        DHArgs  USHORT,  ChainFlag

        mov     ax, Stk.MonitorHandle
        mov     cx, Stk.MonitorPID
        les     si, Stk.InputBuffer
        mov     di, Stk.OutputBuffer
        mov     dh, Stk.ChainFlag

        DHCall

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_DeRegister( USHORT MonitorPID,
;*                                     USHORT MonitorHandle
;*                                     PUSHORT MonitorsLeft);
;*
;*

        DHDef   DeRegister
        DHArgs  USHORT,  MonitorPID                                     ;@V74979
        DHArgs  USHORT,  MonitorHandle
        DHArgs  PUSHORT, MonitorsLeft

        mov     ax, Stk.MonitorHandle
        mov     bx, Stk.MonitorPID

        DHCall

        les     bx, Stk.MonitorsLeft
        mov     es:[bx], ax

        DHRet1

;*
;*
;*  USHORT APIENTRY DevHlp_MonitorCreate( USHORT MonitorHandle,
;*                                        PBYTE FinalBuffer,
;*                                        NPFN NotifyRtn,
;*                                        PUSHORT MonitorChainHandle
;*
;*

        DHDef   MonitorCreate
        DHArgs  USHORT,  MonitorHandle
        DHArgs  PBYTE,   FinalBuffer
        DHArgs  NPFN,    NotifyRtn
        DHArgs  PUSHORT, MonitorChainHandle

        mov     ax, Stk.MonitorHandle
        les     si, Stk.FinalBuffer
        mov     di, Stk.NotifyRtn

        DHCall

        les     bx, Stk.MonitorChainHandle
        mov     es:[bx], ax

        DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_MonWrite( USHORT MonitorHandle, PBYTE DataRecord,
;*                                   USHORT Count, ULONG TimeStampMS,   ;@V76282
;*                                   USHORT WaitFlag );
;*

        DHDef   MonWrite
        DHArgs  USHORT,  MonitorHandle
        DHArgs  PBYTE,   DataRecord
        DHArgs  USHORT,  Count
        DHArgs  ULONG,   TimeStampMS                                    ;@V76282
        DHArgs  USHORT,  WaitFlag

        mov     ax, Stk.MonitorHandle
        mov     cx, Stk.Count
        mov     si, Stk.DataRecord
        mov     di, Stk.TimeStampMS[2]                                  ;@V76282
        mov     bx, Stk.TimeStampMS[0]                                  ;@V76282
        mov     dh, Stk.WaitFlag

        DHCall

        DHRet1


Code    Ends


        End
