;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL1.ASM
;*
;* DESCRIPTIVE NAME = C Callable DevHelp Interface
;*		      ABIOS Related DevHlp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   10/22/93  @V74979	   74979  Change return type to USHORT
;*    2/05/94		   78794  Broke file apart for more granularity
;*
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  ABIOS Related
;*

Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA
;*
;*
;*
;* USHORT APIENTRY DevHlp_GetLIDEntry ( USHORT DeviceType, USHORT LIDIndex,
;*					USHORT LIDType, PUSHORT LID );
;*
;*

	DHDef	GetLIDEntry
	DHArgs	USHORT,  DeviceType
	DHArgs	USHORT,  LIDIndex
	DHArgs	USHORT,  LIDType
	DHArgs	PUSHORT, LID

	mov	al, Stk.DeviceType
	mov	bl, Stk.LIDIndex
	mov	dh, Stk.LIDType

	DHCall

	les	bx, Stk.LID
	mov	es:[bx], ax

	DHRet1

;*
;*
;* USHORT APIENTRY DevHlp_FreeLIDEntry( USHORT LIDNumber );
;*
;*

	DHDef	FreeLIDEntry
	DHArgs	USHORT,  LIDNumber

	mov	ax, Stk.LIDNumber

	DHCall

	DHRet1

;*
;*
;* USHORT APIENTRY DevHlp_ABIOSCall( USHORT Lid, NPBYTE ReqBlk,
;*				     USHORT Entry_Type );
;*
;*

	DHDef	ABIOSCall
	DHArgs	USHORT,  Lid
	DHArgs	NPBYTE,  ReqBlk
	DHArgs	USHORT,  Entry_Type

	mov	ax, Stk.Lid
	mov	si, Stk.ReqBlk
	mov	dh, Stk.Entry_Type

	DHCall

	DHRet1


Code	Ends
	End
