;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL11H.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      32-Bit DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES      : These DevHelps are unique to OS/2 2.x.
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   07/26/93  @V72103	   72103  Fix DevHlp_LinToGDTSelector
;*   10/22/93  @V74979	   74979  Change return type to USHORT.
;*    2/ 5/94		   78794  File created
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  32-Bit DevHelps
;*


Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA


;*
;*
;*  USHORT APIENTRY DevHlp_PageListToLin( ULONG Size, LIN pPageList,
;*					  PLIN LinearAddr );
;*
;*

	DHDef	PageListToLin
	DHArgs	ULONG,	lSize
	DHArgs	PBYTE,	SelInfo

	.386p

	mov	ecx, Stk.lSize
	mov	edi, Stk.pPageList

	.286p
	DHCall
	.386p

	les	si, Stk.LinearAddr
	mov	es:[si], eax

	.286p

	DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_PageListToGDTSelector( SEL Selector, ULONG Size,
;*						  USHORT Access,
;*						  LIN pPageList );			       ;
;*
;*

	DHDef	PageListToGDTSelector
	DHArgs	SEL,	Selector
	DHArgs	ULONG,	lSize
	DHArgs	USHORT, Access
	DHArgs	LIN,	pPageList

	.386p

	mov	ax,  Stk.Selector
	mov	ecx, Stk.lSize
	mov	dh,  Stk.Access
	mov	edi, Stk.pPageList

	.286p
	DHCall

	DHRet1


;*
;*
;*  USHORT APIENTRY DevHlp_LinToGDTSelector( SEL  Selector, LIN LinearAddr,
;*					     ULONG Size );
;*
;*

	DHDef	LinToGDTSelector
	DHArgs	SEL,	Selector
	DHArgs	LIN,	LinearAddr					;@V72103
	DHArgs	ULONG,	lSize

	.386p

	mov	ax,  Stk.Selector
	mov	ebx, Stk.LinearAddr
	mov	ecx, Stk.lSize

	.286p
	DHCall

	DHRet1


Code	Ends
	End
