;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL11a.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      32-Bit DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES      : These DevHelps are unique to OS/2 2.x.
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   07/26/93  @V72103	   72103  Fix DevHlp_LinToGDTSelector
;*
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  32-Bit DevHelps
;*


	.386p
Code	segment dword public use16 'CODE'
	.286p
	assume	CS:Code,DS:_DATA


;*
;*
;*  BOOL APIENTRY DevHlp_VMProcessToGlobal( ULONG Flags, LIN LinearAddr,
;*					    ULONG Length,
;*					    PLIN GlobalLinearAddr );
;*
;*

	DHDef	VMProcessToGlobal
	DHArgs	ULONG,	Flags
	DHArgs	LIN,	LinearAddr
	DHArgs	ULONG,	lLength
	DHArgs	PLIN,	GlobalLinearAddr

	.386p

	mov	eax, Stk.Flags
	mov	ebx, Stk.LinearAddr
	mov	ecx, Stk.lLength

	.286p
	DHCall
	.386p

	les	si, Stk.GlobalLinearAddr
	mov	es:[si], eax

	.286p

	DHRet1

;*
;*
;*  BOOL APIENTRY DevHlp_VMGlobalToProcess( ULONG Flags, LIN LinearAddr,
;*					    ULONG Length,
;*					    PLIN ProcessLinearAddr );
;*
;*
;*

	DHDef	VMGlobalToProcess
	DHArgs	ULONG,	Flags
	DHArgs	LIN,	LinearAddr
	DHArgs	ULONG,	lLength
	DHArgs	PLIN,	ProcessLinearAddr

	.386p

	mov	eax, Stk.Flags
	mov	ebx, Stk.LinearAddr
	mov	ecx, Stk.lLength

	.286p
	DHCall
	.386p

	les	si, Stk.ProcessLinearAddr
	mov	es:[si], eax

	.286p

	DHRet1

Code	Ends


	End
