;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL11B.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      32-Bit DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES      : These DevHelps are unique to OS/2 2.x.
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   07/26/93  @V72103	   72103  Fix DevHlp_LinToGDTSelector
;*   10/22/93  @V74979	   74979  Change return type to USHORT.
;*   10/22/93  @V74979	   74979  Add DevHlp_VMSetMem
;*    2/ 5/94		   78794  File created
;*
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  32-Bit DevHelps
;*


Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA


;*
;*
;*  USHORT APIENTRY DevHlp_VMAlloc( ULONG Flags, ULONG Size, ULONG PhysAddr,
;*				    PLIN LinearAddr, PPBYTE SelOffset );
;*
;*

	DHDef	VMAlloc
	DHArgs	ULONG,	Flags
	DHArgs	ULONG,	lSize
	DHArgs	ULONG,	PhysAddr
	DHArgs	PLIN,	LinearAddr
	DHArgs	PPBYTE, SelOffset

	.386p

	mov	eax, Stk.Flags
	mov	ecx, Stk.lSize
	mov	edi, Stk.PhysAddr

	.286p
	DHCall

	.386p
	les	si, Stk.LinearAddr
	mov	es:[si], eax
	les	si, Stk.SelOffset
	mov	es:[si], ecx

	.286p

	DHRet1

;*
;*
;*  USHORT APIENTRY DevHlp_VMFree( LIN LinearAddr );
;*
;*

	DHDef	VMFree
	DHArgs	LIN,	LinearAddr

	.386p

	mov	eax, Stk.LinearAddr

	.286p
	DHCall

	DHRet1


;*
;*
;*   USHORT APIENTRY DevHlp_VMSetMem( LIN LinearAddr, ULONG Size, ULONG Flags);
;*
;*
	DHDef	VMSetMem						;@V74979
	DHArgs	LIN,	LinearAddr					;@V74979
	DHArgs	ULONG,	lSize						;@V74979
	DHArgs	ULONG,	Flags						;@V74979
									;@V74979
	.386p								;@V74979
									;@V74979
	mov	ebx, Stk.LinearAddr					;@V74979
	mov	ecx, Stk.lSize						;@V74979
	mov	eax, Stk.Flags						;@V74979
									;@V74979
	.286p								;@V74979
	DHCall								;@V74979
									;@V74979
									;@V74979
	DHRet1								;@V74979


Code	Ends
	End
