;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; SCCSID = %w% %e%
;**************************************************************************
;*
;* SOURCE FILE NAME = DHCALL11A.ASM
;*
;* DESCRIPTIVE NAME = C callable DevHelp interface
;*		      32-Bit DevHelp Calls
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;*
;*
;*
;* FUNCTIONS  :
;*
;*
;*
;*
;*
;*
;*
;* NOTES      : These DevHelps are unique to OS/2 2.x.
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   07/26/93  @V72103	   72103  Fix DevHlp_LinToGDTSelector
;*   10/22/93  @V74979	   74979  Change return type to USHORT.
;*    2/ 5/94		   78794  File created
;*
;****************************************************************************

	.xlist
	include dhmacs.inc
	.list

;*
;*  32-Bit Memory management
;*


Code	segment dword public 'CODE'
	assume	CS:Code,DS:_DATA

;*
;*
;*  USHORT APIENTRY DevHlp_VMLock( ULONG Flags, LIN LinearAddr, ULONG Length,
;*				   LIN pPagelist, LIN pLockHandle,
;*				   PULONG PageListCount );
;*
;*

	DHDef	VMLock
	DHArgs	ULONG,	Flags
	DHArgs	LIN,	LinearAddr					;@V72103
	DHArgs	ULONG,	lLength
	DHArgs	LIN,	pPageList
	DHArgs	LIN,	pLockHandle
	DHArgs	PULONG, PageListCount

	.386p

	mov	eax, Stk.Flags
	mov	ebx, Stk.LinearAddr					;@V72103
	mov	ecx, Stk.lLength
	mov	esi, Stk.pLockHandle
	mov	edi, Stk.pPageList

	.286p
	DHCall
	.386p

	les	si, Stk.PageListCount
	mov	es:[si], eax

	.286p

	DHRet1



;*
;*
;*  USHORT APIENTRY DevHlp_VMUnLock( LIN pLockHandle );
;*
;*

	DHDef	VMUnLock
	DHArgs	LIN,	pLockHandle

	.386p

	mov	esi, Stk.pLockHandle

	.286p

	DHCall

	DHRet1


Code	Ends
	End
