/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CMDPSCSI.C
 *
 * DESCRIPTIVE NAME = ADD Command Line Parser
 *                    Command Parser Table for SCSI ADDs
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 * FUNCTIONS  :
 *
 *
 *
 *
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#if !(defined(OS2_INCLUDED))
    #define INCL_NOBASEAPI
    #define INCL_NOPMAPI
    #include "OS2.H"
#endif
#include  "CMDPHDR.H"

CC       cc = {0,0};

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len = OUTBUF_LEN + 1;
PBYTE    poutbuf = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         2

/*
**                                       opt.state[] initialization definitions
**
**                                         ____ entry state
**                                         |                   previous
**                                         v                     opt |
**  ----Command Line Option --------      ----- STATE TABLE -----    |
**  token id          string   type        0   1   2                 |
**                                                                   |
**                                         *  /A: /A:        <-------
**                                               plus
*/

OPT OPT_SN =
    {TOK_ID_SN,     "/SN",   TYPE_0,      {0,  E,  E}};

OPT OPT_NSN =
    {TOK_ID_NOT_SN, "/!SN",  TYPE_0,      {0,  E,  E}};

OPT OPT_ET =
    {TOK_ID_ET,     "/ET",   TYPE_0,      {0,  E,  E}};

OPT OPT_NET =
    {TOK_ID_NOT_ET, "/!ET",  TYPE_0,      {0,  E,  E}};

OPT OPT_ADAPTER =
    {TOK_ID_ADAPTER,"/A:",   TYPE_D,      {1,  E,  1}};

OPT OPT_PORT =
    {TOK_ID_PORT,   "/P:",   TYPE_HHHH,   {E,  2,  E}};

OPT OPT_SLOT =
    {TOK_ID_SLOT,   "/S:",   TYPE_D,      {E,  2,  E}};

OPT OPT_DM =
    {TOK_ID_DM,     "/DM:",  TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_DM_DEFAULT =
    {TOK_ID_DM,     "/DM",   TYPE_0,      {E,  2,  2}};

OPT OPT_NDM =
    {TOK_ID_NOT_DM, "/!DM:", TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_NDM_DEFAULT =
    {TOK_ID_NOT_DM, "/!DM",  TYPE_0,      {E,  2,  2}};

OPT OPT_SM =
    {TOK_ID_SM,     "/SM:",  TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_SM_DEFAULT =
    {TOK_ID_SM,     "/SM",   TYPE_0,      {E,  2,  2}};

OPT OPT_NSM =
    {TOK_ID_NOT_SM, "/!SM:", TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_NSM_DEFAULT =
    {TOK_ID_NOT_SM, "/!SM",  TYPE_0,      {E,  2,  2}};

OPT OPT_HCW =
    {TOK_ID_HCW,    "/HCW:", TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_HCW_DEFAULT =
    {TOK_ID_HCW,    "/HCW",  TYPE_0,      {E,  2,  2}};

OPT OPT_NHCW =
    {TOK_ID_NOT_HCW,"/!HCW:",TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_NHCW_DEFAULT =
    {TOK_ID_NOT_HCW,"/!HCW", TYPE_0,      {E,  2,  2}};

OPT OPT_HCR =
    {TOK_ID_HCR,    "/HCR:", TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_HCR_DEFAULT =
    {TOK_ID_HCR,    "/HCR",  TYPE_0,      {E,  2,  2}};

OPT OPT_NHCR =
    {TOK_ID_NOT_HCR,"/!HCR:",TYPE_SCSI_ID,{E,  2,  2}};

OPT OPT_NHCR_DEFAULT =
    {TOK_ID_NOT_HCR,"/!HCR", TYPE_0,      {E,  2,  2}};

OPT OPT_DEV0 =
    {TOK_ID_DEV0,   "/DEV0:",TYPE_D,      {E,  2,  2}};

OPT OPT_END =
    {TOK_ID_END,    "\0",    TYPE_0,      {O,  O,  O}};


/*
**   The following is a generic OPTIONTABLE for ADDs which support SCSI
**   devices.
**
**   Please note the importance of the ordering of entries in poption[]
**   For example: the pointer to the option "/DM:" must come before the
**                option "/DM"
*/

OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    {(POPT) &OPT_ADAPTER,
     (POPT) &OPT_SN,
     (POPT) &OPT_NSN,
     (POPT) &OPT_ET,
     (POPT) &OPT_NET,

/*
**   This table currently supports /P, to change to /S comment out &OPT_PORT
**   and remove the comment from &OPT_SLOT
*/
     (POPT) &OPT_PORT,
/*   (POPT) &OPT_SLOT,     */

     (POPT) &OPT_DM,
     (POPT) &OPT_DM_DEFAULT,
     (POPT) &OPT_NDM,
     (POPT) &OPT_NDM_DEFAULT,
     (POPT) &OPT_SM,
     (POPT) &OPT_SM_DEFAULT,
     (POPT) &OPT_NSM,
     (POPT) &OPT_NSM_DEFAULT,
     (POPT) &OPT_HCW,
     (POPT) &OPT_HCW_DEFAULT,
     (POPT) &OPT_NHCW,
     (POPT) &OPT_NHCW_DEFAULT,
     (POPT) &OPT_HCR,
     (POPT) &OPT_HCR_DEFAULT,
     (POPT) &OPT_NHCR,
     (POPT) &OPT_NHCR_DEFAULT,
     (POPT) &OPT_DEV0,
     (POPT) &OPT_END
    }
};

