/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CMDPDSKT.C
 *
 * DESCRIPTIVE NAME = Add command line parser
 *                    Command_Parser Diskette Type ADD
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 * FUNCTIONS  :
 *
 *
 *
 *
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#if !(defined(OS2_INCLUDED))
    #define INCL_NOBASEAPI
    #define INCL_NOPMAPI
    #include "OS2.H"
#endif
#include  "CMDPHDR.H"

CC       cc = {0,0};

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len = OUTBUF_LEN + 1;
PBYTE    poutbuf = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         5

/*
**                                        opt.state[] initialization definitions
**                                         ____ entry state
**                                         |                           previous
**                                         v                               opt |
**  ----Command Line Option --------      ----- STATE TABLE  --------------    |
**  token id          string   type        0    1    2   3      4     5        |
**                                                                           <-|
**                                         *   /MCA /A: /DMA: /UNIT: /F
**                                             /PS2     /IRQ:        /AHS
**                                                      /P:          /SPEC
**                                                                   /CL
*/

OPT OPT_ADAPTER =
   {TOK_ID_ADAPTER, "/A:",   TYPE_D,      {2,  2,   E,  E,    E,     E }};

OPT OPT_PORT =
    {TOK_ID_PORT,   "/P:",   TYPE_HHHH,   {E,  E,   3,  3,    E,     E }};

OPT OPT_SLOT =
    {TOK_ID_SLOT,   "/S:",   TYPE_D,      {E,  E,   E,  E,    E,     E }};

OPT OPT_UNIT =
    {TOK_ID_UNIT,   "/UNIT:",TYPE_D,      {4,  E,   4,  4,    E,     4 }};

OPT OPT_U =
    {TOK_ID_UNIT,   "/U:",   TYPE_D,      {4,  E,   4,  4,    E,     4 }};

OPT OPT_DMA =
    {TOK_ID_DMA,    "/DMA:", TYPE_D,      {E,  E,   3,  3,    E,     E }};

OPT OPT_IRQ =
    {TOK_ID_IRQ,    "/IRQ:", TYPE_DD,     {E,  E,   3,  3,    E,     E }};

OPT OPT_AHS =
    {TOK_ID_AHS,    "/AHS",  TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_NAHS =
    {TOK_ID_NOT_AHS,"/!AHS", TYPE_0,      {E,  E,   E,  E,    5,     5 }};

OPT OPT_FORMAT =
    {TOK_ID_FORMAT, "/F:",   TYPE_FORMAT, {E,  E,   E,  E,    5,     5 }};

OPT OPT_SBYTES =
    {TOK_ID_S_BYTES,"/SPEC:",TYPE_HH,     {E,  E,   E,  E,    5,     5 }};

OPT OPT_CHGLINE =
    {TOK_ID_CHGLINE,"/CL:",  TYPE_CHGLINE,{E,  E,   E,  E,    5,     5 }};

OPT OPT_PS2 =
    {TOK_ID_PS2,    "/PS2",  TYPE_0,      {1,  E,   E,  E,    E,     E }};

OPT OPT_MCA =
    {TOK_ID_MCA,    "/MCA",  TYPE_0,      {1,  E,   E,  E,    E,     E }};

OPT OPT_END =
    {TOK_ID_END,    "\0",    TYPE_0,      {O,  O,   O,  O,    O,     O }};

/*
**   The following is a generic OPTIONTABLE for ADDs which support diskette
**   devices.
*/

OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    {(POPT) &OPT_ADAPTER,
     (POPT) &OPT_PORT,
     (POPT) &OPT_UNIT,
     (POPT) &OPT_U,
     (POPT) &OPT_DMA,
     (POPT) &OPT_IRQ,
     (POPT) &OPT_AHS,
     (POPT) &OPT_NAHS,
     (POPT) &OPT_FORMAT,
     (POPT) &OPT_SBYTES,
     (POPT) &OPT_CHGLINE,
     (POPT) &OPT_PS2,
     (POPT) &OPT_MCA,
     (POPT) &OPT_END
    }
};
