/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CMDPDISK.C
 *
 * DESCRIPTIVE NAME = ADD Command Line Parser
 *                    Command Parser Table for ST-506 DASD ADDs
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 * FUNCTIONS  :
 *
 *
 *
 *
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#if !(defined(OS2_INCLUDED))
    #define INCL_NOBASEAPI
    #define INCL_NOPMAPI
    #include "OS2.H"
#endif
#include  "CMDPHDR.H"

CC       cc = {0,0};

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len = OUTBUF_LEN + 1;
PBYTE    poutbuf = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         3

/*
**                                       opt.state[] initialization definitions
**
**                                             ____ entry state
**                                             |                   previous
**                                             v                     opt |
**  ----Command Line Option --------          ----- STATE TABLE -----    |
**  token id          string   type            0   1   2   3             |
**                                                                       |
**                                             * /A:/UNIT:/P: <-----------
**
*/

OPT OPT_ADAPTER =
    {TOK_ID_ADAPTER,"/A:",   TYPE_D,          {1,  1,  1,  1}};

OPT OPT_PORT =
    {TOK_ID_PORT,   "/P:",   TYPE_HHHH,       {E,  3,  E,  E}};

OPT OPT_SLOT =
    {TOK_ID_SLOT,   "/S:",   TYPE_D,          {E,  3,  E,  E}};

OPT OPT_UNIT =
    {TOK_ID_UNIT,   "/UNIT:",TYPE_D,          {E,  2,  2,  2}};

OPT OPT_CAM =
    {TOK_ID_CAM,    "/CAM2", TYPE_0,          {E,  E,  2,  E}};

OPT OPT_NCAM =
    {TOK_ID_NOT_CAM,"/!CAM2",TYPE_0,          {E,  E,  2,  E}};

OPT OPT_FDT =
    {TOK_ID_FDT,    "/FDT",  TYPE_0,          {E,  E,  2,  E}};

OPT OPT_NFDT =
    {TOK_ID_NOT_FDT,"/!FDT", TYPE_0,          {E,  E,  2,  E}};

OPT OPT_GEO =
    {TOK_ID_GEO,    "/GEO:", TYPE_GEOMETRY,   {E,  E,  2,  E}};

OPT OPT_SMS =
    {TOK_ID_SMS,    "/SMS",  TYPE_0,          {E,  E,  2,  E}};

OPT OPT_NSMS =
    {TOK_ID_NOT_SMS,"/!SMS", TYPE_0,          {E,  E,  2,  E}};

OPT OPT_END =
    {TOK_ID_END,    "\0",    TYPE_0,          {O,  O,  O,  O}};



/*
**   The following is a generic OPTIONTABLE for ADDs which support disk
**   devices.
*/

OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    {(POPT) &OPT_ADAPTER,

/*
**   This table currently supports /P, to change to /S comment out &OPT_PORT
**   and remove the comment from &OPT_SLOT
*/
     (POPT) &OPT_PORT,
/*   (POPT) &OPT_SLOT, */

     (POPT) &OPT_UNIT,
     (POPT) &OPT_CAM,
     (POPT) &OPT_NCAM,
     (POPT) &OPT_FDT,
     (POPT) &OPT_NFDT,
     (POPT) &OPT_GEO,
     (POPT) &OPT_SMS,
     (POPT) &OPT_NSMS,
     (POPT) &OPT_END
    }
};
