/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = SOCDB.H
 *
 * DESCRIPTIVE NAME = Internal data structures for IOCTL handling in
 *                    the OS/2 CD-ROM Device Mgr.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Sony Vendor Unique Command Codes (group 6 commands)
*/
#define SONY_READ_TOC      0xC1
#define SONY_READ_SUB      0xC2
#define SONY_READ_HEADDER  0xC3
#define SONY_PLAY_STATUS   0xC4
#define SONY_PAUSE         0xC5
#define SONY_PLAY_TRACK    0xC6
#define SONY_PLAY_MSF      0xC7
#define SONY_PLAY_AUDIO    0xC8
#define SONY_PLAY_CONTROL  0xC9

/*
** Sony Vendor Unique Command Descriptor Blocks
*/
/******************************
 * Read TOC             0xC1  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 5;
   UCHAR    LUN        : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;

   UCHAR    track_number;

   UCHAR    reserved_5;

   UCHAR    alloc_length_msb;
   UCHAR    alloc_length_lsb;

   UCHAR    control;

} SONY_CDB_ReadTOC, FAR *pSONY_CDB_ReadTOC;

/*
** Sony Table of Contents Data.
*/

typedef struct {

   UCHAR    toc_length_msb;
   UCHAR    toc_length_lsb;

   UCHAR    first_track;
   UCHAR    last_track;

} SONY_DATA_TOCHeader;

typedef struct {

   SONY_DATA_TOCHeader  TOC_Header;

   UCHAR    track_number;

   UCHAR    control     : 4;
   UCHAR    reserved_1  : 4;

   UCHAR    track_address_3;
   UCHAR    track_address_2;
   UCHAR    track_address_1;
   UCHAR    track_address_0;

} SONY_DATA_TOC, FAR *pSONY_DATA_TOC;


/******************************
 * READ Sub-Channel     0xC2  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 4;
   UCHAR    LUN        : 4;

   UCHAR    reserved_2 : 6;
   UCHAR    Sub_Q      : 1;
   UCHAR    reserved_3 : 1;

   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;

   UCHAR    alloc_length_msb;
   UCHAR    alloc_length_lsb;

   UCHAR    control;

} SONY_CDB_ReadSub, FAR *pSONY_CDB_ReadSub;

/*
** Sony Read Sub-Channel Data.
*/

typedef struct {

   UCHAR    control    : 4;
   UCHAR    reserved_1 : 4;

   UCHAR    track_number;
   UCHAR    index_number;

   UCHAR    relative_2;
   UCHAR    relative_1;
   UCHAR    relative_0;

   UCHAR    absolute_2;
   UCHAR    absolute_1;
   UCHAR    absolute_0;

} SONY_DATA_ReadSub, FAR *pSONY_DATA_ReadSub;


/******************************
 * Read Header          0xC3  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 4;
   UCHAR    LUN        : 4;

   ULONG    LBA;

   UCHAR    reserved_2;

   UCHAR    alloc_length_msf;
   UCHAR    alloc_length_lsf;

   UCHAR    control;

} SONY_CDB_ReadHeader;

/*
** Sony Read Header Data.
*/

typedef struct {

   UCHAR    amin;
   UCHAR    asec;
   UCHAR    aframe;

   UCHAR    cd_mode;

} SONY_DATA_Header, FAR *pSONY_DATA_Header;


/******************************
 * Play Status          0xC4  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 4;
   UCHAR    LUN        : 4;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;


   UCHAR    alloc_length_msb;
   UCHAR    alloc_length_lsb;

   UCHAR    control;

} SONY_CDB_PlayStatus, FAR *pSONY_CDB_PlayStatus;

/*
** Sony Play Status Data.
*/

typedef struct {

   UCHAR    reserved_1;
   UCHAR    reserved_2;

   UCHAR    data_length_msb;
   UCHAR    data_length_lsb;

   UCHAR    audio_status;

   UCHAR    control    : 4;
   UCHAR    reserved_3 : 4;

   ULONG    cd_address;

   UCHAR    output0_chan : 4;
   UCHAR    reserved_4   : 4;
   UCHAR    output0_vol;

   UCHAR    output1_chan : 4;
   UCHAR    reserved_5   : 4;
   UCHAR    output1_vol;

   UCHAR    output2_chan : 4;
   UCHAR    reserved_6   : 4;
   UCHAR    output2_vol;

   UCHAR    output3_chan : 4;
   UCHAR    reserved_7   : 4;
   UCHAR    output3_vol;

} SONY_DATA_PlayStatus, FAR *pSONY_DATA_PlayStatus;

/*
** Sony Audio Status definitions
*/
#define SONY_PLAY_IN_PROGRESS    0x00
#define SONY_PLAY_PAUSED         0x01
#define SONY_PLAY_MUTE           0x02
#define SONY_PLAY_COMPLETE       0x03
#define SONY_PLAY_ERROR          0x04


/******************************
 * Pause                0xC5  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 4;
   UCHAR    pause      : 1;
   UCHAR    LUN        : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;
   UCHAR    reserved_8;

   UCHAR    control;

} SONY_CDB_Pause, FAR *pSONY_CDB_Pause;


/******************************
 * Play MSF             0xC7  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 5;
   UCHAR    LUN        : 3;

   UCHAR    reserved_2;

   UCHAR    start_min;
   UCHAR    start_sec;
   UCHAR    start_frame;

   UCHAR    end_min;
   UCHAR    end_sec;
   UCHAR    end_frame;

   UCHAR    control;

} SONY_CDB_PlayMSF, FAR *pSONY_CDB_PlayMSF;


/******************************
 * Play Control         0xC9  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1 : 5;
   UCHAR    LUN        : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;

   UCHAR    parm_length_msb;
   UCHAR    parm_length_lsb;

   UCHAR    control;

} SONY_CDB_PlayControl, FAR *pSONY_CDB_PlayControl;


/*
** Play Control Data Format
*/

typedef struct {

   UCHAR    reserved_1;
   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;
   UCHAR    reserved_8;
   UCHAR    reserved_9;
   UCHAR    reserved_10;

   UCHAR    output0_select : 4;
   UCHAR    reserved_11    : 4;
   UCHAR    output0_volume;

   UCHAR    output1_select : 4;
   UCHAR    reserved_12    : 4;
   UCHAR    output1_volume;

   UCHAR    output2_select : 4;
   UCHAR    reserved_13    : 4;
   UCHAR    output2_volume;

   UCHAR    output3_select : 4;
   UCHAR    reserved_14    : 4;
   UCHAR    output3_volume;

} SONY_DATA_PlayControl, FAR *pSONY_DATA_PlayControl;

