/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = CDGENCB.H
 *
 * DESCRIPTIVE NAME = Internal control blocks for OS/2 CD-ROM Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
struct vendor_id_entry {
        UCHAR   *vendor_id_string;
        USHORT  vendor_id_code;
};

struct product_id_entry {
        UCHAR   *product_id_string;
        USHORT  product_id_code;
};

struct drive_caps_entry {
        USHORT  product_id_code;
        USHORT  capabilities;
};

/*
** vendor_id_code definitions
*/
#define TOSHIBA         0x01
#define SONY            0x02
#define HITACHI         0x03
#define NEC             0x04
#define TEXEL           0x05
#define MATSHITA        0x06                    /* PANASONIC            */
#define CHINON          0x07
#define PIONEER         0x08
#define IBM             0x09
#define LMS             0x0A

/*
** product_id_code definitions
*/
#define TOSHIBA_3201    0x01
#define TOSHIBA_3301    0x02
#define TOSHIBA_3401    0x03
#define SONY_541        0x11    /* Sony 541, 7211                       */
#define SONY_561        0x12
#define HITACHI_3750    0x21    /* Hitachi 3750                         */
#define HITACHI_6750    0x22    /* Hitachi 6750                         */
#define NEC_84_1        0x31    /* NEC 84-1                             */
#define NEC_260_17B     0x32    /* NEC 260 drive not ATAPI 1.2          */
#define TEXEL_3024      0x41    /* Texel 3024, 5024                     */
#define TEXEL_3024K     0x42    /* Texel 3024, 5024 with Kodak Photo CD */
#define PANASONIC_501   0x51    /* Panasonic 501                        */
#define CHINON_535      0x61    /* Chinon 535                           */
#define PIONEER_604X    0x71    /* Pioneer 604X                         */
#define LMS_215         0x91    /* LMS 215                              */


struct  Channel {                               /* audio channel info   */
        UCHAR   input_0;
        UCHAR   volume_0;
        UCHAR   input_1;
        UCHAR   volume_1;
        UCHAR   input_2;
        UCHAR   volume_2;
        UCHAR   input_3;
        UCHAR   volume_3;
};

struct Status {                                 /* audio status info    */
        USHORT          paused          : 1;
        USHORT          bits1           : 15;
        struct
        RedBookAddress  last_start_location;
        struct
        RedBookAddress  last_end_location;
};

struct Audio {                                  /* all audio info       */
        struct
        Status  status;
        struct
        Channel channel;
        USHORT  capabilities;
};

/* Drive capabilities bit definitions */

#define DCAPS_DOOR_LOCKED                0x0001
#define DCAPS_UNCERTAIN_MEDIA            0x0002
#define DCAPS_VARIABLE_VOLUME            0x0004
#define DCAPS_MUTE                       0x0008
#define DCAPS_INDEPENDENT_VOLUME_LEVELS  0x0010
#define DCAPS_NO_AUDIO_CTRL_DURING_PLAY  0x0020
#define DCAPS_NO_CHANNEL_SWAP            0x0040
#define DCAPS_XA                         0x0080
#define DCAPS_CDDA                       0x0100
#define DCAPS_NO_ADR_RETURNED            0x0200
#define DCAPS_UPC                        0x0400
#define DCAPS_UPC_IN_BCD                 0x0800
#define DCAPS_UPC_IN_ASCII               0x1000
#define DCAPS_MODE_WITH_ERR_RECOV        0x2000
#define DCAPS_MULTISESSION               0x4000
#define DCAPS_MULTISESSION_MOUNTED       0x8000

/*
        USHORT  door_locked                : 1,
                uncertain_media            : 1,
                variable_volume            : 1,
                mute_support               : 1,
                independent_volume_levels  : 1,
                no_audio_ctrl_during_play  : 1,
                no_channel_swap            : 1,
                xa_support                 : 1,
                cdda_support               : 1,
                no_adr_returned            : 1,
                upc_supported              : 1,
                upc_in_bcd                 : 1,
                upc_in_ascii               : 1,
                mode_with_err_recov        : 1,
                multi_session_support      : 1,
                multi_session_mounted      : 1;
};
*/

struct DeviceInfo {
        USHORT vendor_id_code;
        USHORT product_id_code;
        USHORT interface_type;
        USHORT current_block_size;
        USHORT raw_block_size;
        USHORT current_density;
        USHORT disk_density;
        USHORT current_disk_type;
        ULONG  last_session_addr;
        ULONG  volume_descr_terminator;
        USHORT last_cmd;
        USHORT playing;
        struct
        Audio  Audio;
        union
        AddressType leadout;
};

#define DISK_TYPE_CDROM 0
#define DISK_TYPE_CDXA  1
#define DISK_TYPE_CDDA  2

/* interface_type definitions */
#define  INTERFACE_SCSI         0x01
#define  INTERFACE_ATAPI        0x02
#define  INTERFACE_PROPRIETARY  0x03



struct  BlockParameters {
        union
        USHORTB   block_size;
        USHORT    density_code;
};


/*
**
** Unit Control Block
** ------------------
**
** This control blocks relates hardware devices to the Adapter
** Dependent Driver which manages them.
**
*/

typedef struct _PRTYQ
{
  NPIORB    Head;
  NPIORB    Tail;
} PRTYQ;

#define  NUM_RLE_QUEUES        9
#define  NUM_RP_QUEUES         2

typedef struct _UnitControlBlock
{
  NPUNITCB    pNextUnitCB;                /* Pointer to Next UnitCB       */
  USHORT      Flags;                      /* UnitCB Flags                 */
  USHORT      LogDriveNum;                /* Logical  Drive Number        */
  USHORT      PhysDriveNum;               /* Physical Drive Number        */
  UNITINFO    UnitInfo;                   /* Additional Driver Info       */
  struct
  DeviceInfo  DeviceInfo;                 /* Device Information Block     */
  struct
  Inquiry_Data InquiryData;               /* Device Inquiry Data          */
  UCHAR       Pad;                        /* Word align                   */
  USHORT      ADDHandle;                  /* ADD handle                   */
  USHORT      AdapterNumber;              /* Logical Adapter Number       */
  ULONG       TotalSectors;               /* Total Sectors for this drive */
  ULONG       Reserved;                   /* Read capacity Block Length   */
  USHORT      MaxHWSGList;                /* Max HW scatter/gather list   */
  NPIORBH     pDedicatedIORB;             /* Dedicated IORB for this unit */
  VOID (FAR * AdapterDriverEP)();         /* ADD Entry Point              */
  USHORT      NumReqsInProgress;          /* # of requests in progress    */
  USHORT      NumReqsWaiting;             /* Number of requests waiting   */
  NPIORBH     InProgressQueue;            /* Queue of in progress requests*/
  PRTYQ       WaitingQueue;               /* Priority Queues              */

} UNITCB;

/* Flag definitions for Flags field in UNITCB */
#define UCF_IORB_ALLOCATED  0x0001        /* Dedicated IORB allocated       */
#define UCF_HW_SCATGAT      0x0002        /* Unit supports ScatGat in HW    */
#define UCF_16M             0x0004        /* Unit supports > 16M addressing */
#define UCF_CHS_ADDRESSING  0x0008        /* Unit supports CHS Addressing   */
#define UCF_REMOVABLE_NON_FLOPPY  0x0010  /* Removable, non floppy          */
#define UCF_UNCERTAIN_MEDIA 0x0020        /* Uncertain media                */
#define UCF_AUDIO_SUPPORTED 0x0040        /* Audio command set supported    */


/*
** IORB DMWorkSpace Structure
*/

typedef struct _IORB_DMWORK
{
   NPUNITCB      pUnitCB;
   USHORT        Reserved_1;
   PBYTE         pRequest;
   SCATGATENTRY  SGList;
   NPIORB        WaitingQueueLink;
   NPIORB        pCoReqIORB;

} IORB_DMWORK, FAR *PIORB_DMWORK, NEAR *NPIORB_DMWORK;



typedef struct _DRIVERENTRY
{
   UCHAR        DriverName[17];
   PFN          AdapterDriverEP;
} DRIVERENTRY;


typedef struct _DRIVERTABLE
{
   USHORT       NumDrivers;
   DRIVERENTRY  DriverEntry[MAX_DRIVERS];
} DRIVERTABLE;


/*
** Init data allocated at the end of the data segment has the
** following structure:
*/

#define MAX_DEVICE_TABLE_SIZE 1024
/*
**      (sizeof(DEVICETABLE) + ((MAX_ADAPTERS_PER_ADD - 1) * 2) +
**      ((sizeof(ADAPTERINFO) - sizeof(UNITINFO)) * MAX_ADAPTERS_PER_ADD) +
**      sizeof(UNITINFO) * MAX_UNITS_PER_ADD)
*/
typedef struct _INITDATA
{
   UCHAR           ScratchBuffer2[MAX_DEVICE_TABLE_SIZE];  /* Scratch buffer  */
   UCHAR           ScratchIORB[MAX_IORB_SIZE]; /* IORB used during init       */
   RP_RWV          InitPkt;                    /* RP used during init         */
} INITDATA;


