/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDDEFS.H
 *
 * DESCRIPTIVE NAME = Typedefs/Defines for OS/2 CD-ROM Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*------------------------------*
 * Common typedefs              *
 *------------------------------*/
typedef struct _UnitControlBlock   UNITCB, *NPUNITCB;
typedef struct _VolChars           *NPVOLCHARS;
typedef struct _BPB                BPB;
typedef struct _PB_Read_Write      PB_Read_Write, FAR *PPB_Read_Write;
typedef struct _Req_List_Header    Req_List_Header, FAR *PReq_List_Header;

typedef struct _INITDATA     INITDATA;

#define MAX_DRIVE_LETTERS       26
#define MAX_QUEUING_COUNT       16
#define MAX_ADAPTERS_PER_ADD    16
#define MAX_UNITS_PER_ADD       32
#define MAX_IORBS_PER_DRIVE      8
#define MAX_IORBS_PER_POOL      64
#define INIT_POOL_SIZE          32 * 1024

/*
**** Device Types returned in Get Device Parms IOCTL
*/
#define TYPE_CDROM             0x07

#define CDROM_HSG_MODE         0x00
#define CDROM_REDBOOK_MODE     0x01

#define MODE_2                 0x02

#define COMMAND_INFO_MASK 0x01

/*
** Change Media Flags
*/
#define MEDIA_CHANGED           0xFF
#define MEDIA_UNSURE_CHANGED    0x00
#define MEDIA_UNCHANGED         0x01


#define CDROM_SECTOR_SIZE        2048
#define CDROM_LONG_SECTOR_SIZE   2352
#define CDDA_BLOCK_LENGTH        2352
#define TRACEBUF_SIZE             512
#define DEFAULT_CYLINDER_COUNT 0xFFFF

#define CDROM_MUTE                0x00
#define CDROM_LEFT_CHANNEL        0x01
#define CDROM_RIGHT_CHANNEL       0x02
#define CDROM_STEREO              0x03

#define CDBF_PAUSE                0x00
#define CDBF_RESUME               0x01
#define CDBF_START                0x01
#define CDBF_EJECT                0x02
#define CDBF_CLOSE_TRAY           0x03
#define CDBF_PREVENT_REMOVAL      0x01
#define CDBF_LOCK_DOOR            0x01


#define LEAD_OUT_TRACK_NUMBER     0xAA

#define PRIMARY_VOL_DESCR_RBA     0x10
#define VOL_DESCR_TERMINATOR      0xFF

/*----------------------------------------------------*
 * Global DDFlags defines                             *
 *----------------------------------------------------*/
#define CDF_INIT_TIME           0x00000002    /* Init time flag           */
#define CDF_QUIET               0x00000004    /* Quiet error fail at init */
#define CDF_VERBOSE             0x00000008    /* verbose display at init  */

/*
** MACROS
*/
#define ENABLE  _asm {sti}
#define DISABLE _asm {cli}
#define PUSHFLAGS _asm {pushf}
#define POPFLAGS _asm {popf}

/*                                                                      @V91985
** Not   Ready Defs                                                     @V91985
*/                                                                   /*@V91985*/
#define NO_SECONDS_BEFORE_ERROR  6                                   /*@V91985*/
#define MAX_NOT_READY_RETRIES    ( NO_SECONDS_BEFORE_ERROR * 4 )     /*@V91985*/
#define NOT_READY_WAIT           250                                 /*@V91985*/

/*                                                                     @V91985
** ASC not in SCSI.h                                                   @V91985
*/                                                                   /*@V91985*/
#define ASC_MEDIUM_NOT_PRESENT   0x3A                                /*@V91985*/


