/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDDATA.C
 *
 * DESCRIPTIVE NAME = Static/Initialization data for CD-ROM Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_ERROR_H

#include "os2.h"
#include "misc.h"
#include "cddefs.h"
#include "strat2.h"
#include "reqpkt.h"
#include "iorb.h"
#include "scsi.h"
#include "cdbscsi.h"
#include "cdgencb.h"

/*
**  GLOBAL DATA
**  -----------
**  1. Static data
**  2. Dynamic data allocated at init time:
**     - UnitCB
**  3. Dynamic data allocated at run time:
**     - IORB
**  4. Static init data discarded after init time
*/

#define MAXADAPTERDRIVERS       32         /* Max adapter device drivers     */


PFN             Device_Help=0L;            /* far ptr to devhelp function    */
PBYTE           pSysInfoSeg=0L;            /* Pointer to sys info seg        */
PVOID           pDataSeg=0L;               /* virt ptr of our data segment   */
ULONG           ppDataSeg=0L;              /* phys addr of our data segment  */
ULONG           plDataSeg=0L;              /* linear addr of our data seg    */
USHORT          ScratchBufSem=0;           /* Semaphore for ScratchBuffer    */
USHORT          CDFlags=0;                 /* Global driver flags            */

NPUNITCB        UnitCB_Head=0;             /* near ptr to first UnitCB       */

NPBYTE          pNextFreeCB=0;             /* ptr to next free control blk   */

USHORT          NumDrivers=0;              /* number of adapter drivers      */
USHORT          NumUnitCBs=0;              /* number of unit control blocks  */
USHORT          NumCDROMDrives=0;          /* number of CD-ROM drives        */
USHORT          FirstDriveNumber=0;        /* First CD-ROM drive number      */
USHORT          NumAdapters=0;             /* number of adapters             */
USHORT          CD_NumReqsInProgress=0;    /* num requests in progress       */
USHORT          CD_NumReqsWaiting=0;       /* num requests on waiting queues */
USHORT          TraceFlags=0;              /* Trace Flags                    */
NPBYTE          pCDTraceBuf=0;             /* pointer to internal trace buffer*/
NPBYTE          pCDTraceHead=0;            /* pointer to head of trace buffer */
NPBYTE          pCDTraceEnd=0;             /* pointer to end of trace buffer */

NPBYTE          CB_FreeList=0;             /* Control Block Free List for    */
                                           /*  IORBs and CWAs                */

USHORT          PoolSem=0;                 /* Pool semaphore                 */
USHORT          PoolSize=0;                /* Size of control block pool     */
USHORT          FreePoolSpace=0;           /* Free space left in pool        */
USHORT          CodeBreakAddress=0;        /* end of code segment address    */
USHORT          DataBreakAddress=0;        /* end of data segment address    */

NPBPB InitBPBArray[MAX_DRIVE_LETTERS]={0}; /*BPB array returned in INIT packet*/

BPB  DefaultBPB = {2048, 1, 0, 0, 0, 0, 0xF0, 0, 0xFFFF, 1, 0, 270000L, 0};

UCHAR  volume_id_string[] = "CD001";

/*
** Default CDB Passthru IORB
*/
IORB_CDB  default_iorb_cdb = {

   sizeof(IORB_ADAPTER_PASSTHRU),            /* IORB Length                */
   0,                                        /* Unit Identifier            */
   IOCC_ADAPTER_PASSTHRU,                    /* Command Code               */
   IOCM_EXECUTE_CDB,                         /* Command Modifier           */
   IORB_ASYNC_POST + IORB_REQ_STATUSBLOCK,   /* Request Control Flags      */
   0,                                        /* Status                     */
   0,                                        /* Error Code                 */
   0,                                        /* Cmd completion timeout (s) */
   sizeof(SCSI_STATUS_BLOCK),                /* Status block length        */
   0,                                        /* Status block               */
   0,                                        /* Reserved, MBZ              */
   0,                                        /* Pointer to next IORB       */
   0,                                        /* Notification Address       */
   0,                                        /* For use by DM              */
   0,                                        /* For use by ADD             */

   1,                                        /* Count of S/G list elements */
   0,                                        /* far ptr to S/G List        */
   0,                                        /* physical addr of S/G List  */
   0,                                        /* Length of CDB              */
   0,                                        /* Pointer to CDB             */
   0,                                        /* phys ptr to SCB            */
   0                                         /* Flags                      */
};

/*
**  UnitCBs are allocated after all static data
*/
UNITCB          FirstUnitCB[1]={0};     /* First UnitCB allocated here       */

USHORT          CBPool[24*KB]={0};      /* Pool for Control blocks           */

