/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)cdchinon.c  6.17 92/05/04";*/
#define SCCSID  "@(#)cdchinon.c  6.17 92/05/04"

/************************************************************************/
/*                                                                      */
/* Driver Name: OS2CDROM.DMD - OS/2 CD-ROM Device Manager               */
/*              -----------------------------------------               */
/*                                                                      */
/* Source File Name: CDCHINON.C                                         */
/*                                                                      */
/* Descriptive Name: Vendor unique command processing for Chinon        */
/*                   SCSI-2 CD-ROM Drives                               */
/*                                                                      */
/* Function:                                                            */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/* provided to you solely for the purpose of assisting you in           */
/* the development of your applications. The code is provided           */
/* "AS IS", without warranty of any kind. IBM shall not be liable       */
/* for any damages arising out of your use of this code, even if        */
/* they have been advised of the possibility of such damages.           */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/* Change Log                                                           */
/*                                                                      */
/* Mark    Date      Programmer  Comment                                */
/* ----    ----      ----------  -------                                */
/* @nnnn   mm/dd/yy  NNN                                                */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "cdh.h"
#include "cdchinon.h"


/*------------------------------------------------------------------------
;
;** Chinon_GetLastSessionAddr - Get address of last session on multisession
;                               disk
;
;   This routine returns the address of the last session of a multisession
;   photo CD disk.  This routine should only be called is the drive is
;   a Chinon 535.
;
;   USHORT Chinon_GetLastSessionAddr(NPUNITCB pUnitCB, ULONG FAR * session_addr)
;
;   ENTRY:    pUnitCB          - Pointer to UnitCB
;             session_addr     - Pointer to returned session addr
;
;   RETURN:   USHORT           - Packet status word
;
;                                if the STERR bit is on, then the disk
;                                  is not a multisession disk and the
;                                  session_addr field is not valid
;
;                                if the STERR bit is NOT set, then the
;                                  disk is a multi-session disk and the
;                                  session addr field is valid
;
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT Chinon_GetLastSessionAddr (pUnitCB, session_addr)

NPUNITCB pUnitCB;
ULONG    FAR *session_addr;

{
   USHORT rc;
   NPIORB_CDB pIORB;
   struct CHINON_LastSessionData NEAR *pCDBData;
   union ULONGB  ul_LBA;

   Chinon_BuildCDB_GetLastSession (pUnitCB, (NPIORB_CDB FAR *) &pIORB);

   pCDBData = (struct CHINON_LastSessionData NEAR *) pIORB->CDB_data;

   rc = SubmitIORB_Wait(pUnitCB, pIORB);

   if (rc == STDON)
   {

      /* If zero returned in data fields, then not multisession */

      if (pCDBData->LBA.dword == 0)
      {
         rc = STDON + STERR;
      }
      else
      {
         ul_LBA.ulbytes.byte_3 =  pCDBData->LBA.ulbytes.byte_0;
         ul_LBA.ulbytes.byte_2 =  pCDBData->LBA.ulbytes.byte_1;
         ul_LBA.ulbytes.byte_1 =  pCDBData->LBA.ulbytes.byte_2;
         ul_LBA.ulbytes.byte_0 =  pCDBData->LBA.ulbytes.byte_3;

         *session_addr = ul_LBA.dword;
      }

   }
   FreeIORB (pUnitCB, pIORB);
   return (rc);
}






