;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.386p

include devhelp.inc
include devhdr.inc


;   EXTRN  _DevHlp : DWORD
   EXTRN  _Device_Help : DWORD


;NULL            SEGMENT WORD PUBLIC 'BEGDATA' USE16
;NULL            ENDS

_DATA           SEGMENT WORD PUBLIC 'DATA' USE16
_DATA           ENDS

_BSS            SEGMENT WORD PUBLIC 'BSS' USE16
_BSS            ENDS

FAR_BSS         SEGMENT WORD PUBLIC 'FAR_BSS' USE16
FAR_BSS         ENDS

CONST           SEGMENT WORD PUBLIC 'CONST' USE16
CONST           ENDS

LAST_DATA       SEGMENT WORD PUBLIC 'LAST_DATA' USE16
                public _last_data_byte, _traceflag
_traceflag      db 0
_last_data_byte db 0
LAST_DATA       ENDS

_TEXT           SEGMENT WORD PUBLIC 'CODE' USE16
   EXTRN  _CDStrat1:near
_TEXT           ENDS

RMCode          SEGMENT WORD PUBLIC 'CODE' USE16
RMCode          ENDS
code            SEGMENT WORD PUBLIC 'CODE' USE16
code            ENDS

END_TEXT        SEGMENT WORD PUBLIC 'CODE' USE16
                public _last_code_byte
_last_code_byte db 0
END_TEXT        ENDS

;DGROUP  GROUP NULL, CONST, _BSS, FAR_BSS, _DATA, LAST_DATA
DGROUP  GROUP CONST, _BSS, _DATA, FAR_BSS, LAST_DATA
CGROUP  GROUP _TEXT,RMCode, code,END_TEXT

LAST_DATA       SEGMENT WORD PUBLIC 'LAST_DATA' USE16
LAST_DATA       ENDS


_DATA           SEGMENT WORD PUBLIC 'DATA' USE16
   ASSUME CS:CGROUP, DS:DGROUP, ES:NOTHING, SS:NOTHING

                public DiskDDHeader

DiskDDHeader   dd      -1
               dw      DEVLEV_3 + DEV_CHAR_DEV
               dw      _CDStrat1
               dw      0
               db      "MITSUMI$"
               dw      0
               dw      0
               dw      0
               dw      0
               dd      DEV_ADAPTER_DD
               dw      0

   _lsw_phys_add     DW 0
   _msw_phys_add     DW 0

_DATA           ENDS

_TEXT           SEGMENT WORD PUBLIC 'CODE' USE16
   ASSUME CS:CGROUP, DS:DGROUP, ES:NOTHING, SS:NOTHING

; ================================================================== ;
;                                                                    ;
; /* Function : 15 Hex */                                            ;
;                                                                    ;
;  FARPOINTER DevHelp_PhysToVirt( FARPOINTER physAdr, USHORT len )   ;
;                                                                    ;
; ------------------------------------------------------------------ ;
;                                                                    ;

Phys2Virt_PhysAdrLo     EQU   [BP+4]
Phys2Virt_PhysAdrHi     EQU   [BP+6]
Phys2Virt_Len           EQU   [BP+8]

_DevHelp_PhysToVirt PROC NEAR
   PUBLIC _DevHelp_PhysToVirt

      PUSH     BP
      MOV      BP,SP

      PUSH     DI
      PUSH     ES

      MOV      AX,WORD PTR Phys2Virt_PhysAdrHi
      MOV      BX,WORD PTR Phys2Virt_PhysAdrLo
      MOV      CX,WORD PTR Phys2Virt_Len
      MOV      DH,1
      MOV      DL,DH_PhysToVirt

      CALL     [_Device_Help]

      JC       ptverr

      MOV      DX,ES
      MOV      AX,DI
      JMP      SHORT ptv90

ptverr:
      SUB      DX,DX
      SUB      AX,AX

ptv90:
      POP      ES
      POP      DI
      POP      BP

      RET

_DevHelp_PhysToVirt ENDP






; ==================================================================== ;
;                                                                      ;
;  DevHelp_Block( ULONG BlockID, ULONG TimeLimit, UCHAR IntFlag )      ;
;                                                                      ;
;     This routine block the current event                             ;
;                                                                      ;
;  input :                                                             ;
;     BlockID :                                                        ;
;     TimeLimit :                                                      ;
;     IntFlag :                                                        ;
;                                                                      ;
;  output :                                                            ;
;                                                                      ;
; -------------------------------------------------------------------- ;
;                                                                      ;

BlockIDLo         EQU   +4[BP]
BlockIDHi         EQU   +6[BP]
BlockTimeLimitLo  EQU   +8[BP]
BlockTimeLimitHi  EQU   +10[BP]
BlockIntFlag      EQU   +12[BP]

_DevHelp_Block          PROC
   PUBLIC _DevHelp_Block

      PUSH  BP
      MOV   BP,SP

      PUSH  DI

      MOV   BX,BlockIDLo
      MOV   AX,BlockIDHi
      MOV   CX,BlockTimeLimitLo
      MOV   DI,BlockTimeLimitHi
      MOV   DH,BlockIntFlag
      MOV   DL,DH_Block

      CALL  [_Device_Help]
;;      cmp   al,0
      jnc   blockrun
      jz    blocktimeout
      jnz   blockinterrupt
      mov   ax,3                        ; should NEVER get this
      jmp   blockdone
blocktimeout:
      mov   ax,1                        ; well, we timed out...
      jmp   blockdone
blockrun:                               ; all ok, run was done
      mov   ax,0
      jmp   blockdone
blockinterrupt:                         ; oops, interrupted
      mov   ax,2
blockdone:
      POP   DI
      POP   BP

      RET

_DevHelp_Block          ENDP

RunIDLo        EQU +4[BP]
RunIDHi        EQU +6[BP]

_DevHelp_Run            PROC
   PUBLIC _DevHelp_Run

      PUSH  BP
      MOV   BP,SP

      MOV   BX,RunIDLo
      MOV   AX,RunIDHi
      MOV   DL,DH_Run

      CALL  [_Device_Help]

      JC    run90
      SUB   AX,AX

run90:
      POP   BP

      RET

_DevHelp_Run            ENDP


_DevHelp_GetDosVar PROC
        PUBLIC _DevHelp_GetDosVar
        push bp
        mov  bp,sp
        mov AX,[bp+4]
        mov cx,1                        ; disk device types
        mov DL,DH_GetDOSVar
        CALL [_Device_Help]
        cmp word ptr [bp+4],1
        jne done
        mov es,ax
        mov ax,es:[bx]
        mov bx,0
done:
        mov DX,AX
        mov AX,BX
        pop  bp
        ret
_DevHelp_GetDosVar endp

_DevHelp_Yield PROC
        PUBLIC _DevHelp_Yield
        pushF
        mov dl,DH_Yeild
        CALL [_Device_Help]
        popF
        ret

_DevHelp_Yield endp

_DevHelp_RAS PROC
        PUBLIC _DevHelp_RAS
        push    bp
        mov     bp,sp
        push    si
        cmp     _Traceflag,1
        jne     notrace
        mov dl,DH_RAS
        push ds
        pop  es
        mov     ax, [bp+4]
        mov     cx, [bp+6]
        mov     bx, [bp+8]
        lds     si, [bp+10]

        CALL es:[_Device_Help]
        push    es
        pop     ds
notrace:
        pop     si
        pop     bp
        ret

_DevHelp_RAS   endp

_DevHelp_DisplayMsg proc
        public _DevHelp_DisplayMsg
        push    bp
        mov     bp,sp
        lds     si,[bp+4]; 
        mov     bx,0
        mov     dl,DH_SAVE_MESSAGE
        CALL    [_Device_Help]
        pop     bp
        ret
_DevHelp_DisplayMsg endp

_DevHelp_RegisterDeviceClass PROC
        PUBLIC _DevHelp_RegisterDeviceClass
        push    bp
        mov     bp,sp
        push    es                      ; save ES
        push    ds                      ; save DS
        push    ds                      ; get DS
        pop     es                      ; into ES
        LDS     SI,[bp+4]               ; DS:SI = Ptr ADD to ASCIIZ name        [4][6]
                                        ;         maximum of 16 chars
        MOV     AX,[bp+10]              ; AX:BX = Ptr to ADD's Direct Call      [8]
        mov     BX,[bp+8]               ;         Command Handler               [10]
        MOV     DI,[bp+12]              ; Must be 0 for ADDs                    [12]
        MOV     CX,[bp+14]              ; Must be 1 for ADDs                    [14]
        MOV     DL,DH_RegisterDeviceClass
        CALL    es:[_Device_Help]
        jnc     handleok                ; if no error done
        mov     ax,0                    ; set error
handleok:
        pop     ds                      ; restore DS
        pop     es                      ; restore ES
        pop     bp                      ; restore BP
        ret                             ; return
_DevHelp_RegisterDeviceClass endp

_DevHelp_AllocGdtSel proc
        public  _DevHelp_AllocGdtSel
        push    bp
        mov     bp,sp
        les     di,[bp+4]
        mov     cx,word ptr [bp+8]
        mov     dl,DH_AllocGDTSelector
        CALL    [_Device_Help]
        jc      selerror
        mov     ax,0
selerror:
        pop     bp
        ret
_DevHelp_AllocGdtSel endp

_DevHelp_AllocPhys proc
        public  _DevHelp_AllocPhys
        push    bp
        mov     bp,sp
        mov     ax,[bp+6]
        mov     bx,[bp+4]
        mov     dh,byte ptr [bp+8]
        mov     dl,DH_AllocPhys
        CALL    [_Device_Help]
        les     di,[bp+10]
        jc      allocphyserr
        mov     word ptr es:[di],bx
        mov     word ptr es:[di+2],ax
        mov     ax,0
        jmp     allocphysdone
allocphyserr:
        mov     word ptr es:[di],0
        mov     word ptr es:[di+2],0
allocphysdone:
        pop     bp
        ret
_DevHelp_AllocPhys endp

_DevHelp_PhysToGDT proc
;
;       [bp+4] = physical (32 bits)
;       [bp+8] = size     (16 bits)
;       [bp+10] = selector (16 bits)
;
        public  _DevHelp_PhysToGDT
        push    bp
        mov     bp,sp
        mov     ax,[bp+6]
        mov     bx,[bp+4]
        mov     cx,[bp+8]
        mov     si,[bp+10]
        mov     dl,DH_PhysToGDTSelector
        CALL    [_Device_Help]
        jc      physgdterr
        mov     ax,0
physgdterr:
        pop     bp
        ret
_DevHelp_PhysToGDT endp

_DevHelp_Settimer proc
        public  _DevHelp_Settimer
        push    bp
        mov     bp,sp
        mov     ax,[bp+4]
        mov     dl,DH_SetTimer
        CALL    [_Device_Help]
        mov     ax,0
        jnc     stimernoerr
        mov     ax,1
stimernoerr:
        pop     bp
        ret
_DevHelp_Settimer endp


_DevHelp_SetIRQ proc
;
;       [bp+4] = offset of handler
;       [bp+6] = irq number (binary)
;       [bp+8] = shared/non shared flag 1 = shared, 0 = not shared
;
        public  _DevHelp_SetIRQ
        push    bp
        mov     bp,sp
        mov     ax,[bp+4]
        mov     bx,[bp+6]
        mov     dh, byte ptr [bp+8]
        mov     dl,DH_SetIRQ
        CALL    [_Device_Help]
        mov     ax,0
        jnc     noseterr
        mov     ax,1
noseterr:
        pop     bp
        ret
_DevHelp_SetIRQ endp

_DevHelp_UnsetIRQ proc
;
;       [bp+4] = offset of handler
;
        public  _DevHelp_UnsetIRQ
        push    bp
        mov     bp,sp
        mov     bx,[bp+4]
        mov     dl,DH_UnsetIRQ
        CALL    [_Device_Help]
        mov     ax,0
        jnc     noreseterr
        mov     ax,1
noreseterr:
        pop     bp
        ret
_DevHelp_UnsetIRQ endp

_DevHelp_EOI proc
;
;       [bp+4] = offset of handler
;
        public  _DevHelp_EOI
        push    bp
        mov     bp,sp
        mov     bx,[bp+4]
        mov     dl,DH_EOI
        CALL    [_Device_Help]
        mov     ax,0
        pop     bp
        ret
_DevHelp_EOI endp




_TEXT           ENDS
                END


