/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
 #define INCL_DOSINFOSEG
 #define INCL_NO_SCB
 #define INCL_INITRP_ONLY
 #include "os2.h"                  // \DRV6\H
 #include "cmd.h"
 #include <conio.h>

 #define Orchid_IRQ3          0x0008
 #define BinIrq3               3
 #define Orchid_IRQ5          0x0010
 #define BinIrq5               5
 #define Orchid_IRQ7          0x0018
 #define BinIrq7               7
 #define Orchid_IRQ9          0x0020
 #define BinIrq9               9
 #define Orchid_IRQ10         0x0028
 #define BinIrq10              10
 #define Orchid_IRQ11         0x0030
 #define BinIrq11              11
 #define Orchid_IRQ12         0x0038
 #define BinIrq12              12
 #define JazzPort300          0x00
 #define JazzPort320          0x10
 #define JazzPort340          0x20
 #define JazzPort360          0x30
 #define JazzIrqNone          0x00
 #define JazzIrq10            0x04
 #define JazzIrq11            0x08
 #define JazzIrq12            0x0C
 #define JazzCDPort           0x600
 #define JazzResetPort        0x6
 #define JazzDataPort         0xA
 #define JazzPresent          0xAA
 #define JazzResetCmd1        0xd0
 #define JazzResetCmd2        0x0
 #define ImportantBit         1

#define PortBase 0x220
#define PortBase_Adjust 0x20

#define Orchid_PSS_ID_VERS   4
#define Orchid_CD_ConfigPort 0x16
#define Orchid_DSP_Signature 0x4500
#define HighByteMask 0xff00

BOOL EnableOrchidASIC(USHORT Port, USHORT IRQ)
{
USHORT Addr,value,IrqMask=0;
BOOL rc=FALSE;

        for(Addr=PortBase; Addr<=PortBase+PortBase_Adjust;Addr+=PortBase_Adjust )
          {
          value=(inpw(Addr+Orchid_PSS_ID_VERS) & HighByteMask);
          if(value == Orchid_DSP_Signature)
            {
            switch(IRQ)
              {
              case BinIrq3:
                IrqMask=Orchid_IRQ3;
                break;
              case BinIrq5:
                IrqMask=Orchid_IRQ5;
                break;
              case BinIrq9:
                IrqMask=Orchid_IRQ9;
                break;
              case BinIrq10:
                IrqMask=Orchid_IRQ10;
                break;
              case BinIrq11:
                IrqMask=Orchid_IRQ11;
                break;
              case BinIrq12:
                IrqMask=Orchid_IRQ12;
                break;
              default:
                break;
              } /* end switch */
            outpw(Addr+Orchid_CD_ConfigPort,((Port<<4) & HighByteMask) | IrqMask);
            rc=TRUE;
            break;
            } /* end if */
          } /* end for */
     return rc;
}

BOOL EnableJazzASIC(USHORT Port, USHORT IRQ,USHORT Adapter)
{
UCHAR BitMask,i;
USHORT port,l,count;
BOOL Found=FALSE;
                outp(Adapter+JazzResetPort,JazzResetCmd1);
                for(l=0; l<255; l++) // delay just a little bit
                  {
                  i=inp(Adapter+JazzResetPort);
                  if( (i & 1) ==0)
                    {
                    i=inp(Adapter+JazzDataPort);
                    break;
                    } /* end if */
                  } /* end for */
                if(i==JazzPresent)
                  {
                  Found=TRUE;
                  switch(Port)
                    {
                    case 0x300:
                      BitMask=JazzPort300;
                      break;
                    case 0x320:
                      BitMask=JazzPort320;
                      break;
                    case 0x340:
                      BitMask=JazzPort340;
                      break;
                    case 0x360:
                      BitMask=JazzPort360;
                      break;
                    default:
                      BitMask=JazzPort300;
                      break;
                    } /* end switch */
                  switch(IRQ)
                    {
                    case BinIrq10:
                      BitMask|=JazzIrq10;
                      break;
                    case BinIrq11:
                      BitMask|=JazzIrq11;
                      break;
                    case BinIrq12:
                      BitMask|=JazzIrq12;
                      break;
                    default:
                      BitMask|=JazzIrqNone;
                      break;
                    } /* end switch */
                  for(i=0; i<6; i++)
                    {
                    outp(JazzCDPort,BitMask & ImportantBit);
                    BitMask>>=ImportantBit;
                    } /* end for */
                  } /* end if */
return FALSE;
}

VOID EnableASIC(USHORT Port, USHORT IRQ,USHORT type,USHORT Adapter)
{
     switch(type)
       {
       case 5:
         EnableOrchidASIC(Port,IRQ);          // enable orchid asic
         break;
       case 6:
         EnableJazzASIC(Port,IRQ,Adapter);            // if that failed, try jazz
         break;
       default:
         break;
       }
}
