/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506TYPE.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Locally defined structures for this driver.
 *
 * Purpose:
 *
 *
 *
 *
 *
*/#include "rmcalls.h"                                                /*@V98451*/

typedef struct _ACB  NEAR *NPACB, FAR *PACB;
typedef struct _UCB  NEAR *NPUCB;
typedef struct _ATBL NEAR *NPATBL;
typedef struct _UTBL NEAR *NPUTBL;

/*-------------------------------*/
/* Unit Control Block            */
/* ------------------            */
/*                               */
/* One per drive on controller.  */
/*                               */
/*-------------------------------*/

typedef struct _UCB
{
  /*-----------------------------------*/
  /* Associated Control Block Pointers */
  /*-----------------------------------*/
  NPACB            npACB;
  USHORT           Flags;
  USHORT           ReqFlags;

  /*--------------------*/
  /* Unit Number (0/1)  */
  /*--------------------*/
  USHORT           UnitId;
  USHORT           DiagStatus;

  /*------------------------------------------*/
  /* Physical/Logical Geometry for this drive */
  /*------------------------------------------*/
  GEOMETRY         LogGeom;
  GEOMETRY         PhysGeom;

  USHORT           WrtPreCmp;
  USHORT           SecPerBlk;

  /*------------------------------------------*/
  /* Replacement UNITINFO from Filter ADD     */
  /*------------------------------------------*/
  PUNITINFO        pUnitInfo;

  HDEVICE       hDevice;                                            /*@V98451*/

} UCB;

/* Flags definitions */
#define UCBF_ALLOCATED      0x0001
#define UCBF_READY          0x0002
#define UCBF_DIAG_FAILED    0x0004
#define UCBF_SMSENABLED     0x0008
#define UCBF_MULTIPLEMODE   0x0010
#define UCBF_LBAMODE        0x0020
#define UCBF_IDENTIFYFAIL   0x0040
#define UCBF_NODASDSUPPORT  0x0080
#define UCBF_ATAPI_DEVICE   0x0100                                 /*@V87325*/
#define UCBF_ONTRACK        0x0200                                  /*@V108555*/

/* ReqFlags definitions */
#define UCBR_RECAL          0x8000
#define UCBR_SETPARAM       0x4000


/*-------------------------------*/
/* Adapter Control Block         */
/* ---------------------         */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/


#define FI_MAX_REGS     12

typedef struct _ACB
{
  /*--------------------------------------*/
  /* IORB Queue for units on this adapter */
  /*--------------------------------------*/
  PIORBH        pHeadIORB;
  PIORBH        pFootIORB;
  PIORBH        pIORB;

  /*---------------------------------------------------*/
  /* Controller Register addresses/contents, IRQ level */
  /*---------------------------------------------------*/
  USHORT        IOPorts[FI_MAX_REGS];
  UCHAR         IORegs[FI_MAX_REGS];
  USHORT        IOPendingMask;

  USHORT        IntLevel;
  USHORT        SpuriousIRQ;
  USHORT        cResets;                                           /*@V77133*/

  /*-----------------*/
  /* State Variables */
  /*-----------------*/
  USHORT        UseCount;
  USHORT        State;
  USHORT        Flags;
  USHORT        ReqFlags;
  USHORT        ReqMask;

  USHORT        UnitId;
  NPUCB         npUCB;

  /*--------------------------------*/
  /* Current operation variables    */
  /*--------------------------------*/
  ULONG         StartRBA;
  ULONG         SecRemain;
  ULONG         SecDone;

  USHORT        SecReq;
  USHORT        SecToGo;
  USHORT        SecPerInt;

  USHORT        DataErrorCnt;
  USHORT        BusyTimeoutCnt;                                      /*@V85057*/
  USHORT        IORBStatus;
  USHORT        IORBError;

  ADD_XFER_IO   IOSGPtrs;

  /*--------------------------------*/
  /* Timer Flags/Values             */
  /*--------------------------------*/

  USHORT        TimerFlags;

  ULONG         ElapsedTime;
  ULONG         TimeOut;

  /*----------------------*/
  /* Timer Loop Counters  */
  /*----------------------*/
  ULONG         DelayedResetInterval;
  ULONG         DelayedResetCtr;
  ULONG         DelayedRetryInterval;
  ULONG         IRQTimeOut;
  USHORT        (FAR *IRQEntry)( VOID );                             /*@V87325*/

  /*--------------------------------------------------*/
  /* Timer Handles                                    */
  /*                                                  */
  /* (Also update TIMERS_PER_ACB when adding timers)  */
  /*--------------------------------------------------*/
  ULONG         IRQTimerHandle;
  ULONG         RetryTimerHandle;
  ULONG         ResetTimerHandle;



  /*-------------------------------------------------*/
  /* Unit Control Blocks - Unit specific information */
  /*-------------------------------------------------*/
  USHORT        cUnits;
  UCB           UnitCB[MAX_UNITS];


  /*-------------------------------------------------*/              /*@V87325*/
  /* Pause Resume Support                            */              /*@V87325*/
  /*-------------------------------------------------*/              /*@V87325*/
  PIORBH        pSuspendIORB;                                        /*@V87325*/
  PIORBH        pResumeIORB;                                         /*@V87325*/
  USHORT        ResourceFlags;                                       /*@V87325*/
  USHORT        (FAR *SuspendIRQaddr)();                             /*@V93531*/
  USHORT        CountUntilSuspend;                                   /*@V87325*/

} ACB;

#define TIMERS_PER_ACB  3

#define TIMER_POOL_SIZE  (sizeof(ADD_TIMER_POOL) +                        \
                           ((TIMERS_PER_ACB * MAX_ADAPTERS) - 0)          \
                             * sizeof(ADD_TIMER_DATA))

/* ACB->Flags values */

#define ACBF_INTERRUPT          0x8000
#define ACBF_WAITSTATE          0x4000
#define ACBF_Q_ACTIVE           0x2000
#define ACBF_SM_SUSPENDED       0x1000                               /*@V87325*/
#define ACBF_SM_ACTIVE          0x0800
#define ACBF_LBAMODE            0x0400
#define ACBF_MULTIPLEMODE       0x0200
#define ACBF_PS2IDEPORT         0x0100
#define ACBF_DISABLERESET       0x0080
#define ACBF_DISABLERETRY       0x0040
#define ACBF_DISKPARMRESET      0x0020
#define ACBF_IRQCLEAR           0x0010                              /*@V106915*/

/* ACB->ReqFlags values */

#define ACBR_RECAL              UCBR_RECAL
#define ACBR_SETPARAM           UCBR_SETPARAM
#define ACBR_READ               0x0001
#define ACBR_WRITE              0x0002
#define ACBR_VERIFY             0x0004
#define ACBR_IDENTIFY           0x0008
#define ACBR_WRITEV             0x0010
#define ACBR_SETMULTIPLE        0x0020
#define ACBR_RESETCONTROLLER    0x0040
#define ACBR_SETLOGPARAM        0x0080

#define ACBR_BLOCKIO            (ACBR_READ   | ACBR_WRITE | ACBR_VERIFY | \
                                 ACBR_WRITEV )

#define ACBR_OTHERIO            (ACBR_RECAL | ACBR_SETPARAM | ACBR_IDENTIFY | \
                                 ACBR_SETMULTIPLE | ACBR_RESETCONTROLLER    | \
                                 ACBR_SETLOGPARAM )

#define ACBR_MULTIPLEMODE       (ACBR_READ | ACBR_WRITE)


/* ACB->State values */

#define ACBS_START      0       /* Starting I/O                               */
#define ACBS_RETRY      1       /* Calculate position on disk                 */
#define ACBS_INTERRUPT  2       /* Start verify portion of write              */
#define ACBS_DONE       3       /* I/O is done.                               */
#define ACBS_ERROR      4       /* Have an error                              */
#define ACBS_RESETCHECK 6       /*                                            */


/* ACB->TimerFlags */
#define ACBT_BUSY       0x0001
#define ACBT_DRQ        0x0002
#define ACBT_IRQ        0x0004
#define ACBT_READY      0x0008
#define ACBT_RESETFAIL  0x0010                                       /*@V77133*/

/* ACB->ResourceFlags */
#define ACBRF_CURR_OWNER      0x0001                                 /*@V87325*/



/*-------------------------------*/
/* Unit Table                    */
/* ----------                    */
/*                               */
/* One per unit (drive)          */
/*                               */
/*-------------------------------*/

typedef struct _UTBL
{
  USHORT        Flags;
  USHORT        Status;
  USHORT        DriveId;

  /*-----------------------*/
  /* Command Line Geometry */
  /*-----------------------*/
  GEOMETRY      CMDLogGeom;
  GEOMETRY      CMDPhysGeom;
  USHORT        CMDWrtPreCmp;

  /*-------------------*/
  /* Identify Geometry */
  /*-------------------*/
  GEOMETRY      IDEGeom;

  /*------------------------*/
  /* INT 13 FCN=08 Geometry */
  /*------------------------*/
  GEOMETRY      I13LogGeom;
  GEOMETRY      I13PhysGeom;
  USHORT        I13WrtPreCmp;

  USHORT        TimeOut;

  /*------------------------*/                                       /*@V75103*/
  /* Model/Firmware Rev     */                                       /*@V75103*/
  /*------------------------*/                                       /*@V75103*/
  UCHAR         ModelNum[42];                                        /*@V75103*/
  UCHAR         FirmwareRN[10];                                      /*@V75103*/

} UTBL;

#define UTBF_CMDGEOMETRYVALID   0x8000
#define UTBF_I13GEOMETRYVALID   0x4000
#define UTBF_IDEGEOMETRYVALID   0x2000
#define UTBF_LBAMODEENABLED     0x1000
#define UTBF_SMSENABLED         0x0800
#define UTBF_ONTRACK            0x0400                              /*@V108555*/
#define UTBF_ATAPIDEVICE        0x0002                               /*@V93531*/
#define UTBF_NODASDSUPPORT      0x0001

#define UTS_OK                  0
#define UTS_NOT_PRESENT         1
#define UTS_READ_0_FAILED       2
#define UTS_NOT_READY           3                                    /*@V87325*/
#define UTS_NO_MASTER           4                                   /*@V108783*/


/*-------------------------------*/
/* Adapter Table                 */
/* -------------                 */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/

typedef struct _ATBL
{
  USHORT        BasePort;
  USHORT        IRQLevel;

  USHORT        Flags;
  USHORT        Status;

  HADAPTER      hAdapter;                                           /*@V98451*/

  NPACB         npACB;

  USHORT        cUnits;
  UTBL          Unit[MAX_UNITS];

  UCHAR         ResourceBuf[sizeof(AHRESOURCE)+sizeof(HRESOURCE)*3]; /*@V98451*/

} ATBL;

#define ATBF_DISABLED           0x8000
#define ATBF_PS2IDEPORT         0x4000
#define ATBF_DISABLERESET       0x2000
#define ATBF_ATAPIPRESENT       0x1000                               /*@V93531*/
#define ATBF_IRQCLEAR           0x0800                              /*@V106915*/

#define ATS_OK                  0
#define ATS_NOT_PRESENT         1
#define ATS_SKIPPED             2
#define ATS_SET_IRQ_FAILED      3
#define ATS_ALLOC_IRQ_FAILED    4                                    /*@V98451*/
#define ATS_ALLOC_IO_FAILED     5                                    /*@V98451*/

/*-------------------------------*/
/* DriveType                     */
/* ---------                     */
/*                               */
/* One per Drive Type.           */
/*                               */
/*-------------------------------*/

typedef struct _DRIVETYPE
{
  USHORT        Cyl;
  USHORT        Head;
  USHORT        Sec;
  USHORT        WrtPreCmp;
} DRIVETYPE;

#define MAX_DRIVE_TYPES         48

/*-------------------------------*/
/* ACB Pointer Block             */
/* -----------------             */
/*                               */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _ACBPTRS
{
  NPACB         npACB;
  USHORT        (FAR *IRQHandler)();

  USHORT        IRQLevel;                                            /*@V87325*/

} ACBPTRS;


/*-------------------------------*/                                 /*@V108555*/
/* ONTRACK Support               */                                 /*@VVVVVVV*/
/* ---------------               */
/*                               */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _MBRENTRY  far *PMBRENTRY;

typedef struct _MBRENTRY
{
  UCHAR         BootFlag;
  UCHAR         StartHead;
  UCHAR         StartSec;
  UCHAR         StartCyl;

  UCHAR         PartType;
  UCHAR         EndHead;
  UCHAR         EndSec;
  UCHAR         EndCyl;

  ULONG         RelOffset;
  ULONG         RelSize;

} MBRENTRY;

#define MBR_OFFSET              446
#define MAX_MBR_ENTRY           4

#define PARTTYPE_FAT12          0x04
#define PARTTYPE_FAT16          0x06
#define PARTTYPE_OS2IFS         0x07
#define PARTTYPE_EXTENDED       0x05


#define PARTTYPE_ONTRACK        0x54
#define ONTRACK_SECTOR_OFFSET   63
#define XBIOS_ID_STRING_OFFSET  4
#define MAX_INT13_CYL           1023

/*-------------------------------*/
/* Promise Controller Support    */
/* --------------------------    */
/*                               */
/*-------------------------------*/

#define BIOS_MEM_LOW    0x000C0000l
#define BIOS_MEM_HIGH   0x000E0000l
#define BIOS_SIZE       (16*1024l)
                                                                    /*@VAAAAAA*/
#define PROMISE_ID_STRING_OFFSET  0x10                              /*@V108555*/

