/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm1s506/s506rte.c, idsk, r207, 8.005p 93/03/18";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = S506RTE.C
 *
 * DESCRIPTIVE NAME = IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Strategy 1 Entry Point
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
 #define INCL_NOBASEAPI
 #define INCL_NOPMAPI
 #define INCL_NO_SCB
 #define INCL_INITRP_ONLY
 #include "os2.h"
 #include "dos.h"
 #include "devcmd.h"
 #include "dskinit.h"

 #include "iorb.h"
 #include "reqpkt.h"
 #include "dhcalls.h"
 #include "addcalls.h"

 #include "s506cons.h"
 #include "s506type.h"
 #include "s506ext.h"
 #include "s506pro.h"


/*------------------------------------------------------------------------*/
/* OS/2 Strategy Request Router                                           */
/* ----------------------------                                           */
/* This routine receives the OS/2 Initialization Request Packet. Any      */
/* other request types are rejected.                                      */
/*------------------------------------------------------------------------*/

VOID NEAR S506Str1()
{
  PRPH pRPH;                   /* Pointer to RPH (Request Packet Header)      */
  USHORT        Cmd;           /* Local variable                              */

  _asm
  {
    mov word ptr pRPH[0], bx       /*  pRPH is initialize to                  */
    mov word ptr pRPH[2], es       /*  ES:BX passed from the kernel           */
  }

  pRPH->Status = STATUS_DONE;
  Cmd = pRPH->Cmd;

  if ( Cmd == CMDInitBase )
  {
    DriveInit( (PRPINITIN) pRPH );
  }
  else
  {
    StatusError( pRPH, STATUS_DONE | STATUS_ERR_UNKCMD );
  }

  _asm
  {
    leave
    retf
  }

 }

/*---------------------------------------------------------------------------*
 * Strategy 1 Error Processing                                               *
 * ---------------------------                                               *
 *                                                                           *
 *                                                                           *
 *---------------------------------------------------------------------------*/
VOID NEAR StatusError(PRPH pRPH, USHORT ErrorCode )
{
  pRPH->Status = ErrorCode;
  return;
}

