/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm1s506/s506regs.h, idsk, r207, 8.005p 93/03/18";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506REGS.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Register equates for WD1003 type controllers.
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

/* Locations in ROM data area of fixed disk parameter tables on an AT  */

#define FDTAB_0      (0x0041 * 4)  /* First fixed disk  - Int 41H vector */
#define FDTAB_1      (0x0046 * 4)  /* Second fixed disk - Int 46H vector */

/* Hard disk controller commands */

#define FX_NORETRY   0x0001        /* do not perform retries on i/o           */
#define FX_ECC       0x0002        /* ECC mode during i/o                     */
#define FX_RECAL     0x0010        /* recalibrate                             */
#define FX_CREAD     0x0020        /* read                                    */
#define FX_CWRITE    0x0030        /* write                                   */
#define FX_VERIFY    0x0040        /* verify track.                           */
#define FX_SETP      0x0091        /* Set parameters                          */
#define FX_CPQPWMODE 0x0098        /* Check if drive powered on               */
#define FX_CPWRMODE  0x00E5        /* Check if drive powered on               */
#define FX_IDENTIFY  0x00EC        /* Identify drive                          */
#define FX_CREADMUL  0x00C4        /* Read Multiple                           */
#define FX_CWRITEMUL 0x00C5        /* Write Multiple                          */
#define FX_SETMUL    0x00C6        /* Set Multiple Mode                       */

/* ATAPI Protocol Unique Commands */                             /*@V87325*/
#define FX_ATAPI_RESET    0x0008    /* Reset ATAPI device          @V87325    */
#define FX_ATAPI_IDENTIFY 0x00A1    /* Identify ATAPI device       @V87325    */

/* Status bits */

#define FX_BUSY      0x0080        /* Status port busy bit                    */
#define FX_READY     0x0040        /* Status port ready bit                   */
#define FX_WRTFLT    0x0020        /* Write Fault                             */
#define FX_DRQ       0x0008        /* Data Request bit                        */
#define FX_ERROR     0x0001        /* Error status                            */

/* Device Control Register bits */

#define FX_IEN       0x0002        /* Interrupt Enable (0=enable; 1=disable)  */
#define FX_SRST      0x0004        /* Soft Reset                              */

/* Error Register bits */

#define FX_AMNF      0x0001        /* Address Mark Not Found                  */
#define FX_TRK0      0x0002        /* Track 0 not found during Restore Cmd    */
#define FX_ABORT     0x0004        /* Aborted Command                         */
#define FX_IDNF      0x0010        /* ID Not Found                            */
#define FX_ECCERROR  0x0040        /* Data ECC Error                          */
#define FX_BADBLK    0x0080        /*     Block was detected in the ID field  */

/* Error Register - Diagnostic Codes */

#define FX_DIAG_PASSED    0x0001   /* All drives passed                       */
#define FX_DIAG_FORMATTER 0x0002   /* Formatter device error                  */
#define FX_DIAG_BUFFER    0x0003   /* Sector buffer error                     */
#define FX_DIAG_ECC       0x0004   /* ECC circuitry error                     */
#define FX_DIAG_uP        0x0005   /* Controlling uP error                    */
#define FX_DIAG_DRIVE1    0x0080   /* Drive 1 failed flag - Select Drive 1    */

/* I/O ports for AT hard drives */

#define FX_PRIMARY   0x01F0        /* Default primary   ports                 */
#define FX_SECONDARY 0x0170        /* Default secondary ports                 */

#define FX_PDAT      0x01F0        /* read/write data                         */
#define FX_PWRP      0x01F1        /* write precompensation cyl register      */
#define FX_PERR      0x01F1        /* error register                          */
#define FX_PSECCNT   0x01F2        /* sector count register                   */
#define FX_PSECNUM   0x01F3        /* sector number register                  */
#define FX_PCYLL     0x01F4        /* cylinder register (low)                 */
#define FX_PCYLH     0x01F5        /* cylinder register (high)                */
#define FX_PDRHD     0x01F6        /* drive/head register                     */
#define FX_PCMD      0x01F7        /* command register                        */
#define FX_PSTAT     0x01F7        /* status register                         */
#define FX_RFDR      0x03F6        /* fixed disk register                     */

/* Array indices (IOPorts[] and IORegs[]) for I/O port address and contents   */

/* Output Regs */

#define FI_PDAT      0             /* read/write data                         */
#define FI_PWRP      1             /* write precompensation cyl register      */
#define FI_PSECCNT   2             /* sector count register                   */
#define FI_PSECNUM   3             /* sector number register                  */
#define FI_PCYLL     4             /* cylinder register (low)                 */
#define FI_PCYLH     5             /* cylinder register (high)                */
#define FI_PDRHD     6             /* drive/head register                     */
#define FI_PCMD      7             /* command register                        */
#define FI_RFDR      8             /* fixed disk register                     */

#define FM_PDAT    (1<< FI_PDAT   ) /* read/write data                        */
#define FM_PWRP    (1<< FI_PWRP   ) /* write precompensation cyl register     */
#define FM_PERR    (1<< FI_PERR   ) /* error register                         */
#define FM_PSECCNT (1<< FI_PSECCNT) /* sector count register                  */
#define FM_PSECNUM (1<< FI_PSECNUM) /* sector number register                 */
#define FM_PCYLL   (1<< FI_PCYLL  ) /* cylinder register (low)                */
#define FM_PCYLH   (1<< FI_PCYLH  ) /* cylinder register (high)               */
#define FM_PDRHD   (1<< FI_PDRHD  ) /* drive/head register                    */
#define FM_PCMD    (1<< FI_PCMD   ) /* command register                       */
#define FM_RFDR    (1<< FI_RFDR   ) /* fixed disk register                    */

/* Input Regs */

#define FI_PERR      9             /* error register                          */
#define FI_PSTAT    10             /* status register                         */


/* Interrupt control */

#define IRQ_FIXED_PRIMARY  0x000E  /* Fixed interrupt IRQ #                   */


/* Identify Data */

typedef struct _IDENTIFYDATA NEAR *NPIDENTIFYDATA, FAR *PIDENTIFYDATA;

typedef struct _IDENTIFYDATA
{
  USHORT        GeneralConfig;          /*  0 General configuration bits      */
  USHORT        TotalCylinders;         /*  1 Default Translation - Num cyl   */
  USHORT        Reserved;               /*  2 Reserved                        */
  USHORT        NumHeads;               /*  3                     - Num heads */
  USHORT        NumUnformattedbpt;      /*  4 Unformatted Bytes   - Per track */
  USHORT        NumUnformattedbps;      /*  5                     - Per sector*/
  USHORT        SectorsPerTrack;        /*  6 Default Translation - Sec/Trk   */
  USHORT        NumBytesISG;            /*  7 Byte Len - inter-sector gap     */
  USHORT        NumBytesSync;           /*  8          - sync field           */
  USHORT        NumWordsVUS;            /*  9 Len - Vendor Unique Info        */
  CHAR          SerialNum[20];          /* 10 Serial number                   */
  USHORT        CtrlType;               /* 20 Controller Type                 */
  USHORT        CtrlBufferSize;         /* 21 Ctrl buffer size - Sectors      */
  USHORT        NumECCBytes;            /* 21 ECC bytes -  read/write long    */
  CHAR          FirmwareRN[8];          /* 23 Firmware Revision               */
  CHAR          ModelNum[40];           /* 27 Model number                    */
  USHORT        NumSectorsPerInt;       /* 47 Multiple Mode - Sec/Blk         */
  USHORT        Reserved2[3];           /* 48                                 */
  USHORT        PIOCycleTime;           /* 51 Transfer Cycle Timing - PIO     */
  USHORT        DMACycleTime;           /* 52                       - DMA     */
  USHORT        Reserved3[1];           /* 53                                 */
  USHORT        LogNumCyl;              /* 54 Current Translation - Num Cyl   */
  USHORT        LogNumHeads;            /* 55                       Num Heads */
  USHORT        LogSectorsPerTrack;     /* 56                       Sec/Trk   */
  ULONG         LogTotalSectors;        /* 57                       Total Sec */
  USHORT        LogNumSectorsPerInt;    /* 59                                 */
  ULONG         LBATotalSectors;        /* 60 LBA Mode - Sectors              */
  USHORT        DMASWordFlags;          /* 62                                 */
  USHORT        DMAMWordFlags;          /* 63                                 */
  USHORT        Reserved4[256-64];      /* 64                                 */

}IDENTIFYDATA;

#define FX_SECPERINTVALID       0x8000  /* Word 47 - Valid bit                */
#define FX_LOGSECPERINTVALID    0x0100  /* Word 59 - Valid bit                */

/* Hard disk parameter - control byte bit mask */

#define FDPCTRL_DISABLERETRY    0xc0    /* disable retries                    */
#define FDPCTRL_EXCEED8HEADS    0x08    /* more than 8 heads                  */

#define TRANSLATE_A0   0x00A0   /* Translation signature                      */

typedef struct _FDPARMTABLE_XLATE {
  USHORT   FDMaxCylX;                   /* Maximum number of cylinders        */
  UCHAR    FDMaxHdX;                    /* Maximum number of heads            */
  UCHAR    FDtranslate;                 /* Translate signature                */
  UCHAR    FDpsectors;                  /* physical sectors/track             */
  USHORT   FDWritePCompX;               /* write precompensation cyl          */
  UCHAR    FDBUnUseX;                   /* Unused on an AT                    */
  UCHAR    FDControlX;                  /* Control byte                       */
  USHORT   FDpcyls;                     /* physical cylinders                 */
  UCHAR    FDpheads;                    /* physical heads                     */
  USHORT   FDLandZonX;                  /* Landing zone                       */
  UCHAR    FDSecTrkX;                   /* Number of sectors/track            */
  UCHAR    FDResX;                      /* Reserved                           */
} FDPARMTABLE_XLATE;
typedef FDPARMTABLE_XLATE far *PFDPARMTABLE_XLATE;

#define ATAPISIGL 0x14                                             /*@V87325*/
#define ATAPISIGH 0xEB                                             /*@V87325*/

typedef struct _GENCONFIGWORD                                      /*@V87325*/
{                                                                  /*@V87325*/
/*                       Bit Field(s)  Ŀ    Description         @V87325 */
/*                                      Ŀ                       @V87325 */
/*                                                                @V87325 */

   unsigned int CmdPktSize   : 2;    /*  0- 1 Command Packet Size    @V87325 */
   unsigned int              : 3;    /*  2- 4 Reserved               @V87325 */
   unsigned int CmdDRQType   : 2;    /*  5- 6 CMD DRQ Type           @V87325 */
   unsigned int Removable    : 1;    /*   7   Removable              @V87325 */
   unsigned int DeviceType   : 5;    /*  8-12 Device Type            @V87325 */
   unsigned int              : 1;    /*  13   Reserved               @V87325 */
   unsigned int Protocol     : 2;    /* 14-15 Protocol Type          @V87325 */

}GENCONFIGWORD, NEAR *NPGENCONFIGWORD;                             /*@V87325*/

/* General Configuration defines       */                          /*@V87325*/
/*  protocols                          */                          /*@V87325*/
#define GC_PROT_ATA              ( 0x00 | 0x01 )                   /*@V87325*/
#define GC_PROT_ATAPI             0x02                             /*@V87325*/
/*  Device Types                       */                          /*@V87325*/
#define GC_DEVTYP_DIRECT_ACCESS   0x00                             /*@V87325*/
#define GC_DEVTYP_STREAMING_TAPE  0x01                             /*@V87325*/
#define GC_DEVTYP_CDROM           0x05                             /*@V87325*/
#define GC_DEVTYP_OPTICAL_MEMORY  0x07                             /*@V87325*/
#define GC_DEVTYP_UNKNOWN         0x1F                             /*@V87325*/
