/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm1s506/s506pro.h, idsk, r207, 8.005p 93/03/18";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506PRO.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : C Function Prototype statements
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
/*--------------------*/
/* Strategy 1 Router  */
/*--------------------*/

 VOID   NEAR S506Str1();
 VOID   NEAR StatusError(PRPH pRPH, USHORT ErrorCode);

/*----------------------------------------------------------------------------*
 * S506IORB.C - IORB Queueing Entry Point                                     *
 *----------------------------------------------------------------------------*/
VOID NEAR GetDeviceTable(NPACB npACB, PIORB pNewIORB);              /*@V108783*/
VOID NEAR CompleteInit(NPACB npACB);
VOID NEAR AllocateUnit(NPACB npACB);
VOID NEAR DeallocateUnit(NPACB npACB);
VOID NEAR ChangeUnitInfo( NPACB npACB );
VOID NEAR GetGeometry(NPACB npACB);
VOID NEAR ExecuteIO(NPACB npACB);
VOID NEAR GetUnitStatus( NPACB npACB );
VOID NEAR GetQueueStatus( NPACB npACB, PIORB pIORB );              /*@V87325*/
VOID NEAR GetUnitResources( NPACB npACB );                         /*@V87325*/
VOID NEAR CmdNotSupported(NPACB npACB);
VOID NEAR NextIORB(NPACB npACB);
VOID FAR  _loadds ADDEntryPoint( PIORBH pNewIORB );
VOID NEAR IORBDone(NPACB npACB);


/*------------------------*/
/* Interrupt Entry Points */
/*------------------------*/

USHORT FAR  FixedIRQ0(VOID);
USHORT FAR  FixedIRQ1(VOID);
USHORT FAR  FixedIRQ2(VOID);                                       /*@V87325*/
USHORT FAR  FixedIRQ3(VOID);                                       /*@V87325*/
USHORT NEAR FixedInterrupt(NPACB npACB);


/*----------------------------------------------------------------------------*
 *  S506TIMR.C Timer Routines                                                 *
 *----------------------------------------------------------------------------*/
VOID   FAR  IRQTimer( ULONG TimerHandle, PACB pACB, ULONG Unused  );
VOID   FAR  DelayedRetry(ULONG hRetryTimer, PACB pACB, ULONG Unused);
VOID   FAR  DelayedReset(ULONG hResetTimer, PACB pACB, ULONG Unused);
VOID   FAR  ElapsedTimer( ULONG hElapsedTimer, ULONG Unused1, ULONG Unused2);

/*----------------------------------------------------------------------------*
 *      S506SM.C Procedures (State Machine)                                   *
 *----------------------------------------------------------------------------*/
VOID   NEAR FixedExecute(NPACB npACB);
VOID   NEAR StartState(NPACB npACB);
VOID   NEAR RetryState(NPACB npACB);
VOID   NEAR InterruptState(NPACB npACB);
VOID   NEAR DoneState(NPACB npACB);
VOID   NEAR ErrorState(NPACB npACB);
USHORT NEAR StartOtherIO(NPACB npACB);
USHORT NEAR InitACBRequest(NPACB npACB);
VOID   NEAR InitBlockIO(NPACB npACB);
USHORT NEAR StartBlockIO(NPACB npACB);
USHORT NEAR DoBlockIO(NPACB npACB, USHORT cSec);
VOID   NEAR DoOtherIO(NPACB npACB );
VOID   NEAR SetIOAddress(NPACB npACB);
VOID   NEAR SetRetryState(NPACB npACB);
VOID   NEAR DoReset(NPACB npACB);
VOID   NEAR ResetCheck( NPACB npACB );
USHORT NEAR GetDiagResults( NPACB npACB );

USHORT NEAR CheckReady(NPACB npACB);
USHORT NEAR WaitDRQ(NPACB npACB);
VOID   NEAR UpdateBlockIOPtrs(NPACB npACB);
USHORT NEAR SendCmdPacket(NPACB npACB);
USHORT NEAR SendReset(NPACB npACB);
USHORT NEAR GetErrorReg(NPACB npACB, USHORT UnitID);
VOID   NEAR SelectUnit( NPACB npACB, USHORT UnitId );
USHORT NEAR GetStatusReg(NPACB npACB);
USHORT NEAR MapError(NPACB npACB);


VOID   NEAR EnableIDEPort();
VOID   NEAR InitializeIDEPort();

/*----------------------------------------------------------------------------*
 *      S506CSUB.C Utility Functions                                          *
 *----------------------------------------------------------------------------*/
VOID NEAR setmem( PBYTE d, USHORT c, USHORT len );
VOID NEAR memcpy( PBYTE d, PBYTE s,  USHORT len );
VOID NEAR SetupPS2IDEPort( USHORT Enable );
VOID NEAR SetPS2DiskLight( USHORT On );

/*----------------------------------------------------------------------------*
 *      S506INIT.C Procedures                                                 *
 *----------------------------------------------------------------------------*/

typedef VOID (NEAR *NPCV)();

VOID   NEAR DriveInit(PRPINITIN pRPH );
USHORT NEAR ConfigureController( NPATBL npAT );
USHORT NEAR CheckController( NPATBL npAT );
USHORT NEAR CheckCylinderLReg( NPATBL npAT, USHORT UnitId );
VOID   NEAR CalibrateTimers( NPACB npACB );
ULONG  NEAR CalibrateWorker( NPACB npACB, NPCV npWorker );
VOID   FAR  CalibrateTimer( ULONG hCalibrateTimer, ULONG Unused1, ULONG Unused2 );
VOID   NEAR EnableIDEPort();
USHORT NEAR ConfigureATAUnit( NPATBL npAT, USHORT UnitId );        /*@V87325*/
USHORT NEAR GetReg( NPACB npACB, USHORT Reg );                     /*@V87325*/
USHORT NEAR CheckForATAPISignature( NPATBL npAT, USHORT UnitId );  /*@V87325*/
USHORT NEAR DoATAPIPresenseCheck( NPATBL npAT, USHORT UnitId );    /*@V87325*/
USHORT NEAR ATAPIReset( NPACB npACB );                             /*@V87325*/
USHORT NEAR DetermineUnitGeometry( NPATBL npAT, USHORT UnitId );
USHORT NEAR VerifyEndOfMedia( NPATBL npAT, USHORT UnitId, NPGEOMETRY npGEO, PULONG MaxSec );
USHORT NEAR ReadDrive( NPACB npACB, USHORT UnitId, ULONG RBA,       /*@V108555*/
                       USHORT Retry, PBYTE pBuf );                  /*@V108555*/
USHORT NEAR DoIdentify( NPACB npACB, USHORT UnitId, PBYTE pID );
VOID   NEAR ResetController( NPACB npACB );
VOID   NEAR GetInt13Geometry( NPATBL npAT, USHORT UnitId );
VOID   NEAR GetFixedTableGeometry( NPATBL npAT, USHORT UnitId );
VOID   FAR  NotifyIORBDone(PIORB pIORB);
USHORT NEAR ScanForOtherADDs(VOID);
VOID   FAR  InitPost(PIORB pIORB);
VOID   NEAR CheckACBViable( NPATBL npAT );                           /*@V90963*/
USHORT NEAR ParseCmdLine( PDDD_PARM_LIST pADDParms, NPATBL npAT );
USHORT NEAR DriveTypeToGeometry( USHORT DriveType, NPGEOMETRY npGEO, NPUSHORT npWrtPreCmp );
USHORT NEAR CheckONTRACKDrive( PBYTE pBootSec );                    /*@V108555*/
USHORT NEAR CalcONTRACKGeometry( NPUTBL npUT, NPUCB npUCB );        /*@V108555*/
VOID   NEAR PrintInfo( NPATBL Buf );
USHORT NEAR CheckSMSEnable(VOID);                                   /*@V108555*/
VOID   NEAR TTYWrite( PSZ Buf );
USHORT NEAR AllocAdapterResources( NPATBL npAT);                     /*@V98451*/
VOID   NEAR DeallocAdapterResources( NPATBL npAT);                   /*@V98451*/
VOID   NEAR AssignResources();                                       /*@V98451*/

/*----------------------------------------------------------------------------*
 *      S506PRTF.C Procedures                                                 *
 *----------------------------------------------------------------------------*/

VOID  NEAR  sprntf( PSZ s, PSZ fmt, ... );

/*----------------------------------------------------------------------------*
 *      S506OSM2.C Procedures                                                 *
 *----------------------------------------------------------------------------*/

typedef PIORB FAR *PPIORB;                                         /*@V87325*/

USHORT NEAR SuspendIORB( NPACB npACB );                            /*@V87325*/
USHORT NEAR SuspendIORBReq( NPACB npACB, PIORB pIORB );            /*@V87325*/
USHORT NEAR ResumeIORBReq ( NPACB npACB, PIORB pIORB );            /*@V87325*/
VOID   FAR  ResumeIORB( NPACB npACB );                             /*@V87325*/
USHORT FAR  ActivateACB( NPACB npACB );                            /*@V87325*/
VOID   FAR  DeactivateACB( NPACB npACB );                          /*@V87325*/
PIORB  NEAR PreProcessIORBs( NPACB npACB, PPIORB ppFirstIORB );    /*@V87325*/
VOID   NEAR RemoveIORB( PIORB pIORB, PIORB pIORBPrev,              /*@V87325*/
                        PPIORB pIORBFirst );                       /*@V87325*/


/*----------------------------------------------------------------------------*
 *      S506OEM.C Procedures                                                  *
 *----------------------------------------------------------------------------*/

UCHAR DPT_Present ();                                             /*@V106915*/
