/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = S506OEM.C
 *
 * DESCRIPTIVE NAME = IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Adapter Driver OEM Specific routines
 *
 * Purpose:
 *
 * Note:
 *  All functions contained within assume the user first has called
 *  GetBiosInfo to setup global pointers to OEMHLP.
 *
*/
#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_NO_SCB
#define INCL_DOSERRORS
#include "os2.h"
#include "dskinit.h"
#include "dhcalls.h"
#include "strat2.h"
#include "reqpkt.h"
#include "iorb.h"
#include "addcalls.h"
#include "s506cons.h"
#include "s506type.h"
#include "s506ext.h"
#include "s506oem.h"


VOID CallOEMHlp( PRPH pRPH)
{
   VOID (FAR *pFunctionCall)(VOID);

   if (pFunctionCall = pOEMHLPEntry)
   {
      _asm {push es
            push bx
            push ds
            push di
            push si
            mov  bx, word ptr pRPH[0]
            mov  es, word ptr pRPH[2]
            mov  ds, OemhlpDS
            }

      (*pFunctionCall)();

      _asm {pop si
            pop di
            pop ds
            pop bx
            pop es
            }
   }
}

UCHAR SetupOEMHlp()
{
   /* Setup Global OEMHlp Variables */
   if (DevHelp_AttachDD("OEMHLP$ ", (NPBYTE)&DDTable))
      return(1);    /* Couldn't find OEMHLP's IDC */

   if ((DDTable.ProtIDCEntry == NULL) || (DDTable.ProtIDC_DS == 0))
      return(1);    /*     Entry Point or Data Segment */

   pOEMHLPEntry = DDTable.ProtIDCEntry;
   OemhlpDS = DDTable.ProtIDC_DS;

   return( 0 );
}

UCHAR ReadEISAConfig( USHORT SlotNumber, PULONG CompressedID)
{
   EISA_PARM     EISAParmPkt;
   EISA_DATA     EISADataPkt;
   RP_GENIOCTL   IOCtlRP;     /* From reqpkt.h */
   PRPH          pRPH = (PRPH)&IOCtlRP;

   /* Setup Parm Packet */
   EISAParmPkt.SubFunction = 0;
   EISAParmPkt.Function    = 0;
   EISAParmPkt.SlotNumber  = SlotNumber;

   /* Setup IOCTL Request Packet */
   IOCtlRP.Category = 0x00;
   IOCtlRP.Function = EISA_READ;
   IOCtlRP.ParmPacket = (PUCHAR)&EISAParmPkt;
   IOCtlRP.DataPacket = (PUCHAR)&EISADataPkt;
   IOCtlRP.rph.Len = sizeof(IOCtlRP);
   IOCtlRP.rph.Unit = 0;
   IOCtlRP.rph.Cmd  = 0x10;      /* Generic IOCtl */
   IOCtlRP.rph.Status = 0;

   CallOEMHlp(pRPH);

   if (IOCtlRP.rph.Status & STERR)
      return( 1 );

   if (EISADataPkt.bReturn != EISA_SUCCESSFUL)
      return( 1 );

   *CompressedID = EISADataPkt.CompressedID;

   return( 0 );
}

UCHAR DPT_Present ()
{
   UCHAR rc;
   UCHAR SlotNumber;
   ULONG CompressedID;

   if ( SetupOEMHlp() )
   {
      /*-------------------------------------------------*/
      /* unable to establish communication to OEMHlp.    */
      /* Therefore, assume DPT adapters are not present. */
      /*-------------------------------------------------*/
      return( 0 );
   }

   for (SlotNumber = 0 ;SlotNumber <= MAX_EISA_SLOT ;SlotNumber++ )
   {
      CompressedID = 0;
      ReadEISAConfig( SlotNumber, &CompressedID );
      if (((CompressedID & 0xffff)   == DPT_EISA_ID) ||
          ((CompressedID & 0xffffff)  == ATT_EISA_ID) ||
          ((CompressedID & 0xffffff)  == NEC_EISA_ID))
      {
         return( 1 );  /* Found one! */
      }
   }

   return( 0 );
}

