/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm1s506/s506ext.h, idsk, r207, 8.005p 93/03/18";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506EXT.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Data External References
 *
 * Purpose:  This file provides external references for global
 *           data contained in S506DATA.C
 *
 *
 *
 *
*/
#include "cmdphdr.h"

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Static Data                                                  */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/


 extern ACBPTRS      ACBPtrs[];
 extern PFN          Device_Help;
 extern HDRIVER      hDriver;                                       /*@V98451*/
 extern USHORT       ADDHandle;
 extern USHORT       cAdapters;
 extern USHORT       cUnits;
 extern USHORT       InitActive;
 extern USHORT       InitIOComplete;
 extern USHORT       BIOSActive;
 extern USHORT       LightState;
 extern USHORT       LightCount;
 extern USHORT       MachineID;
 extern USHORT       Calibrate;
 extern USHORT       XBIOSPresent;                                  /*@V108555*/
 extern ULONG        WaitDRQCount;
 extern ULONG        CheckReadyCount;
 extern ULONG        IODelayCount;
 extern ULONG        ElapsedTimerHandle;

 extern UCHAR        AdapterName[17];  /* Adapter Name ASCIIZ string          */

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Area to build Control Blocks                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#ifdef DEBUG
 extern USHORT  LogPtr;
 extern USHORT  LogBuf[4*1024];
#endif

 extern UCHAR TimerPool[TIMER_POOL_SIZE];
 extern ACB   ACBPool[];


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Initialization Data                                          */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/


 extern NPACB          npACBPool;
 extern ATBL           AdapterTable[MAX_ADAPTERS];
 extern ULONG          CalibrateTimerHandle;
 extern USHORT         CallWorkerSync;
 extern USHORT         CallWorker;
 extern USHORT         Verbose;
 extern USHORT         ATAPISlaveChk;                               /*@V109483*/
 extern IORB_EXECUTEIO InitIORB;
 extern SCATGATENTRY   ScratchSGList;                               /*@V108555*/
 extern PDDD_PARM_LIST pDDD_Parm_List;
 extern IDCTABLE       DDTable;
 extern VOID           (FAR *pOEMHLPEntry)(VOID);
 extern USHORT         OemhlpDS;
 extern MSGTABLE       InitMsg;
 extern NPSZ           AdptMsgs[];
 extern NPSZ           UnitMsgs[];
 extern NPSZ           MsgSMSOn;
 extern NPSZ           MsgLBAOn;
 extern NPSZ           MsgONTrackOn;                                /*@V108555*/
 extern NPSZ           ATAPIMsg;                                   /*@V87325*/
 extern NPSZ           MsgNull;
 extern UCHAR          ParmErrMsg[];
 extern UCHAR          VersionMsg[];
 extern UCHAR          XBIOSIdString[];                             /*@V108555*/
 extern USHORT         XBIOSIdLength;                               /*@V108555*/
 extern UCHAR          PromiseIdString[];                           /*@V108555*/
 extern USHORT         PromiseIdLength;                             /*@V108555*/
 extern UCHAR          ScratchBuf[SCRATCH_BUF_SIZE];

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Drive Type Table                                             */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern DRIVETYPE      DriveTypeTable[MAX_DRIVE_TYPES];


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern PSZ          pcmdline1;
 extern PSZ          pcmdline_slash;
 extern PSZ          pcmdline_start;
 extern INT          tokv_index;
 extern INT          state_index;
 extern INT          length;
 extern CHARBYTE     tokvbuf[];
 extern POPT         pend_option;
 extern POPT         ptable_option;
 extern BYTE         *poutbuf1;
 extern BYTE         *poutbuf_end;
 extern CC           cc;
 extern USHORT       outbuf_len;
 extern PBYTE        poutbuf;
 extern OPTIONTABLE  opttable;
 extern USHORT       DrvrNameSize;                                  /*@V98451*/
 extern DRIVERSTRUCT DriverStruct;                                  /*@V98451*/
 extern ADAPTERSTRUCT AdapterStruct;                                /*@V98451*/
 extern DEVICESTRUCT DevStruct;                                     /*@V98451*/
 extern UCHAR        ATAPIDescriptName[];                           /*@V98451*/
 extern UCHAR        DevDescriptNameTxt[];                          /*@V98451*/

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Verbose Data                                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern UCHAR        VPCIInfo[];                                    /*@V106915*/
 extern UCHAR        VControllerInfo[];                             /*@V106915*/
 extern UCHAR        VUnitInfo1[];                                  /*@V106915*/
 extern UCHAR        VUnitInfo2[];                                  /*@V106915*/
 extern UCHAR        VModelInfo[];                                  /*@V106915*/
 extern UCHAR        VModelUnknown[];                               /*@V106915*/
 extern UCHAR        VGeomInfo1[];                                  /*@V106915*/
 extern UCHAR        VGeomInfo2[];                                  /*@V106915*/
 extern UCHAR        VGeomInfo3[];                                  /*@V106915*/
 extern UCHAR        VBlankLine[];                                  /*@V106915*/
