/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = S506DATA.C
 *
 * DESCRIPTIVE NAME = IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Static/Initialization Data
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
 #define INCL_NOBASEAPI
 #define INCL_NOPMAPI
 #define INCL_NO_SCB
 #define INCL_INITRP_ONLY
 #include "os2.h"
 #include "dos.h"
 #include "dskinit.h"

 #include "iorb.h"
 #include "reqpkt.h"
 #include "dhcalls.h"
 #include "addcalls.h"

 #include "s506cons.h"
 #include "s506type.h"
 #include "s506ext.h"
 #include "s506pro.h"

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Static Data                                                  */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 ACBPTRS        ACBPtrs[MAX_ADAPTERS] = { { 0, &FixedIRQ0 },
                                          { 0, &FixedIRQ1 },       /*@V87325*/
                                          { 0, &FixedIRQ2 },       /*@V87325*/
                                          { 0, &FixedIRQ3 } };     /*@V87325*/

 PFN            Device_Help           = 0L;
 PFN            RM_Help               = 0L;                        /*@V98451*/
 PFN            RM_Help0              = 0l;                        /*@V98451*/
 PFN            RM_Help3              = 0l;                        /*@V98451*/
 HDRIVER        hDriver               = 0L;                        /*@V98451*/
 ULONG          RMFlags               = 0L;                        /*@V98451*/
 USHORT         ADDHandle             = 0;
 USHORT         cAdapters             = 0;
 USHORT         cUnits                = 0;
 USHORT         InitActive            = 0;
 USHORT         InitIOComplete        = 0;
 USHORT         BIOSActive            = 1;
 USHORT         LightState            = 0;
 USHORT         LightCount            = 0;
 USHORT         MachineID             = 0;
 USHORT         Calibrate             = 0;
 USHORT         XBIOSPresent          = 0;                          /*@V108555*/
 ULONG          WaitDRQCount          = 0;
 ULONG          CheckReadyCount       = 0;
 ULONG          IODelayCount          = 0;
 ULONG          ElapsedTimerHandle    = 0;

 UCHAR AdapterName[17] = "ST506 HardDisk";      /* Adapter Name ASCIIZ string */


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Area to build Control Blocks                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#ifdef DEBUG
 USHORT         LogPtr         = { 0 };
 USHORT         LogBuf[4*1024] = { 0 };
#endif

 UCHAR          TimerPool[TIMER_POOL_SIZE] = { 0 };
 ACB            ACBPool[MAX_ADAPTERS]      = { 0 };


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Initialization Data                                          */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 NPACB          npACBPool                  =  ACBPool;

 ATBL           AdapterTable[MAX_ADAPTERS] =
 {
  /*-----------*/
  /* Port  IRQ */
  /*           */
  /*-----------*/
   {0x1F0, 14 },
   {0x170, 15 },
   {    0, 16, ATBF_DISABLED }, /* Invalid port and IRQ */         /*@V87325*/
   {    0, 16, ATBF_DISABLED }  /* Invalid port and IRQ */         /*@V87325*/
 };

 ULONG          CalibrateTimerHandle = 0;
 USHORT         CallWorkerSync       = 0;
 USHORT         CallWorker           = 0;

 USHORT         Verbose              = 0;
 USHORT         ATAPISlaveChk        = 0;                           /*@V109483*/
 IORB_EXECUTEIO InitIORB             = { 0 };
 SCATGATENTRY   ScratchSGList        = { 0, 512 };                  /*@V108555*/
 PDDD_PARM_LIST pDDD_Parm_List       = { 0 };

 IDCTABLE       DDTable              = { 0 };
 VOID           (FAR *pOEMHLPEntry)(VOID) = 0;
 USHORT         OemhlpDS             = 0;

 UCHAR          ScratchBuf[SCRATCH_BUF_SIZE] = { 0 };

#define MSG_REPLACEMENT_STRING  1178

MSGTABLE  InitMsg = { MSG_REPLACEMENT_STRING,
                      1,
                      0,
                          };

UCHAR     AdptMsg0[] = "OK";
UCHAR     AdptMsg1[] = "Adapter not detected";
UCHAR     AdptMsg2[] = "Ignored - Previously Initialized";
UCHAR     AdptMsg3[] = "IRQ Level Not Available";
UCHAR     AdptMsg4[] = "IRQ Resource Not Available";                /*@V98451*/
UCHAR     AdptMsg5[] = "IO Port Resource Not Available";            /*@V98451*/

NPSZ AdptMsgs[] = { (NPSZ) AdptMsg0,
                    (NPSZ) AdptMsg1,
                    (NPSZ) AdptMsg2,
                    (NPSZ) AdptMsg3,
                    (NPSZ) AdptMsg4,                                /*@V98451*/
                    (NPSZ) AdptMsg5                                 /*@V98451*/
                  };

UCHAR     UnitMsg0[] = "OK";
UCHAR     UnitMsg1[] = "Unit not detected";
UCHAR     UnitMsg2[] = "Read Sector 0 failed";
UCHAR     UnitMsg3[] = "Unit Not Ready";                            /*@108783X*/
UCHAR     UnitMsg4[] = "No Master Device";                          /*@108783X*/

NPSZ UnitMsgs[] = { (NPSZ) UnitMsg0,
                    (NPSZ) UnitMsg1,
                    (NPSZ) UnitMsg2,
                    (NPSZ) UnitMsg3,                                /*@108783X*/
                    (NPSZ) UnitMsg4                                 /*@108783X*/
                  };

UCHAR MsgSMSOntxt[]     = " - SMS Enabled";                         /*@V108555*/
UCHAR MsgLBAOntxt[]     = " - LBA Enabled";                         /*@V108555*/
UCHAR MsgONTrackOntxt[] = " - Ontrack DM";                          /*@V108555*/

NPSZ  MsgSMSOn      = (NPSZ) MsgSMSOntxt;
NPSZ  MsgLBAOn      = (NPSZ) MsgLBAOntxt;
NPSZ  MsgONTrackOn  = (NPSZ) MsgONTrackOntxt;                       /*@V108555*/

UCHAR ATAPIMsgtxt[] = "ATAPI Device";                                /*@V87325*/
UCHAR MsgNulltxt[]  = "";

NPSZ ATAPIMsg       = ATAPIMsgtxt;                                   /*@V87325*/
NPSZ MsgNull        = MsgNulltxt;

UCHAR ParmErrMsg[] = " Warning: IBM1S506.ADD - Invalid CONFIG.SYS parameters";
UCHAR VersionMsg[] = "IBM  ST-506/IDE/ATAPI  OS/2 2.x & 3.x Driver  (950115)";

UCHAR  XBIOSIdString[] = "AT REGISTER SET COMPATIBLE BIOS EXTENSION V3."; /*@V108555*/
USHORT XBIOSIdLength   = sizeof(XBIOSIdString) - 1;                 /*@V108555*/
                                                                    /*@V108555*/
UCHAR  PromiseIdString[] = "Promise";                               /*@V108555*/
USHORT PromiseIdLength   = sizeof(PromiseIdString) - 1;             /*@V108555*/

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Drive Type Table                                             */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/


DRIVETYPE DriveTypeTable[MAX_DRIVE_TYPES] =
{
/*    Cyl     Head    Sec     WPC       */

  {     0,      0,      0,      0       },             /*  0  */
  {   306,      4,     17,    128       },             /*  1  */
  {   615,      4,     17,    300       },             /*  2  */
  {   615,      6,     17,    300       },             /*  3  */
  {   940,      8,     17,    512       },             /*  4  */
  {   940,      6,     17,    512       },             /*  5  */
  {   615,      4,     17,     -1       },             /*  6  */
  {   462,      8,     17,    256       },             /*  7  */
  {   733,      5,     17,     -1       },             /*  8  */
  {   900,     15,     17,     -1       },             /*  9  */
  {   820,      3,     17,     -1       },             /* 10  */
  {   855,      5,     17,     -1       },             /* 11  */
  {   855,      7,     17,     -1       },             /* 12  */
  {   306,      8,     17,    128       },             /* 13  */
  {   733,      7,     17,     -1       },             /* 14  */
  {    -1,     -1,     -1,     -1       },             /* 15  */
  {   612,      4,     17,      0       },             /* 16  */
  {   977,      5,     17,    300       },             /* 17  */
  {   977,      7,     17,     -1       },             /* 18  */
  {  1024,      7,     17,    512       },             /* 19  */
  {   733,      5,     17,    300       },             /* 20  */
  {   733,      7,     17,    300       },             /* 21  */
  {   733,      5,     17,    300       },             /* 22  */
  {   306,      4,     17,      0       },             /* 23  */
  {    -1,     -1,     -1,     -1       },             /* 24  */
  {   615,      4,     17,      0       },             /* 25  */
  {  1024,      4,     17,     -1       },             /* 26  */
  {  1024,      5,     17,     -1       },             /* 27  */
  {  1024,      8,     17,     -1       },             /* 28  */
  {   512,      8,     17,    256       },             /* 29  */
  {   615,      2,     17,    615       },             /* 30  */
  {   989,      5,     17,      0       },             /* 31  */
  {  1020,     15,     17,     -1       },             /* 32  */
  {    -1,     -1,     -1,     -1       },             /* 33  */
  {    -1,     -1,     -1,     -1       },             /* 34  */
  {  1024,      9,     17,   1024       },             /* 35  */
  {  1024,      5,     17,    512       },             /* 36  */
  {   830,     10,     17,     -1       },             /* 37  */
  {   823,     10,     17,    256       },             /* 38  */
  {   615,      4,     17,    128       },             /* 39  */
  {   615,      8,     17,    128       },             /* 40  */
  {   917,     15,     17,     -1       },             /* 41  */
  {  1023,     15,     17,     -1       },             /* 42  */
  {   823,     10,     17,    512       },             /* 43  */
  {   820,      6,     17,    820       },             /* 44  */
  {  1024,      8,     17,     -1       },             /* 45  */
  {   925,      9,     17,     -1       },             /* 46  */
  {   699,      7,     17,    256       }              /* 47  */
};

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#define TOKVBUF_LEN 255

PSZ        pcmdline1              = 0;
PSZ        pcmdline_slash         = 0;
PSZ        pcmdline_start         = 0;
INT        tokv_index             = 0;
INT        state_index            = 0;
INT        length                 = 0;
CHARBYTE   tokvbuf[TOKVBUF_LEN]   = { 0 };
POPT       pend_option            = 0;
POPT       ptable_option          = 0;
BYTE       *poutbuf1              = 0;
BYTE       *poutbuf_end           = 0;
CC         cc                     = { 0, 0 };

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len         = OUTBUF_LEN + 1;
PBYTE    poutbuf            = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         3

/*                                  opt.state[] initialization definitions    */
/*                                                                            */
/*                                              ____ entry state              */
/*                                              |                   previous  */
/*                                              v                     opt |   */
/*  ----Command Line Option --------           ----- STATE TABLE -----    |   */
/*  token id          string   type             0   1   2   3             |   */
/*                                                                        |   */
/*                                              *  /A:  /I  /U: <-----------  */
/*                                                          /GEO:             */
/*                                                          /T:               */

UCHAR TOK_ID_Vtxt[]         = "/V";
UCHAR TOK_ID_NOT_Vtxt[]     = "/!V";
UCHAR TOK_ID_ADAPTERtxt[]   = "/A:";
UCHAR TOK_ID_PORTtxt[]      = "/PORT:";
UCHAR TOK_ID_Ptxt[]         = "/P:";
UCHAR TOK_ID_IRQtxt[]       = "/IRQ:";
UCHAR TOK_ID_IGNOREtxt[]    = "/I";
UCHAR TOK_ID_RESETtxt[]     = "/R";
UCHAR TOK_ID_NORESETtxt[]   = "/!R";
UCHAR TOK_ID_Utxt[]         = "/U:";
UCHAR TOK_ID_UNITtxt[]      = "/UNIT:";
UCHAR TOK_ID_DMtxt[]        = "/DM";
UCHAR TOK_ID_NOT_DMtxt[]    = "/!DM";
UCHAR TOK_ID_GEOtxt[]       = "/GEO:";
UCHAR TOK_ID_TIMEOUTtxt[]   = "/T:";
UCHAR TOK_ID_LBAMODEtxt[]   = "/LBA";
UCHAR TOK_ID_SMStxt[]       = "/SMS";
UCHAR TOK_ID_NOT_SMStxt[]   = "/!SMS";
UCHAR TOK_ID_ATAPItxt[]     = "/ATAPI";
UCHAR TOK_ID_NOT_ATAPItxt[] = "/!ATAPI";
UCHAR TOK_ID_ENDtxt[]       = "\0";

OPT OPT_VERBOSE =
    {TOK_ID_V,         TOK_ID_Vtxt,         TYPE_0,        {0,  1,  2,  3}};

OPT OPT_NOT_VERBOSE =
    {TOK_ID_NOT_V,     TOK_ID_NOT_Vtxt,     TYPE_0,        {0,  1,  2,  3}};

OPT OPT_ADAPTER =
    {TOK_ID_ADAPTER,   TOK_ID_ADAPTERtxt,   TYPE_D,        {1,  1,  1,  1}};     /*@V75103*/

OPT OPT_PORT =
    {TOK_ID_PORT,      TOK_ID_PORTtxt,      TYPE_HHHH,     {E,  1,  2,  E}};

OPT OPT_P    =
    {TOK_ID_PORT,      TOK_ID_Ptxt,         TYPE_HHHH,     {E,  1,  2,  E}};

OPT OPT_IRQ  =
    {TOK_ID_IRQ,       TOK_ID_IRQtxt,       TYPE_DD,       {E,  1,  2,  E}};     /*@V64402*/

OPT OPT_IGNORE =
    {TOK_ID_IGNORE,    TOK_ID_IGNOREtxt,    TYPE_0,        {E,  2,  E,  E}};

OPT OPT_RESET  =
    {TOK_ID_RESET,     TOK_ID_RESETtxt,     TYPE_0,        {E,  1,  E,  E}};

OPT OPT_NORESET =
    {TOK_ID_NORESET,   TOK_ID_NORESETtxt,   TYPE_0,        {E,  1,  E,  E}};

OPT OPT_U    =
    {TOK_ID_UNIT,      TOK_ID_Utxt,         TYPE_D,        {E,  3,  E,  3}};

OPT OPT_UNIT =
    {TOK_ID_UNIT,      TOK_ID_UNITtxt,      TYPE_D,        {E,  3,  E,  3}};

OPT OPT_DM =
    {TOK_ID_DM,        TOK_ID_DMtxt,        TYPE_0,        {E,  1,  2,  3}};

OPT OPT_NOT_DM =
    {TOK_ID_NOT_DM,    TOK_ID_NOT_DMtxt,    TYPE_0,        {E,  1,  2,  3}};

OPT OPT_GEO =
    {TOK_ID_GEO,       TOK_ID_GEOtxt,       TYPE_GEOMETRY, {E,  E,  E,  3}};

OPT OPT_T =
    {TOK_ID_TIMEOUT,   TOK_ID_TIMEOUTtxt,   TYPE_DDDD,     {E,  E,  E,  3}};

OPT OPT_LBAMODE =
    {TOK_ID_LBAMODE,   TOK_ID_LBAMODEtxt,   TYPE_0,        {E,  E,  E,  3}};

OPT OPT_SMS =
    {TOK_ID_SMS,       TOK_ID_SMStxt,       TYPE_0,        {E,  E,  E,  3}};

OPT OPT_NOT_SMS =
    {TOK_ID_NOT_SMS,   TOK_ID_NOT_SMStxt,   TYPE_0,        {E,  E,  E,  3}};

OPT OPT_ATAPI =
    {TOK_ID_ATAPI,     TOK_ID_ATAPItxt,     TYPE_0,        {E,  E,  E,  3}};

OPT OPT_NOT_ATAPI =
    {TOK_ID_NOT_ATAPI, TOK_ID_NOT_ATAPItxt, TYPE_0,        {E,  E,  E,  3}};

OPT OPT_END =
    {TOK_ID_END,       TOK_ID_ENDtxt,       TYPE_0,        {O,  O,  O,  O}};

/*                                                                      */
/*   The following is a generic OPTIONTABLE for ADDs which support disk */
/*   devices.                                                           */
/*                                                                      */
OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    { (POPT) &OPT_VERBOSE,
      (POPT) &OPT_NOT_VERBOSE,
      (POPT) &OPT_ADAPTER,
      (POPT) &OPT_PORT,
      (POPT) &OPT_P,
      (POPT) &OPT_IRQ,
      (POPT) &OPT_IGNORE,
      (POPT) &OPT_RESET,
      (POPT) &OPT_NORESET,
      (POPT) &OPT_U,
      (POPT) &OPT_UNIT,
      (POPT) &OPT_DM,
      (POPT) &OPT_NOT_DM,
      (POPT) &OPT_GEO,
      (POPT) &OPT_T,
      (POPT) &OPT_LBAMODE,
      (POPT) &OPT_SMS,
      (POPT) &OPT_NOT_SMS,
      (POPT) &OPT_ATAPI,
      (POPT) &OPT_NOT_ATAPI,
      (POPT) &OPT_END
    }
};

/*----------------------------------------------*/                  /*@V98451*/
/* Driver Description                           */                  /*VVVVVVV*/
/*----------------------------------------------*/

/* by declaring the storage as arrays and intializing the array, we force  */
/* the compiler to store the ASCII strings in this location rather than in */
/* the text area at the beginning of the segment.  Therefore we can throw  */
/* these strings away.                                                     */

UCHAR DrvrNameTxt[]     = "IBM1S506.ADD";
USHORT DrvrNameSize     = sizeof(DrvrNameTxt);
UCHAR DrvrDescriptTxt[] = "IBM Adapter Driver for ST506/IDE DASD";
UCHAR VendorNameTxt[]   = "IBM OS/2";

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1995,01,15,                               /* Date                    */
   0,                                        /* DrvrFlags               */
   DRT_ADDDM,                                /* DrvrType                */
   DRS_ADD,                                  /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};


/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
UCHAR AdaptDescriptNameTxt[] = "IDE_0 ST506/IDE Controller";

ADAPTERSTRUCT AdapterStruct =
{
  AdaptDescriptNameTxt,              /* AdaptDescriptName; */
  AS_16MB_ADDRESS_LIMIT,             /* AdaptFlags;        */
  AS_BASE_MSD,                       /* BaseType;          */
  AS_SUB_IDE,                        /* SubType;           */
  AS_INTF_GENERIC,                   /* InterfaceType;     */
  AS_HOSTBUS_ISA,                    /* HostBusType;       */
  AS_BUSWIDTH_16BIT,                 /* HostBusWidth;      */
  NULL,                              /* pAdjunctList;      */
  NULL                               /* reserved           */
};

/*----------------------------------------------*/
/* Device Description                           */
/*----------------------------------------------*/
UCHAR DevDescriptNameTxt[] = "HD_0 Hard Drive";

DEVICESTRUCT DevStruct =
{
   DevDescriptNameTxt,   /* DevDescriptName; */
   DS_FIXED_LOGICALNAME, /* DevFlags;     */
   DS_TYPE_DISK          /* DevFlags;        */
};

UCHAR ATAPIDescriptName[] = "ATAPI Device";                         /*AAAAAAA*/
                                                                    /*@V98451*/

                                                                    /*VVVVVVVV*/
                                                                    /*@V106915*/
/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Verbose Data                                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

UCHAR VPCIInfo[] = "PCI Vendor ID: %04x; PCI Product ID: %04x; PCI Revision Level %04x";
UCHAR VControllerInfo[] = "Controller: %1d  Base Port: %04x  IRQ: %04x - Status = %s";
UCHAR VUnitInfo1[] = "Unit %1d - Status = %s";
UCHAR VUnitInfo2[] = "Unit %1d - Status = %s%s%s%s";                /*@V108555*/
UCHAR VModelInfo[] = " Model = %-30s %s";
UCHAR VModelUnknown[] = "<Unknown>";
UCHAR VGeomInfo1[] = " Act Cyl : %4d %4d  I13 Cyl : %4d %4d  CMD Cyl : %4d %4d  ID Cyl : %4d";
UCHAR VGeomInfo2[] = "     Head: %4d %4d      Head: %4d %4d      Head: %4d %4d     Head: %4d";
UCHAR VGeomInfo3[] = "     Sec : %4d %4d      Sec : %4d %4d      Sec : %4d %4d     Sec : %4d";
UCHAR VBlankLine[] = " ";
                                                                    /*AAAAAAAA*/
                                                                    /*@V106915*/

