/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506CONS.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Locally defined equates.
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

/*---------------------------------------*/
/* Maximum Adapters/Units                */
/*---------------------------------------*/
#define MAX_ADAPTERS    4                                          /*@V87325*/
#define MAX_UNITS       2

/*-------------------*/
/* TimeOut Equates   */
/*-------------------*/

/*---------------------------------------*/
/* TimeOut for RESET to complete (30s)   */
/*                                       */
/* After a RESET the drive is checked    */
/* every 200ms.                          */
/*---------------------------------------*/
#define DELAYED_RESET_MAX       (30*1000L)
#define DELAYED_RESET_INTERVAL  200L

/*----------------------------------------------*/
/* TimeOut for IRQ from last interrupt (5s)     */
/*----------------------------------------------*/
#define IRQ_TIMEOUT_INTERVAL    (5*1000L)

/*----------------------------------------------*/
/* Retry Delay interval (200ms)                 */
/*----------------------------------------------*/
#define DELAYED_RETRY_INTERVAL  200L

/*---------------------------------------*/
/* Minimum User Timeout (5s)             */
/*---------------------------------------*/
#define MIN_USER_TIMEOUT        (IRQ_TIMEOUT_INTERVAL / 1000L)

/*---------------------------------------*/
/* Default User Timeout (30s)            */
/*---------------------------------------*/
#define DEFAULT_USER_TIMEOUT    30

/*---------------------------------------*/                          /*@V85057*/
/* Maximum Cmd/Data Error Retries        */                          /*@V85057*/
/*---------------------------------------*/                          /*@V85057*/
#define MAX_BUSY_TIMEOUTS       50                                   /*@V85057*/

/*---------------------------------------*/
/* Maximum Cmd/Data Error Retries        */
/*---------------------------------------*/
#define MAX_DATA_ERRORS         25

/*---------------------------------------*/                          /*@V77133*/
/* Maximum Reset Retries                 */                          /*@V77133*/
/*---------------------------------------*/                          /*@V77133*/
#define MAX_RESET_RETRY         10                                   /*@V77133*/

/*---------------------------------------*/
/* Initialization unit timeouts          */
/*---------------------------------------*/
#define INIT_TIMEOUT_LONG       (10*1000L)
#define INIT_TIMEOUT_SHORT      ( 2*1000L)

/*---------------------------------------*/
/* Elapsed Timer Interval (200ms)        */
/*---------------------------------------*/
#define ELAPSED_TIMER_INTERVAL  200

/*---------------------------------------*/
/* Calibrate Loop Counter                */
/*---------------------------------------*/
#define CALIBRATE_LOOP_COUNT            1024
#define CALIBRATE_TIMER_INTERVAL        (5*31L)

/*---------------------------------------*/
/* Maximum PIO Delays (ms)               */
/*---------------------------------------*/
#define MAX_WAIT_DRQ                    100
#define MAX_WAIT_READY                  100

/*---------------------------------------*/
/* Maximum Transfer - MultiBlock Mode    */
/*---------------------------------------*/
#define MAX_MULTMODE_BLK                16

/*---------------------------------------*/
/* Maximum Transfer - Overall            */
/*---------------------------------------*/
#define MAX_XFER_SEC                    256

/*---------------------------------------*/
/* Suspend Count                         */
/*---------------------------------------*/
#define DEFERRED_COUNT                    5                        /*@V87325*/
#define IMMEDIATE_COUNT                   1                        /*@V87325*/

/*-------------------------------*/
/* Miscellaneous                 */
/*-------------------------------*/
#define ENABLE  _asm{ sti }
#define DISABLE _asm{ cli }

#define SECTORSHIFT             9

#define SCRATCH_BUF_SIZE        1024

#define ATAPI_RECOVERY          20                                  /*@V108783*/

/*---------------------------------------------*/
/* Dummy IORB CommandModifier                  */
/*                                             */
/* To pass internal requests to state machine  */
/*---------------------------------------------*/
#define IOCM_NO_OPERATION       0

#define TASKTIME                -1L                                /*@V87325*/
