;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = FLTASUBR.ASM
;*
;* DESCRIPTIVE NAME = Common assembly language subroutines for Filters
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

        title   toasubr - OS/2 2.0 TOSHCD1.FLT device driver
        name    toasubr

        page    ,132

        .xlist
        include struc.inc
;*       include abmac.inc
        include basemaca.inc
        include devhlp.inc
        include devsym.inc
        .list

_DATA           segment dword public 'DATA'
_DATA           ends

CONST           segment dword public 'CONST'
CONST           ends

_BSS            segment dword public 'BSS'
_BSS            ends

_TEXT           segment dword public 'CODE'
_TEXT           ends

Code            segment dword public 'CODE'
Code            ends

SwapCode        segment dword public 'CODE'
SwapCode        ends

DGROUP          group   CONST, _BSS, _DATA
StaticGroup     group   Code, _TEXT
SwapGroup       group   SwapCode

;*
;*  ABIOS Related
;*

;*  StaticCode SEGMENT use16 'CODE'
;*            assume cs:StaticCode

_DATA   segment dword public 'DATA'
        extrn   _Device_Help:dword

_DATA   ends


_TEXT     segment dword public 'CODE'
          assume  CS:_TEXT, DS:_DATA

        .386


;/***************************************************************************
;*
;* FUNCTION NAME = add32
;*
;* DESCRIPTION   = ULONG = add32 (ULONG operand1, ULONG operand2)
;*
;* INPUT         =
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

AddOp1  EQU    [bp+6]
AddOp2  EQU    [bp+10]

public _f_add32
_f_add32 proc far

        push    bp
        mov     bp,sp
        mov     eax,AddOp1
        add     eax,AddOp2
        jc      Over
        mov     edx,eax
        shr     edx,16
        jmp     short NotOver
Over:
        mov     ax,0
        mov     dx,0
NotOver:
        pop     bp
        ret


_f_add32 endp


;/***************************************************************************
;*
;* FUNCTION NAME = _f_ZeroCB
;*
;* DESCRIPTION   = VOID _f_ZeroCB (PBYTE ControlBlock, USHORT Length)
;*
;*                 Zero fill the input control block
;*
;* INPUT         =
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

CtrlBlk EQU [bp+6]
BlkLen  EQU [bp+10]

public _f_ZeroCB
_f_ZeroCB proc far

        push    bp
        mov     bp,sp

        SaveReg <es,bx,cx,di>

        xor     eax,eax
        les     di,CtrlBlk
        mov     cx,BlkLen
        mov     bx,cx
        and     bx,3
        shr     cx,2
        cmp     cx,0
        je      zcb_rem
        rep     stosd

zcb_rem:
        mov     cx,bx
        cmp     cx,0
        je      zcb_ret
        rep     stosb

zcb_ret:
        RestoreReg <di,cx,bx,es>

        pop     bp
        ret

_f_ZeroCB endp


;/***************************************************************************
;*
;* FUNCTION NAME = _f_BlockCopy
;*
;* DESCRIPTION   = VOID _f_BlockCopy (PBYTE Dest, PBYTE Orig, USHORT Length)
;*
;*                 Copy a block of data
;*
;* INPUT         =
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;* RETURN-ERROR  =
;*
;**************************************************************************/

BlkDest  EQU [bp+6]
BlkSrc   EQU [bp+10]
BlkCLen  EQU [bp+14]

public _f_BlockCopy
_f_BlockCopy proc far

        push    bp
        mov     bp,sp

        SaveReg <ds,es,di,si,cx,bx>

        les     di,BlkDest
        lds     si,BlkSrc
        mov     cx,BlkCLen

        mov     bx,cx
        and     bx,3
        shr     cx,2
        cmp     cx,0
        je      bc_rem
        rep     movsd

bc_rem:
        mov     cx,bx
        cmp     cx,0
        je      bc_ret
        rep     movsb

bc_ret:
        RestoreReg <bx,cx,si,di,es,ds>

        pop     bp

        ret

_f_BlockCopy endp


;/***************************************************************************
;*
;* FUNCTION NAME = HSGtoRedBook
;*
;* DESCRIPTION   = Convert HSG address to RedBook binary address
;*
;*                 RedBook address is binary, not BCD, ( frame,sec,min,0 )
;*
;*                 HSG = (min * 60 + sec) * 75 + frame - 150
;*
;* INPUT         = HSG address
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = dx:ax = RedBook address     ( dl= min, ah=sec, al=frame )
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

                PUBLIC  _HSGtoRedBook
_HSGtoRedBook   proc    near

                push    bp
                mov     bp, sp

                mov     ax, [bp+4]              ; low word of HSG address
                mov     dx, [bp+6]              ; high word of HSG address
                add     ax, 150                 ; base block number
                adc     dx, 0
                mov     cx, 4500                ; 60 * 75
                div     cx                      ; al = min, dx = remainder
                xchg    dx, ax                  ; dl = min, ax = remainder
                mov     cl, 75
                div     cl                      ; al = sec, ah = remainder
                xchg    ah, al                  ; ah = sec, al = frame

                pop     bp
                ret

_HSGtoRedBook   endp


;/***************************************************************************
;*
;* FUNCTION NAME = RedBookToHSG
;*
;* DESCRIPTION   = Convert RedBook binary address to HSG address
;*
;*                 RedBook address must be binary and in order frame,sec,min,0
;*                 on the stack, that is a long with low to high order as shown
;*
;*                 HSG = (min * 60 + sec) * 75 + frame - 150
;*
;* INPUT         = redbook address     (long - frame sec min 0)
;*                                                   low -------> high
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL = dx:ax = HSG address
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

                PUBLIC  _RedBookToHSG
_RedBookToHSG   proc    near

                push    bp                      ; [bp+4] = frame sec min 0
                mov     bp, sp

                mov     al, byte ptr [bp+6]     ; al = min
                mov     cl, 60
                mul     cl                      ; ax = min * 60
                mov     bx, [bp+4]              ; bl = frame, bh = sec
                cmp     bl, 74
                ja      RedBookToHSGerror
                cmp     bh, 59
                ja      RedBookToHSGerror
                add     al, bh
                adc     ah, 0                   ; ax = min * 60 + sec
                mov     cx, 75
                mul     cx                      ; dx:ax = (min*60 + sec) * 75
                xor     bh, bh
                add     ax, bx
                adc     dx, 0                   ; dx:ax = (min*60 + sec) * 75
                                                ;  + frame
                sub     ax, 150
                sbb     dx, 0                   ; dx:ax = HSG address
                jmp     short RedBookToHSGexit

RedBookToHSGerror:
                mov     ax, -1                  ; to get hardware error
                mov     dx, ax
RedBookToHSGexit:
                pop     bp
                ret

_RedBookToHSG   endp

;/***************************************************************************
;*
;* FUNCTION NAME = BinaryToBCD
;*
;* DESCRIPTION   = Convert binary byte to BCD byte ( 2 digits )
;*                 return ( (n / 10 << 4) | (n % 10) )
;*
;* INPUT         = binary byte
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL = al = BCD
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

                PUBLIC  _BinaryToBCD
_BinaryToBCD    proc    near

                push    bp
                mov     bp, sp

                mov     al, byte ptr [bp+4]             ; binary byte
                xor     ah, ah
                mov     cl, 10
                div     cl
                xchg    ah, al
                shl     ah, 4
                or      al, ah

                pop     bp
                ret

_BinaryToBCD    endp

;/***************************************************************************
;*
;* FUNCTION NAME = BCDtoBinary
;*
;* DESCRIPTION   = Convert BCD byte to binary byte ( 2 digits )
;*
;*                 return ( ( n >> 4 ) * 10 + ( n & 0x0F ))
;*
;* INPUT         = BCD byte
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL = al = binary
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

                PUBLIC  _BCDtoBinary
_BCDtoBinary    proc    near

                push    bp
                mov     bp, sp

                mov     al, byte ptr [bp+4]             ; BCD byte
                mov     bl, al                          ; save it
                shr     al, 4                           ; high digit
                mov     cl, al                          ; save it
                shl     al, 1                           ; times 2
                shl     al, 1                           ; times 2
                add     al, cl                          ; + 1 = times 5
                shl     al, 1                           ; times 2 = times 10
                and     bl, 0Fh                         ; low digit
                add     al, bl                          ; al = binary 0 - 99

                pop     bp
                ret

_BCDtoBinary    endp


                PUBLIC  _ZeroFSGS
_ZeroFSGS       proc    near

                push    0
                pop     fs
                push    0
                pop     gs

                ret

_ZeroFSGS       endp


_TEXT ends
     end

