/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPITYP.H
 *
 * DESCRIPTION : Locally defined structures for this driver.
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/

typedef struct _ACB  NEAR *NPACB, FAR *PACB;
typedef struct _UCB  NEAR *NPUCB;
typedef struct _ATBL NEAR *NPATBL;
typedef struct _UTBL NEAR *NPUTBL;

/* Works Space Flags */
#define       WSF_PROC_BLOCK      0x01

typedef struct _Sense_Data
{
        USHORT  error_code                  : 7;
        USHORT  valid                       : 1;
        USHORT  segment_number              : 8;

        UCHAR   sense_key                   : 4;
        UCHAR   reserved_1                  : 1;
        UCHAR   ILI                         : 1;
        UCHAR   EOM                         : 1;
        UCHAR   filemark                    : 1;

        ULONG   information;
        UCHAR   additional_sense_length;
        UCHAR   command_specific_info[4];
        UCHAR   additional_sense_code;
        UCHAR   additional_sense_code_qualifier;
        UCHAR   FRU_Code;
        UCHAR   sensekey_specific[3];
} SENSE_DATA, NEAR *NPSENSE_DATA, FAR *PSENSE_DATA;

typedef struct _GENCONFIGWORD
{
/*                       Bit Field(s)  Ŀ    Description                 */
/*                                      Ŀ                               */
/*                                                                        */

   unsigned int CmdPktSize   : 2;    /*  0- 1 Command Packet Size            */
   unsigned int              : 3;    /*  2- 4 Reserved                       */
   unsigned int CmdDRQType   : 2;    /*  5- 6 CMD DRQ Type                   */
   unsigned int Removable    : 1;    /*   7   Removable                      */
   unsigned int DeviceType   : 5;    /*  8-12 Device Type                    */
   unsigned int              : 1;    /*  13   Reserved                       */
   unsigned int ProtocolType : 2;    /* 14-15 Protocol Type                  */

}GENCONFIGWORD;

/* defines for Identify Drive Data - Capabilities Word */
#define IDD_VendorUniqueMask  0x00FF
#define IDD_DMASupported      0x0100
#define IDD_LBASupported      0x0200
#define IDD_IORDYDisablable   0x0400
#define IDD_IORDYSupported    0x0800

typedef struct _IDENTIFYDATA IDENTIFYDATA, NEAR *NPIDENTIFYDATA,
                                           FAR *PIDENTIFYDATA;

typedef struct _IDENTIFYDATA
{

/*                    word number in structure  Ŀ  Description
                                                                           */

   GENCONFIGWORD     GenConfig;              /*  0 General configuration     */
   USHORT            Reserved1[9];           /*  1 Not Used                  */
   CHAR              Serial[20];             /* 10 Serial Number             */
   USHORT            BufferType;             /* 20 Buffer Type               */
   USHORT            BufferSize;             /* 21 Buffer Size               */
   USHORT            Reserved2;              /* 22 Not Used                  */
   CHAR              Firmware[8];            /* 23 Firmware Revision         */
   CHAR              ModelNum[40];           /* 27 Model Number              */
   USHORT            Reserved3[2];           /* 47 Not Used                  */
   USHORT            Capabilities;           /* 49 Capabilities              */
   USHORT            Reserved4;              /* 50 Not Used                  */
   USHORT            PIOCycleTiming;         /* 51 PIO Cycle Timing          */
   USHORT            DMACycleTiming;         /* 52 DMA Cycle Timing          */
   USHORT            ValidityofOtherWords;   /* 53 Validity of words 54-58   */
                                             /*                  and 64-70   */
   USHORT            CurrentCylHdSec[3];     /* 54 Current                   */
                                             /*    Cylinder/Heads/Sectors    */
   USHORT            CurrentCapacity[2];     /* 57 Current Capacity          */
   USHORT            Reserved5[3];           /* 59 Not Used                  */
   USHORT            SingleDMAmode;          /* 62 Single DMA Mode           */
   USHORT            MultiwordDMAmode;       /* 63 Multiword DMA Mode        */
   USHORT            EnhancedPIOmode;        /* 64 Enhanced PIO Mode         */
   USHORT            BlindPIOminCycTime;     /* 65 Blind PIO Minimum Cycle   */
                                             /*    Time                      */
   USHORT       RecMultiWordDMAxferCycleTime;/* 66 Recommended Multi Word    */
                                             /*    DMA Transfer Cycle Time   */
   USHORT      MinPIOxferCyclewithoutFlowCon;/* 67 Minimum PIO Transfer      */
                                             /*    Cycle Time without Flow   */
                                             /*    Control                   */
   USHORT    MinPIOxferCyclewithIORDYFlowCon;/* 68 Minimum PIO Transfer      */
                                             /*    Cycle Time with IORDY     */
                                             /*    Flow Control              */
   USHORT            Reserved6[256-69];      /* 69 Not Used                  */
} IDENTIFYDATA;

/*-------------------------------*/
/* Unit Control Block            */
/* ------------------            */
/*                               */
/* One per drive on controller.  */
/*                               */
/*-------------------------------*/

typedef struct _UCB
{
  /*-----------------------------------*/
  /* Associated Control Block Pointers */
  /*-----------------------------------*/
  NPACB            npACB;
  USHORT           Flags;
  USHORT           ReqFlags;

  PUNITINFO     pUnitInfo;

  /*--------------------*/
  /* Unit Number (0/1)  */
  /*--------------------*/
  USHORT           UnitId;

  USHORT           Capabilities;
  USHORT           CmdPacketLength;

  UCHAR            RequestSenseBuf[sizeof(SENSE_DATA)];

} UCB;

/* Flags definitions */
#define UCBF_ALLOCATED      0x0001
#define UCBF_READY          0x0002
#define UCBF_DIAG_FAILED    0x0004
#define UCBF_SMSENABLED     0x0008
#define UCBF_MULTIPLEMODE   0x0010
#define UCBF_LBAMODE        0x0020
#define UCBF_IDENTIFYFAIL   0x0040
#define UCBF_NODASDSUPPORT  0x0080

/* ReqFlags definitions */
#define UCBR_RECAL          0x8000
#define UCBR_SETPARAM       0x4000
#define UCBR_IDENTIFY       0x2000
#define UCBR_RESET          0x1000

/* Unit Capabilities */
#define UCBC_ATA                   0x0001
#define UCBC_ATAPI                 0x0002
#define UCBC_DIRECT_ACCESS_DEVICE  0x0004
#define UCBC_CDROM_DEVICE          0x0008
#define UCBC_OPTICAL_MEMORY_DEVICE 0x0010
#define UCBC_MICROPROCESSOR_DRQ    0x0020
#define UCBC_INTERRUPT_DRQ         0x0040
#define UCBC_ACCELERATED_DRQ       0X0080
#define UCBC_DMA                   0x0100
#define UCBC_LBA                   0x0200
#define UCBC_IORDY                 0x0400
#define UCBC_IORDY_DISABLE         0X0800
#define UCBC_SPEC_REV_17B          0x1000
#define UCBC_IRQ_ON_ATA_COMPLETE   0x8000

typedef struct _CMDIO
{
  ADD_XFER_IO   IOSGPtrs;
  USHORT        cXferBytesRemain;
  USHORT        cXferBytesComplete;
  UCHAR         ATAPIPkt[16];
} CMDIO, NEAR *NPCMDIO;


/*-------------------------------*/
/* Adapter Control Block         */
/* ---------------------         */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/


#define FI_MAX_REGS     12

typedef struct _ACB
{
  /*--------------------------------------*/
  /* IORB Queue for units on this adapter */
  /*--------------------------------------*/
  PIORBH        pHeadIORB;
  PIORBH        pFootIORB;
  PIORBH        pIORB;

  /*---------------------------------------------------*/
  /* Controller Register addresses/contents, IRQ level */
  /*---------------------------------------------------*/
  USHORT        IOPorts[FI_MAX_REGS];
  UCHAR         IORegs[FI_MAX_REGS];
  USHORT        IOPendingMask;

  USHORT        IRQLevel;
  USHORT        SpuriousIRQ;
  USHORT        (FAR *IRQHandler)();

  /*-----------------------*/
  /* Inner State Variables */
  /*-----------------------*/
  USHORT        ISMUseCount;
  USHORT        ISMState;
  USHORT        ISMFlags;

  VOID          (FAR *ISMDoneReturn)(NPACB npACB);

  /*-----------------------*/
  /* Outer State Variables */
  /*-----------------------*/
  USHORT        OSMUseCount;
  USHORT        OSMState;
  USHORT        OSMFlags;
  USHORT        OSMReqFlags;

  USHORT        ReqFlags;

  VOID          (FAR *OSMDoneReturn)(NPACB npACB);

  /*--------------------------------*/
  /* Current operation variables    */
  /*--------------------------------*/
  USHORT        IORBStatus;
  USHORT        IORBError;
  NPCMDIO       npCmdIO;
  CMDIO         ExternalCmd;
  CMDIO         InternalCmd;

  /*--------------------------------*/
  /* Timer Flags/Values             */
  /*--------------------------------*/

  USHORT        TimerFlags;
  ULONG         TimeOut;

  /*----------------------*/
  /* Timer Loop Counters  */
  /*----------------------*/
  ULONG         DelayedResetInterval;
  ULONG         DelayedResetCtr;
  ULONG         DelayedRetryInterval;
  ULONG         IRQTimeOut;

  /*--------------------------------------------------*/
  /* Timer Handles                                    */
  /*                                                  */
  /* (Also update TIMERS_PER_ACB when adding timers)  */
  /*--------------------------------------------------*/
  ULONG         IRQTimeOutHandle;
//  ULONG         RetryTimerHandle;
//  ULONG         ResetTimerHandle;

  /*-------------------------------------------------*/
  /* Unit Control Blocks - Unit specific information */
  /*-------------------------------------------------*/
  USHORT        cUnits;
  UCB           UnitCB[MAX_UNITS];
  USHORT        UnitId;
  NPUCB         npUCB;
  USHORT        cResetRequests;

  IORB_DEVICE_CONTROL IORB;

  VOID          (FAR *SharedDriverEP)();
  USHORT        SharedDriverUnitHandle;
  USHORT        ResourceFlags;
  VOID          (FAR *CtxHookRoutine)(NPACB npACB);
  ULONG         CtxHookHandle;
  USHORT        iorbinuse;
  USHORT        suspended;

} ACB;


/* ACB->ISMFlags values */

#define ACBIF_COMPLETION_STATUS_ONLY 0x0001
#define ACBIF_INTERRUPT              0x0002
#define ACBIF_WAITSTATE              0x0004
#define ACBIF_SINGLEIO               0x0008
#define ACBIF_MULTIPLEIO             0x0010
#define ACBIF_ODD_BYTE_XFER          0x0020
#define ACBIF_ATA_OPERATION          0x0040

/* ACB->OSMFlags values */

#define ACBOF_WAITSTATE              0x0001
#define ACBOF_SM_ACTIVE              0x0002
#define ACBOF_PS2IDEPORT             0x0004
#define ACBOF_DISABLERESET           0x0008
#define ACBOF_SM_IDLE                0x0010
#define ACBOF_RESET_ACTIVE           0x0020
#define ACBOF_SENSE_DATA_ACTIVE      0x0040

/* ACB->ReqFlags values */

#define ACBR_RESET                   0x0001
#define ACBR_SENSE_DATA              0X0002
#define ACBR_CONFIGURE_ACB           0x0003

/* ACB->OSMState values */

#define ACBOS_START_IORB         1
#define ACBOS_ISM_COMPLETE       2
#define ACBOS_COMPLETE_IORB      3
#define ACBOS_RESUME_COMPLETE    4
#define ACBOS_SUSPEND_COMPLETE   5

/* ACB->ISMState values */

#define ACBIS_START_STATE              1
#define ACBIS_INTERRUPT_STATE          2
#define ACBIS_COMPLETE_STATE           3
#define ACBIS_WRITE_ATAPI_PACKET_STATE 4

/* ACB->TimerFlags */
#define ACBT_BUSY       0x0001
#define ACBT_DRQ        0x0002
#define ACBT_IRQ        0x0004
#define ACBT_READY      0x0008
#define ACBT_INTERRUPT  0x0010

/* ACB->ResourceFlags */
#define ACBRF_SHARED     0x0001
#define ACBRF_CURR_OWNER 0x0002

/*-------------------------------*/
/* Unit Table                    */
/* ----------                    */
/*                               */
/* One per unit (drive)          */
/*                               */
/*-------------------------------*/

typedef struct _UTBL
{
  USHORT        Flags;
  USHORT        Status;
  USHORT        DriveId;

  USHORT        TimeOut;
//  IDENTIFYDATA  IDdata;

  UCHAR         ModelNum[41];
  UCHAR         Firmware[9];
  UCHAR         Serial[21];
  UCHAR         Reserved;

} UTBL;


#define UTS_OK                  0
#define UTS_NOT_PRESENT         1
//#define UTS_READ_0_FAILED       2


/*-------------------------------*/
/* Adapter Table                 */
/* -------------                 */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/

typedef struct _ATBL
{
  USHORT        BasePort;
  USHORT        IRQLevel;
  USHORT        (FAR *IRQHandler)();

  USHORT        Flags;
  USHORT        Status;

  NPACB         npACB;

  USHORT        cUnits;
  UTBL          Unit[MAX_UNITS];

} ATBL;


#define ATBF_DISABLED             0x0001
#define ATBF_IRQINSTALLED         0x0002
#define ATBF_DISABLERESET         0x0004
#define ATBF_ATAPI_PRESENT        0x0008
#define ATBF_SHARED_ADAPTER       0x0010

#define ATS_OK                  0
#define ATS_NOT_PRESENT         1
#define ATS_SKIPPED             2
#define ATS_SET_IRQ_FAILED      3


/*-------------------------------*/
/* ACB Pointer Block             */
/* -----------------             */
/*                               */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _ACBPTRS
{
  NPACB         npACB;
  USHORT        (FAR *IRQHandler)();

} ACBPTRS;

