/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm1s506/s506ps2.c, idsk, r207, 8.005p 93/03/18";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506PS2.C
 *
 * DESCRIPTIVE NAME = IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Adapter Driver PS/2 IDE Port routines.
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
 #define INCL_NOBASEAPI
 #define INCL_NOPMAPI
 #define INCL_NO_SCB
 #define INCL_INITRP_ONLY
 #define INCL_DOSERRORS
 #include "os2.h"
 #include "dos.h"
 #include "bseerr.h"
 #include "dskinit.h"
 #include <scb.h>
 #include <abios.h>

 #include "iorb.h"
 #include "reqpkt.h"
 #include "dhcalls.h"
 #include "addcalls.h"

 #include "atapips2.h"
 #include "atapicon.h"
 #include "atapityp.h"
 #include "atapiext.h"
 #include "atapipro.h"

///*------------------------------------*/
///*                                    */
///* SetPS2DiskLight                    */
///* ---------------                    */
///*                                    */
///*                                    */
///*------------------------------------*/
//VOID NEAR SetPS2DiskLight( USHORT On )
//{
//  USHORT        Data;
//
//  LightCount += (( On ) ? 1 : -1 );
//
//  if ( (LightState == 0) != (LightCount == 0) )
//  {
//    DISABLE
//
//    LightState = (LightCount != 0);
//
//    inp( PS2_CTRL_PORT_A, Data )
//    IODelay();
//
//    if ( LightState )
//    {
//      Data |= PS2_FIXED_DISK_LIGHT;
//    }
//    else
//    {
//      Data &= ~PS2_FIXED_DISK_LIGHT;
//    }
//    outp( PS2_CTRL_PORT_A, Data );
//    IODelay();
//
//
//    ENABLE
//  }
//}

/*------------------------------------*/
/*                                    */
/* SetupPS2IDEPort                    */
/* ---------------                    */
/*                                    */
/*                                    */
/*------------------------------------*/

VOID NEAR SetupPS2IDEPort( USHORT Enable )
{
  USHORT        Data;
  USHORT        PS2_Setup_Reg;
  USHORT        PS2_Planar_Pos;

  DISABLE

  /*--------------------------*/
  /* Enable Planar Setup Mode */
  /*--------------------------*/
  inp( PS2_SETUP_REG, PS2_Setup_Reg );
  IODelay();

  Data = ~PS2_DISABLE_PLANAR_SETUP;

  outp( PS2_SETUP_REG, Data );
  IODelay();

  /*---------------------------------*/
  /* Enable Fixed Disk POS Reg (103) */
  /*---------------------------------*/
  inp( PS2_PLANAR_POS_REG, PS2_Planar_Pos );
  IODelay();

  PS2_Planar_Pos |= ENABLE_FIXED_POS;

  outp( PS2_PLANAR_POS_REG, PS2_Planar_Pos );
  IODelay();

  /*-------------------------------------------------*/
  /* Enable/Disable Integrated Fixed Disk Controller */
  /*-------------------------------------------------*/
  inp( PS2_FIXED_POS_REG, Data );
  IODelay();

  /*-----------------------------------------------*/
  /* Our engineers cant seem to figure out how     */
  /* to share bits in 3F6/3F7 between the diskette */
  /* and IDE controllers!                          */
  /*-----------------------------------------------*/

  if ( Enable )
  {
    Data |= (ENABLE_FIXED_DRIVE | REG_3F7_TO_DSKT);
    Data &= ~REG_3F6_TO_DSKT;
  }
  else
  {
    Data &= ~ENABLE_FIXED_DRIVE;

    /*--------------------------------------------------*/
    /* Setting the 3F6/3F7 control bits on a Mod 30-286 */
    /* causes the machine to reboot!                    */
    /*--------------------------------------------------*/
    if ( MachineID != MCHID_30286 )
    {
      Data |= (REG_3F6_TO_DSKT | REG_3F7_TO_DSKT);
    }
  }

  outp( PS2_FIXED_POS_REG, Data );
  IODelay();

  /*---------------------------------------*/
  /* Restore original Planar setup reg (94)*/
  /*---------------------------------------*/
  outp( PS2_SETUP_REG, PS2_Setup_Reg )
  IODelay();

  ENABLE
}

