/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIPRO.H
 *
 * DESCRIPTIVE NAME = Proto-types for ATAPI driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

/*
Ŀ
 ATAPIISM.C 

*/

VOID FAR StartOSMRequest           ( NPACB npACB );
VOID NEAR StartISM                 ( NPACB npACB );
VOID NEAR ISMStartState            ( NPACB npACB );
VOID NEAR InterruptState           ( NPACB npACB );
VOID NEAR PutByteInSGList          ( NPACB npACB, USHORT Data );
VOID NEAR StartATAPICmd            ( NPACB npACB );
VOID NEAR StartATACmd              ( NPACB npACB );
VOID NEAR WriteATAPIPkt            ( NPACB npACB );
VOID NEAR InitializeISM            ( NPACB npACB );
USHORT NEAR DRQ_AND_BSY_CLEAR_WAIT ( NPACB npACB );
VOID FAR IRQTimeOutHandler         ( ULONG TimerHandle, ULONG Parm1,
                                                        ULONG Parm2 );
USHORT FAR _loadds AdapterIRQ0     ();
USHORT FAR _loadds AdapterIRQ1     ();
USHORT FAR _loadds AdapterIRQ2     ();
USHORT FAR _loadds AdapterIRQ3     ();
USHORT NEAR AdptInterrupt          ( NPACB npACB );
USHORT NEAR GetRegister            ( NPACB npACB, USHORT Register );

/*
Ŀ
 ATAPIOSM.C 

*/

VOID   FAR StartOSM               ( NPACB npACB );
VOID   NEAR StartIORB             ( NPACB npACB );
VOID   NEAR CompleteIORB          ( NPACB npACB );
VOID   NEAR Execute_CDB           ( NPACB npACB );
VOID   NEAR FreeHWResources       ( NPACB npACB );
USHORT NEAR ImmediateSuspendCheck ( NPACB npACB );
VOID   NEAR GetDeviceTable        ( NPACB npACB );
VOID   NEAR AllocateUnit          ( NPACB npACB );
VOID   NEAR DeallocateUnit        ( NPACB npACB );
VOID   NEAR ChangeUnitInfo        ( NPACB npACB );
VOID   NEAR CompleteInit          ( NPACB npACB );
VOID   NEAR Suspend_Complete      ( NPACB npACB );
VOID   NEAR Resume_Complete       ( NPACB npACB );
USHORT FAR  NextIORB              ( NPACB npACB );
VOID   NEAR GetMediaGeometry      ( NPACB npACB );
VOID   NEAR GetDeviceGeometry     ( NPACB npACB );
VOID   NEAR IORBRead              ( NPACB npACB );
VOID   NEAR GetUnitStatus         ( NPACB npACB );
VOID   NEAR GetLockStatus         ( NPACB npACB );
VOID   NEAR Abort                 ( NPACB npACB );
VOID   NEAR Reset                 ( NPACB npACB );
VOID   NEAR Suspend               ( NPACB npACB );
VOID   NEAR Resume                ( NPACB npACB );
VOID   NEAR LockMedia             ( NPACB npACB );
VOID   NEAR UnlockMedia           ( NPACB npACB );
VOID   NEAR EjectMedia            ( NPACB npACB );
VOID   NEAR GetQueueStatus        ( NPACB npACB );
VOID   NEAR ISMComplete           ( NPACB npACB );
VOID   NEAR SetUpXferData         ( NPACB npACB );

/*
Ŀ
 ATAPINIT.C 

*/
VOID   FAR  DriverInit            ( PRPINITIN  pRPH );
VOID   NEAR SetupADDVars          ();
NPBYTE FAR  InitAllocate          ( USHORT Size );
VOID   FAR  InitDeAllocate        ( USHORT Size );
VOID   NEAR PrintInfo             ( NPATBL npAT );
VOID   NEAR DisplayInfo           ( NPATBL npAT );
VOID   NEAR TTYWrite              ( PSZ Buf );
USHORT NEAR ParseCmdLine          ( PDDD_PARM_LIST pADDParms );
USHORT NEAR ClaimUnit             ( NPATBL npAT, USHORT UnitHandle,
                                    PUNITINFO pOldUnitInfo,
                                    VOID (FAR *DriverEP)() );
USHORT NEAR Issue_ReportResources ( PRESOURCE_ENTRY pRE,
                                    USHORT UnitHandle, VOID (FAR *DriverEP)());
USHORT NEAR Issue_AllocateUnit    ( USHORT UnitHandle, VOID (FAR *DriverEP)());
USHORT NEAR Issue_DeallocateUnit  ( USHORT UnitHandle, VOID (FAR *DriverEP)());
USHORT NEAR Issue_ChangeUnitInfo  ( PUNITINFO pUI, USHORT UnitHandle,
                                    VOID (FAR *DriverEP)() );
VOID   NEAR ConfigureACB          ( NPATBL npAT );
USHORT NEAR ATAPIIdentify         ( NPATBL npAT );
USHORT NEAR ConfigureController   ( NPATBL npAT, USHORT AdapterId );
USHORT NEAR ConfigureUnit         ( NPATBL npAT, USHORT AdapterId, USHORT UnitId );
VOID   NEAR GetATAPIUnits         ();
USHORT NEAR CheckController       ( NPATBL npAT );
USHORT NEAR CheckSectorReg        ( NPATBL npAT );
VOID   NEAR SelectUnit            ( NPACB npACB, USHORT UnitId );
USHORT FAR  CheckReady            ( NPACB npACB );
USHORT NEAR InitSuspendOtherAdd   ( NPACB npACB );
USHORT NEAR InitResumeOtherAdd    ( NPACB npACB );
VOID   FAR  _loadds NotifyInitIORBDone( PIORB pIORB );
USHORT NEAR GetIdentifyData       ( NPACB npACB, USHORT UnitId, PBYTE pID );
VOID   FAR  CalibrateTimers       ( NPACB npACB );
VOID   FAR  CalibrateTimer        ( ULONG hCalibrateTimer, ULONG Unused1,
                                                           ULONG Unused2 );

typedef
VOID   (FAR *PCV)                 ();

ULONG  FAR  CalibrateWorker       ( NPACB npACB, PCV npWorker );
VOID   FAR  ElapsedTimer          ( ULONG hElapsedTimer, ULONG Unused1,
                                                         ULONG Unused2);
VOID   NEAR ResetController       ( NPACB npACB );


/*
Ŀ
 ATAPIGEN.C 

*/

VOID   FAR  IODelay                        ();
VOID   NEAR setmem                         ( PBYTE d, USHORT c, USHORT len );
VOID   NEAR memcopy                        ( PBYTE d, PBYTE s, USHORT len );
VOID   NEAR strncpy                        ( PSZ d, PSZ s, USHORT n );
BOOL   NEAR strncmp                        ( PSZ d, PSZ s, USHORT n );
ULONG  VirtToPhys                          ( PBYTE VirtAddr);
USHORT NEAR SuspendOtherAdd                ( NPACB npACB );
USHORT NEAR ResumeOtherAdd                 ( NPACB npACB );
ULONG  NEAR QueryOtherAdd                  ( NPACB npACB );
VOID   FAR  _loadds NotifySuspendResumeDone( PIORB pIORB );
VOID   NEAR HookIRQ                        ( NPACB npACB );
VOID   FAR Start_ResumeOtherAdd            ( NPACB npACB );
VOID   FAR Start_SuspendOtherAdd           ( NPACB npACB );
VOID   FAR Start_HookIRQ                   ( NPACB npACB );
VOID   NEAR UnHookIRQ                      ( NPACB npACB );
VOID   FAR  PASCAL StateCtxHookRtn         ( VOID );
VOID   NEAR IDECDStr                       ();
USHORT FAR BSY_CLR_DRQ_SET_WAIT            ( NPACB npACB );


/*
Ŀ
 ATAPIORB.C 

*/
typedef PIORB FAR *PPIORB;

VOID   FAR _loadds ATAPIADDEntry  ( PIORBH pNewIORB );
PIORB  NEAR PreProcessIORBs( NPACB npACB, PPIORB ppNewIORB );
VOID   NEAR RemoveIORB( PIORB pIORB, PIORB pIORBPrev, PPIORB pIORBFirst );
USHORT NEAR SuspendIORB( NPACB npACB, PIORB pIORB );
USHORT NEAR ResumeIORB( NPACB npACB, PIORB pIORB );
USHORT NEAR ActivateACBCheck( NPACB npACB );
USHORT NEAR Valid_CDB_Length_Check( PIORBH pIORB, NPACB npACB );
UCHAR  NEAR x2BCD ( UCHAR Data );
VOID   NEAR Convert_17B_to_ATAPI( ULONG pPhysData );

/*
Ŀ
 PRINTF.C 

*/
VOID NEAR sprintf( PSZ s, PSZ fmt, ... );

/*
Ŀ
 dprintf.asm 

*/

VOID NEAR dprintf(CHAR FAR * msg, ...);
