/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIOSM.C
 *
 * DESCRIPTION : OUTER STATE MACHINE for ATAPI driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"

/*
ͻ
                                  
  StartOSM                        
                                  
  Outer State Machine Router      
                                  
ͼ
*/
VOID FAR StartOSM ( NPACB npACB )
{
   DISABLE

   npACB->OSMUseCount++;


   if ( npACB->OSMUseCount == 1 )
   {
      do
      {
         ENABLE
         do
         {
            npACB->OSMFlags &= ~ACBOF_WAITSTATE;
            switch ( npACB->OSMState )
            {
               case ACBOS_START_IORB:
                  StartIORB( npACB );
                  break;

               case ACBOS_ISM_COMPLETE :
                  ISMComplete( npACB );
                  break;

               case ACBOS_COMPLETE_IORB:
                  CompleteIORB( npACB );
                  break;

               case ACBOS_RESUME_COMPLETE:
                  Resume_Complete( npACB );
                  break;

               case ACBOS_SUSPEND_COMPLETE:
                  Suspend_Complete( npACB );
                  break;

               default:
                  _asm { int 3 }
                  break;
            } /* endswitch */

         } while ( !(npACB->OSMFlags & ACBOF_WAITSTATE) ); /* enddo */

         DISABLE

      } while ( --npACB->OSMUseCount ); /* enddo */

   } /* endif */
   ENABLE
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR StartIORB ( NPACB npACB )
{
   NPUCB   npUCB;
   PIORB   pIORB      = npACB->pIORB;
   USHORT  CmdError   = 0;
   USHORT  Command    = 0;
   USHORT  Modifier   = 0;

   if (pIORB)
   {
      Command    = pIORB->CommandCode;
      Modifier   = pIORB->CommandModifier;
      npACB->IORBError  = 0;
      npACB->TimerFlags = 0;
      npUCB             = (NPUCB) pIORB->UnitHandle;
      if (!npUCB)
      {
         _asm INT 3
      }
      npACB->npUCB      = npUCB;
      npACB->UnitId     = npACB->npUCB->UnitId;
      npACB->ISMFlags    = 0;

      switch ( Command )
      {
         case IOCC_CONFIGURATION:

            switch ( Modifier )
            {
               case IOCM_GET_DEVICE_TABLE:
                  GetDeviceTable( npACB );
                  break;

               case IOCM_COMPLETE_INIT:
                  CompleteInit( npACB );
                  break;

               default:
                  CmdError = 1;

            } /* endswitch */
            break;

         case IOCC_UNIT_CONTROL:
            switch ( Modifier )
            {
               case IOCM_ALLOCATE_UNIT:
                  AllocateUnit( npACB );
                  break;

               case IOCM_DEALLOCATE_UNIT:
                  DeallocateUnit( npACB );
                  break;

               case IOCM_CHANGE_UNITINFO:
                  ChangeUnitInfo( npACB );
                  break;

               default:
                  CmdError = 1;

            } /* endswitch */
            break;

         case IOCC_GEOMETRY:
            switch ( Modifier )
            {
               case IOCM_GET_MEDIA_GEOMETRY:
                  GetMediaGeometry( npACB );
                  break;

               case IOCM_SET_MEDIA_GEOMETRY:   /* Ŀ */
                  CmdError = 1;                /*  Command Not Supported  */
                  break;                       /*  */

               case IOCM_GET_DEVICE_GEOMETRY:
                  GetDeviceGeometry( npACB );
                  break;

               case IOCM_SET_LOGICAL_GEOMETRY: /* Ŀ */
                  CmdError = 1;                /*  Command Not Supported  */
                  break;                       /*  */

               default:
                  CmdError = 1;

            } /* endswitch */
            break;

         case IOCC_EXECUTE_IO:
            switch ( Modifier )
            {
               case IOCM_READ:
                  IORBRead( npACB );
                  break;

               case IOCM_READ_VERIFY:          /* Ŀ */
               case IOCM_READ_PREFETCH:        /*  Commands Not Supported  */
               case IOCM_WRITE:                /*  */
               case IOCM_WRITE_VERIFY:
               default:
                  CmdError = 1;
            }
            break;

         case IOCC_FORMAT:   /* Ŀ */
            CmdError = 1;    /*  Format Commands are Not Supported for CDROM */
            break;           /*  */

         case IOCC_UNIT_STATUS:
            switch ( Modifier )
            {
               case IOCM_GET_UNIT_STATUS:
                  GetUnitStatus( npACB );
                  break;

               case IOCM_GET_CHANGELINE_STATE:  /* Ŀ */
               case IOCM_GET_MEDIA_SENSE:       /*  Commands Not Supported  */
                  CmdError = 1;                 /*  */
                  break;

               case IOCM_GET_LOCK_STATUS:
                  GetLockStatus( npACB );
                  break;

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_DEVICE_CONTROL:
            switch ( Modifier )
            {
               case IOCM_ABORT:
                  Abort( npACB );
                  break;

               case IOCM_RESET:
                  Reset( npACB );
                  break;

               case IOCM_SUSPEND:
                  Suspend( npACB );
                  break;

               case IOCM_RESUME:
                  Resume( npACB );
                  break;

               case IOCM_LOCK_MEDIA:
                  LockMedia( npACB );
                  break;

               case IOCM_UNLOCK_MEDIA:
                  UnlockMedia( npACB );
                  break;

               case IOCM_EJECT_MEDIA:
                  EjectMedia( npACB );
                  break;

               case IOCM_GET_QUEUE_STATUS:
                  GetQueueStatus( npACB );
                  break;

               default:
                  CmdError = 1;

            } /* endswitch */
            break;

         case IOCC_ADAPTER_PASSTHRU:
            switch ( Modifier )
            {
               case IOCM_EXECUTE_ATA:    /* Continue on to Execute CDB */
                  npACB->ISMFlags |= ACBIF_ATA_OPERATION;

               case IOCM_EXECUTE_CDB:
                  SetUpXferData( npACB );
                  Execute_CDB( npACB );
                  break;
                                         /* Ŀ */
               case IOCM_EXECUTE_SCB:    /*  Command Not Supported  */
                                         /*  */
               default:
                  CmdError = 1;

            } /* endswitch */
            break;

         default:
            CmdError = 1;

      } /* endswitch */
      if ( CmdError )
      {
         npACB->IORBError = IOERR_CMD_NOT_SUPPORTED;
         npACB->OSMState  = ACBOS_COMPLETE_IORB;
         npACB->OSMFlags  &= ~ACBOF_WAITSTATE;
      }
   }
   else
   {
      /* How did we get here? */
      _asm { INT 3 }
      npACB->OSMFlags |= ACBOF_WAITSTATE;
   }
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR ISMComplete ( NPACB npACB )
{
   UCHAR                    i;
   PSCSI_STATUS_BLOCK       pSCSISB;
   PIORBH                   pIORB;
   UCHAR                    ASC;
   ULONG                    ppExternalSenseDataBuf;

   pIORB = npACB->pIORB;

   npACB->OSMFlags    &= ~ACBOF_WAITSTATE;

   /* is an internal request sense in progress */
   if ( npACB->OSMFlags & ACBOF_SENSE_DATA_ACTIVE )
   {
      npACB->OSMFlags    &= ~ACBOF_SENSE_DATA_ACTIVE;
      npACB->OSMReqFlags &= ~ACBR_SENSE_DATA;

      /*-------------------------------------------------------------------*/
      /* if we are putting the sense data in the users buffer, make a copy */
      /* so it can be examined with the debugger                           */
      /*-------------------------------------------------------------------*/
      if ( npACB->pIORB->RequestControl & IORB_REQ_STATUSBLOCK )
      {
         pSCSISB = MAKEP(SELECTOROF(npACB->pIORB),
                                          (NPBYTE) npACB->pIORB->pStatusBlock);
         memcopy( (PBYTE) &SenseDataBuf,
                          MAKEP( SELECTOROF( pSCSISB ),
                                 OFFSETOF  (pSCSISB->SenseData) ),
                          SENSE_DATA_BYTES );
      }

      if ( !(npACB->OSMReqFlags & ACBR_RESET))
                 /* pass sense data back to caller if requested */
      {
         pSCSISB = MAKEP(SELECTOROF(npACB->pIORB),
                                          (NPBYTE) npACB->pIORB->pStatusBlock);

         if ( npACB->pIORB->pStatusBlock)                           /*@VXXXXXX*/
         {                                                          /*@VXXXXXX*/
            if ( npACB->pIORB->RequestControl & IORB_REQ_STATUSBLOCK )
               pSCSISB->Flags |= STATUS_SENSEDATA_VALID;

            ASC = pSCSISB->SenseData->AddSenseCode;

            if ( ASC > MaxAddSenseDataEntry )
               npACB->pIORB->ErrorCode = IOERR_ADAPTER_REFER_TO_STATUS;
            else
               npACB->pIORB->ErrorCode = AddSenseDataMap[ASC];

            npACB->pIORB->Status    |=  IORB_STATUSBLOCK_AVAIL;     /*@VXXXXXX*/
         }                                                          /*@VXXXXXX*/

         npACB->pIORB->Status    |= IORB_ERROR | IORB_DONE;         /*@VXXXXXX*/
         npACB->OSMState  = ACBOS_COMPLETE_IORB;
      }
   }

   /* was a reset request successful */
   else if ( npACB->OSMFlags & ACBOF_RESET_ACTIVE )
   {

      npACB->npUCB->ReqFlags  &= ~UCBR_RESET;
      npACB->ISMFlags         &= ~ACBIF_ATA_OPERATION;
      npACB->OSMFlags         &= ~ACBOF_RESET_ACTIVE;


      if ( BSYWAIT(npACB) ) /* successful reset */
      {
         npACB->OSMReqFlags      &= ~ACBR_RESET;
         npACB->OSMState          = ACBOS_START_IORB;
         npACB->IORBStatus        = 0;
         npACB->IORBError         = 0;
         npACB->pIORB->ErrorCode |= IOERR_DEVICE_RESET;
      }
      else
      {
         npACB->OSMState   = ACBOS_ISM_COMPLETE;
      }

   }

   /* was there a request for reset */
   else if ( npACB->OSMReqFlags & ACBR_RESET )
   {
      npACB->cResetRequests++;
      cResets++;

      /* if over the reset limit, return error */
      if ( npACB->cResetRequests > MAXRESETS )
      {
         npACB->OSMReqFlags &= ~ACBR_RESET;
         pIORB->ErrorCode  = IOERR_DEVICE_NONSPECIFIC;
         pIORB->Status    |= IORB_DONE | IORB_ERROR;

         npACB->OSMState   = ACBOS_COMPLETE_IORB;
      }
      /* issue reset request */
      else
      {
         npACB->OSMFlags                       |= ACBOF_RESET_ACTIVE;
         npACB->npUCB->ReqFlags                |= UCBR_RESET;
         npACB->ISMFlags                       |= ACBIF_ATA_OPERATION;

         Execute_CDB( npACB );
         npACB->OSMFlags  |= ACBOF_WAITSTATE;

      }
   }

   /* was there a request for sense data */
   else if ( npACB->OSMReqFlags & ACBR_SENSE_DATA )
   {

      npACB->OSMFlags                       |= ACBOF_SENSE_DATA_ACTIVE;
      npACB->npCmdIO                         = &npACB->InternalCmd;

      if ( npACB->pIORB->RequestControl & IORB_REQ_STATUSBLOCK )
      {
         pSCSISB = MAKEP(SELECTOROF(npACB->pIORB),
                                          (NPBYTE) npACB->pIORB->pStatusBlock);

         npACB->npCmdIO->cXferBytesRemain    = pSCSISB->ReqSenseLen;
         SenseDataSGList.XferBufLen          = pSCSISB->ReqSenseLen;
         ppExternalSenseDataBuf = VirtToPhys ( (PBYTE) pSCSISB->SenseData );

         SenseDataSGList.ppXferBuf           = ppExternalSenseDataBuf;
      }
      else
      {
         npACB->npCmdIO->cXferBytesRemain    = SENSE_DATA_BYTES;
         SenseDataSGList.XferBufLen          = SENSE_DATA_BYTES;
         SenseDataSGList.ppXferBuf           = ppSenseDataBuf;
      }

      npACB->npCmdIO->IOSGPtrs.cSGList       = 1;
      npACB->npCmdIO->IOSGPtrs.pSGList       = &SenseDataSGList;
      npACB->npCmdIO->IOSGPtrs.Mode          = PORT_TO_SGLIST;
      npACB->npCmdIO->IOSGPtrs.iPortAddress  = npACB->IOPorts[FI_PDATA];
      npACB->npCmdIO->IOSGPtrs.iSGList       = 0;
      npACB->npCmdIO->IOSGPtrs.SGOffset      = 0;
      npACB->npCmdIO->IOSGPtrs.iSGListStart  = 0;
      npACB->npCmdIO->IOSGPtrs.SGOffsetStart = 0;
      npACB->npCmdIO->cXferBytesComplete     = 0;
      for ( i=0; i < SENSE_DATA_BYTES ; i++ )
      {
         npACB->npCmdIO->ATAPIPkt[i]  =  0;
      }
      npACB->npCmdIO->ATAPIPkt[0]  =  SCSI_REQUEST_SENSE;
      npACB->npCmdIO->ATAPIPkt[4]  =  sizeof(SENSE_DATA);

      Execute_CDB( npACB );
      npACB->OSMFlags  |= ACBOF_WAITSTATE;

   }
   else
   {
      npACB->OSMState  = ACBOS_COMPLETE_IORB;
   }
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR CompleteIORB ( NPACB npACB )
{
   PIORB    pIORB;
   USHORT   ErrorCode = 0;
   NPUCB    npUCB;

   pIORB     = npACB->pIORB;
   npUCB     = npACB->npUCB;
   ErrorCode = npACB->IORBError;

   if ( npACB->TimerFlags )
   {
      ErrorCode = IOERR_UNIT_NOT_READY;
   }

   if ( ErrorCode )
   {
      pIORB->ErrorCode = ErrorCode;
      pIORB->Status    |= IORB_ERROR;
   }

   pIORB->Status |= IORB_DONE;

   npACB->pIORB = 0;

   if ( pIORB->RequestControl & IORB_ASYNC_POST )
   {
      if (( npACB->npUCB->Capabilities & UCBC_SPEC_REV_17B)     &&
          ( npACB->npCmdIO->ATAPIPkt[0] == SCSI_MODE_SENSE_10 ) &&
          (( npACB->npCmdIO->ATAPIPkt[2] & REV_17B_PAGE_CODE_MASK)
                                   == REV_17B_PAGE_CAPABILITIES))
      {
         Convert_17B_to_ATAPI( npACB->npCmdIO->IOSGPtrs.pSGList->ppXferBuf );
      }

      (*pIORB->NotifyAddress)(pIORB);
   }

   DISABLE

   if (( npACB->ResourceFlags & ACBRF_SHARED     ) &&
       ( npACB->ResourceFlags & ACBRF_CURR_OWNER ) )
//     && InitComplete)
   {
      if ( npACB->pHeadIORB )          /* more stuff to do */
      {

         if ( QueryOtherAdd( npACB ) ) /* other add has stuff in queue */
         {
            npACB->OSMState = ACBOS_RESUME_COMPLETE;
            npACB->OSMFlags |= ACBOF_WAITSTATE;
            npACB->ResourceFlags &= ~ACBRF_CURR_OWNER;
            ENABLE
            ResumeOtherAdd( npACB );
         }
         else                          /* other add has empty queue */
         {
            npACB->OSMState = ACBOS_START_IORB;
            if ( NextIORB( npACB ) )
            {
               _asm int 3             /* we said above we had stuff to do
                                         and now we don't ? */
            }
         }
      }
      else                            /* no more work to do */
      {
         npACB->OSMState = ACBOS_RESUME_COMPLETE;
         npACB->OSMFlags |= ACBOF_WAITSTATE;
         npACB->ResourceFlags &= ~ACBRF_CURR_OWNER;                  /*V@93531*/
         ENABLE
         ResumeOtherAdd( npACB );
      }
   }
   else
   {
      npACB->OSMState = ACBOS_START_IORB;

      if ( NextIORB( npACB ) )  /* DISABLE is in NextIORB */
      {
         npACB->OSMFlags |= ACBOF_WAITSTATE;
         npACB->OSMFlags &= ~ACBOF_SM_ACTIVE;
      }
   }
   ENABLE
}

VOID NEAR Resume_Complete( NPACB npACB )
{
   DISABLE
   npACB->suspended = 1;
   if ( NextIORB( npACB) )
   {
      npACB->OSMState = ACBOS_START_IORB;
      npACB->OSMFlags &= ~ACBOF_SM_ACTIVE;
      npACB->OSMFlags |= ACBOF_WAITSTATE;
   }
   else
   {
      npACB->OSMState = ACBOS_SUSPEND_COMPLETE;
      npACB->OSMFlags |= ACBOF_WAITSTATE;
      ENABLE

      SuspendOtherAdd( npACB );
   }
}

VOID NEAR Suspend_Complete( NPACB npACB )
{
   UCHAR Data;

   DISABLE
   npACB->suspended = 0;
   npACB->OSMState = ACBOS_START_IORB;
   npACB->OSMFlags &= ~ACBOF_WAITSTATE;                              /*V@93531*/
   npACB->ResourceFlags |= ACBRF_CURR_OWNER;                         /*V@93531*/
   ENABLE
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
USHORT FAR NextIORB( NPACB npACB )
{
   DISABLE
   if ( npACB->pIORB = npACB->pHeadIORB )
   {
      if ( !(npACB->pHeadIORB = npACB->pIORB->pNxtIORB) )
      {
         npACB->pFootIORB = 0;
      }
   }

   return( (npACB->pIORB) ? 0 : 1);

}

/*
ͻ
                        IOCC_CONFIGUARTION Functions                          
ͼ

ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR GetDeviceTable( NPACB npACB )
{

   PIORB_CONFIGURATION pIORB = (PIORB_CONFIGURATION) npACB->pIORB;

   USHORT        RequiredLength;
   USHORT        AdapterIndex;
   USHORT        UnitIndex;
   PADAPTERINFO  pADPT;
   PUNITINFO     pUI0, pUI1;
   PDEVICETABLE  pDT;
   NPACB         npACBP;

   RequiredLength = sizeof(DEVICETABLE);

   if ( pIORB->DeviceTableLen < RequiredLength )
   {
      pIORB->iorbh.Status   |= IORB_ERROR;
      pIORB->iorbh.ErrorCode = IOERR_CMD_SYNTAX;
   }
   else
   {
      pDT = pIORB->pDeviceTable;

      pDT->ADDLevelMajor = ADD_LEVEL_MAJOR;
      pDT->ADDLevelMinor = ADD_LEVEL_MINOR;
      pDT->ADDHandle     = ADDHandle;
      pDT->TotalAdapters = 0;

   } /* end else */

   npACB->OSMState = ACBOS_COMPLETE_IORB;

} /* GetDeviceTable */

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR CompleteInit( NPACB npACB )
{
   InitComplete = 1;
   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                        IOCC_UNIT_CONTROL Functions                           
ͼ

ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR AllocateUnit( NPACB npACB )
{
   NPUCB     npUCB;

   npUCB = npACB->npUCB;

   if ( npUCB->Flags & UCBF_ALLOCATED )
   {
      npACB->IORBError = IOERR_UNIT_ALLOCATED;
   }
   else
   {
      npUCB->Flags |= UCBF_ALLOCATED;
   }
   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR DeallocateUnit( NPACB npACB )
{
   NPUCB      npUCB;

   npUCB = npACB->npUCB;

   if( !(npUCB->Flags & UCBF_ALLOCATED) )
   {
      npACB->IORBError = IOERR_UNIT_NOT_ALLOCATED;
   }
   else
   {
      npUCB->Flags &= ~UCBF_ALLOCATED;
   }
   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR ChangeUnitInfo( NPACB npACB )
{
   npACB->npUCB->pUnitInfo = ((PIORB_UNIT_CONTROL) npACB->pIORB)->pUnitInfo;
   npACB->OSMState         = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                          IOCC_GEOMETRY Functions                             
ͼ
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR GetMediaGeometry( NPACB npACB )
{

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR GetDeviceGeometry( NPACB npACB )
{

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                         IOCC_EXECUTE_IO Functions                            
ͼ
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR IORBRead( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                        IOCC_UNIT_STATUS Functions                            
ͼ
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR GetUnitStatus( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR GetLockStatus( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                       IOCC_DEVICE_CONTROL Functions                          
ͼ
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR Abort( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR Reset( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR Suspend( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR Resume( NPACB npACB )
{

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR LockMedia( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR UnlockMedia( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR EjectMedia( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR GetQueueStatus( NPACB npACB )
{

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*
ͻ
                      IOCC_ADAPTER_PASSTHRU Functions                         
ͼ
/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR Execute_CDB ( NPACB npACB)
{
   npACB->OSMFlags |= ACBOF_WAITSTATE;
   npACB->OSMState = ACBOS_ISM_COMPLETE;
   StartOSMRequest( npACB );
}

VOID NEAR SetUpXferData( NPACB npACB )
{
   PIORB_ADAPTER_PASSTHRU pIORB;
   UCHAR                  i;
   ULONG                  cXferBytes;
   PSCATGATENTRY          pTempSGList;

   pIORB = (PIORB_ADAPTER_PASSTHRU) npACB->pIORB;

   for ( i=0 ; i < pIORB->ControllerCmdLen ; i++ )
   {
      npACB->npCmdIO->ATAPIPkt[i] = pIORB->pControllerCmd[i];
   }

   /*
   Ŀ
    determine number of bytes in s/g list 
   
   */

   cXferBytes = 0;
   pTempSGList = pIORB->pSGList;

   for ( i=0; i < pIORB->cSGList ; i++, pTempSGList++)
   {
      cXferBytes += pTempSGList->XferBufLen;
   } /* endfor */

   npACB->npCmdIO->cXferBytesRemain   = cXferBytes;
   npACB->npCmdIO->cXferBytesComplete = 0;
                                       /* Clear SG Pointer Entries */
   setmem ( (PBYTE)  &npACB->npCmdIO->IOSGPtrs, 0, sizeof (ADD_XFER_IO) );

   if ( cXferBytes )                   /* Data area is allocated */
   {
      npACB->npCmdIO->IOSGPtrs.Mode          = PORT_TO_SGLIST;
      npACB->npCmdIO->IOSGPtrs.cSGList       = pIORB->cSGList;
      npACB->npCmdIO->IOSGPtrs.pSGList       = pIORB->pSGList;
      npACB->npCmdIO->IOSGPtrs.iPortAddress  = npACB->IOPorts[FI_PDATA];
      npACB->npCmdIO->IOSGPtrs.iSGList       = 0;
      npACB->npCmdIO->IOSGPtrs.SGOffset      = 0;
      npACB->npCmdIO->IOSGPtrs.iSGListStart  = 0;
      npACB->npCmdIO->IOSGPtrs.SGOffsetStart = 0;
   }

   if ( npACB->ISMFlags & ACBIF_ATA_OPERATION )
   {
      if ( npACB->npUCB->ReqFlags & UCBR_IDENTIFY )
      {
         npACB->npCmdIO->IOSGPtrs.Mode = PORT_TO_SGLIST;
      }
   }
}
