/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =     ATAPIORB.C
 *
 * DESCRIPTIVE NAME =     ATAPI IORB Interface to State Machine
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"


VOID FAR _loadds ATAPIADDEntry( PIORBH pNewIORB )
{
   PIORBH    pNewsTailIORB;  /* The tail of the iorb chain for pNewIORB *//*@V102677*/
   NPACB     npACB;
   NPUCB     npUCB;

   /*Ŀ
      Queue IORBs which don't address 
      a specific unit to ACB 0 Unit 0 
      */

   if (pNewIORB->CommandCode == IOCC_CONFIGURATION)
      pNewIORB->UnitHandle = (USHORT) (npUCB = ACBPtrs[0].npACB->npUCB);

   else
      npUCB = (NPUCB) pNewIORB->UnitHandle;

   npACB = npUCB->npACB;

   if ( Valid_CDB_Length_Check(pNewIORB, npACB) )
   {
      pNewIORB->Status    = IORB_DONE | IORB_ERROR;
      pNewIORB->ErrorCode = IOERR_CMD_NOT_SUPPORTED;

      if ( pNewIORB->RequestControl & IORB_ASYNC_POST )
      {
         (*pNewIORB->NotifyAddress)(pNewIORB);
      }
      return;
   }

   DISABLE

   /*Ŀ
      Put new IORB on end of Queue 
     */
   if (!npACB->pHeadIORB)
      npACB->pHeadIORB = pNewIORB;
   else
      npACB->pFootIORB->pNxtIORB = pNewIORB;


   /*Ŀ*/                               /*@V102677*/
   /*Find end of chained request*/                               /*@V102677*/
   /**/                               /*@V102677*/
   for ( pNewsTailIORB = pNewIORB;                                 /*@V102677*/
         pNewsTailIORB->RequestControl & IORB_CHAIN;               /*@V102677*/
         pNewsTailIORB = pNewsTailIORB->pNxtIORB                   /*@V102677*/
       )                                                           /*@V102677*/
     ;                                                             /*@V102677*/
                                                                   /*@V102677*/
   /*Ŀ*/                 /*@V102677*/
   /* Point the foot of the IORB Queue to the */                 /*@V102677*/
   /* tail of the new IORB chain.             */                 /*@V102677*/
   /**/                 /*@V102677*/
   npACB->pFootIORB = pNewsTailIORB;                               /*@V102677*/
                                                                   /*@V102677*/
   /*Ŀ*/                      /*@V102677*/
   /*Make sure pNxtIORB for the for the  */                      /*@V102677*/
   /*Last IORB on our Q is clear.        */                      /*@V102677*/
   /**/                      /*@V102677*/
   npACB->pFootIORB->pNxtIORB = 0;                                 /*@V102677*/

   if ( !(npACB->OSMFlags & ACBOF_SM_ACTIVE))
   {
      npACB->OSMFlags |= ACBOF_SM_ACTIVE;

      NextIORB(npACB);

      npACB->OSMState = ACBOS_START_IORB;
      npACB->IORBStatus = 0;
      npACB->IORBError = 0;
      npACB->cResetRequests = 0;
      npACB->npCmdIO = &npACB->ExternalCmd;

      if (  ( npACB->ResourceFlags & ACBRF_SHARED ) &&
           !( npACB->ResourceFlags & ACBRF_CURR_OWNER ) &&
           !( pNewIORB->CommandCode == IOCC_CONFIGURATION ) &&
           !( pNewIORB->CommandCode == IOCC_UNIT_CONTROL ) )
      {

         npACB->OSMState = ACBOS_SUSPEND_COMPLETE;

         ENABLE

         SuspendOtherAdd( npACB );
      }
      else
      {
         ENABLE
         StartOSM( npACB );
      }
   }
   ENABLE
}

USHORT NEAR Valid_CDB_Length_Check( PIORBH pIORB, NPACB npACB )
{
   USHORT                 rc = FALSE;
   PIORB_ADAPTER_PASSTHRU pAP_IORB;

   pAP_IORB = (PIORB_ADAPTER_PASSTHRU) pIORB;

   if (( pIORB->CommandCode     == IOCC_ADAPTER_PASSTHRU ) &&
       ( pIORB->CommandModifier == IOCM_EXECUTE_CDB ))
   {
      if ( pAP_IORB->ControllerCmdLen == npACB->npUCB->CmdPacketLength )
      {
         rc = TRUE;
      }
   }
   else
      rc = TRUE;

   return(!rc);
}


/***************************************************************************
*
* FUNCTION NAME = x2BCD
*
* DESCRIPTION   = Convert binary byte to BCD byte ( 2 digits )
*
*                 PSEUDOCODE:
*                     return ( (n / 10 << 4) | (n % 10) );
*
* INPUT         = binary byte
*
* OUTPUT        =
*
* RETURN-NORMAL = al = BCD
*
* RETURN-ERROR  = none
*
**************************************************************************/

UCHAR NEAR x2BCD ( UCHAR Data )
{
   _asm {
           mov     al, Data
           xor     ah, ah
           mov     cl, 10
           div     cl
           xchg    ah, al
           shl     ah, 4
           or      al, ah
           mov     Data, al
        }

   return( Data );
}

VOID NEAR Convert_17B_to_ATAPI( ULONG pPhysData )
{
   struct translatetable
   {
      ULONG OldValue;
      ULONG NewValue;
   };

   PBYTE  pData;
   USHORT ModeFlag;
   ULONG  Capabilities_17B = *pData+4;
   PBYTE  pCaps            =  pData+4;
   UCHAR  i, tsize;

   static struct translatetable table[] =
   {
      { CP_AUDIO_PLAY ,                 CP_AUDIO_PLAY },
      { REV_17B_CP_MODE2_FORM1,         CP_MODE2_FORM1 },
      { REV_17B_CP_MODE2_FORM2,         CP_MODE2_FORM2 },
      { REV_17B_CP_READ_CDDA,           CP_CDDA },
      { REV_17B_CP_PHOTO_CD,            CP_MULTISESSION },
      { REV_17B_CP_EJECT,               CP_EJECT },
      { REV_17B_CP_LOCK,                CP_LOCK },
      { REV_17B_CP_UPC,                 CP_UPC },
      { REV_17B_CP_ISRC,                CP_ISRC },
      { REV_17B_CP_INDEPENDENT_VOL_LEV, CP_INDEPENDENT_VOLUME_LEVELS },
      { REV_17B_CP_SEPARATE_CH_MUTE,    CP_SEPARATE_CHANNEL_MUTE },
      { REV_17B_CP_TRAY_LOADER,         CP_TRAY_LOADER },
      { REV_17B_CP_POPUP_LOADER,        CP_POPUP_LOADER },
      { REV_17B_CP_RESERVED_LOADER,     CP_RESERVED_LOADER },
      { REV_17B_CP_PREVENT_JUMPER,      CP_PREVENT_JUMPER },
      { REV_17B_CP_LOCK_STATE,          CP_LOCK_STATE },
      { REV_17B_CP_CDDA_ACCURATE,       CP_CDDA_ACCURATE },
      { REV_17B_CP_C2_POINTERS,         CP_C2_POINTERS }
   };

   tsize = sizeof(table) / sizeof(struct translatetable);

   if ( DevHelp_PhysToVirt( (ULONG)   pPhysData,
                             (USHORT)  1,
                             (PVOID)   &pData,
                             (PUSHORT) &ModeFlag  ) )
   {
      _asm { int 3 }
   }

   Capabilities_17B = *pData+4;
   pCaps            =  pData+4;

   *pCaps = 0;

   for (i=0; i < tsize; i++ )
   {
      if ( Capabilities_17B & table[i].OldValue )
      {
         *pCaps |= table[i].NewValue;
      }
   }
}
