/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIGEN.C
 *
 * DESCRIPTION : General functions for ATAPI driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "devcmd.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"


/*
ͻ
                                  
  IODelay                         
                                  
  Wait for 1 sec                 
                                  
ͼ
*/
VOID FAR IODelay()
{
   ULONG IODelayCtr = IODelayCount;

   while( IODelayCtr--)
      ;
}

/*
ͻ
                                    
  setmem                            
                                    
  Sets memory starting at location  
  p, to the value c, for len bytes  
                                    
ͼ
*/
VOID NEAR setmem( PBYTE d, USHORT c, USHORT len )
{
   USHORT   i;

   for ( i = 0; i < len ; i++ )
      d[i] = (UCHAR) c;

   return;
}

/*
ͻ
                                  
  memcopy                         
                                  
  Copies the contents of memory   
  at the source (s) to the        
  destination (d), for len bytes  
                                  
ͼ
*/
VOID NEAR memcopy( PBYTE d, PBYTE s, USHORT len )
{
   USHORT   i;
   USHORT   j;

   j = len >> 1;

   for ( i = 0; i < j ; i++ )
      ((PUSHORT) d)[i] = ((PUSHORT) s)[i];

   if ( j & 1 ) d[len-1] = s[len-1];


   return;
}

/*
ͻ
                                  
  strncpy                         
                                  
  Copies the contents of string   
  (s) to that of string (d) for   
  (n) characters.  (d) is then    
  null terminated.                
                                  
ͼ
*/
VOID NEAR strncpy( PSZ d, PSZ s, USHORT n )
{
   while( *s && n-- ) *d++ = *s++;
   *d = 0;

   return;
}

/*
ͻ
                                   
  strncmp                          
                                   
  Compares the contents of string  
  (s) to that of string (d) for    
  (n) characters.                  
                                   
ͼ
*/
BOOL NEAR strncmp( PSZ d, PSZ s, USHORT n )
{
   BOOL  rc = TRUE;

   while( n-- )
     if ( *d++ != *s++)
     {
        rc = FALSE;
        break;
     }

   return( rc );
}

/*
ͻ
                                  
  BSYWAIT                         
                                  
  Poll for BSY until success or   
  until exceed max poll time      
                                  
  Returns True if BSY clear       
  False if exceeded max poll time 
                                  
ͼ
*/
USHORT NEAR BSYWAIT ( NPACB npACB )
{

   ULONG cMS = WaitBSYCount;                                         /*V@93531*/
   USHORT Status;

   /*
   Ŀ
    Poll for BSY up to WaitBSYCount times
   
   */

   do
   {
      Status = GetRegister ( npACB, FI_PSTATUS );
      IODelay();
   } while (((Status & FX_BUSY) || Calibrate) && --cMS);

   return (cMS);
}

/*
ͻ
                                  
  DRQ_SET_WAIT                    
                                  
  Poll for DRQ until asserted or  
  until exceed max poll time      
                                  
  Returns True if DRQ set         
  False if exceeded max poll time 
                                  
ͼ
*/                                                                   /*V@93531*/
USHORT FAR BSY_CLR_DRQ_SET_WAIT( NPACB npACB )                       /*V@93531*/
{                                                                    /*V@93531*/
                                                                     /*V@93531*/
   ULONG cMS = WaitDRQCount;                                         /*V@93531*/
   USHORT Status;                                                    /*V@93531*/
                                                                     /*V@93531*/
   /*                                                                  V@93531*/
   /*Ŀ                          V@93531*/
   /* Poll for DRQ up to WaitDRQCount times                          V@93531*/
   /*                          V@93531*/
                                                                     /*V@93531*/
   do                                                                /*V@93531*/
   {                                                                 /*V@93531*/
      Status = GetRegister ( npACB, FI_PSTATUS );                    /*V@93531*/
      IODelay();                                                     /*V@93531*/
   } while ((  !(Status & FX_DRQ) ||
                 Status & FX_BUSY ||
                 Calibrate) &&
            --cMS);                                                  /*V@93531*/
                                                                     /*V@93531*/
   return (cMS);                                                     /*V@93531*/
}                                                                    /*V@93531*/
                                                                     /*V@93531*/
/*
ͻ
                                  
  DRQ_AND_BSY_CLEAR_WAIT          
                                  
  Poll for DRQ and BSY until both 
  are clear or until exceed max   
  poll time                       
                                  
  Returns True if DRQ AND BSY are 
  both clear,                     
  False if exceeded max poll time 
                                  
ͼ
*/                                                                   /*V@93531*/
USHORT NEAR DRQ_AND_BSY_CLEAR_WAIT ( NPACB npACB )                   /*V@93531*/
{                                                                    /*V@93531*/
                                                                     /*V@93531*/
   USHORT cMS = WaitDRQCount;                                        /*V@93531*/
   USHORT Status;                                                    /*V@93531*/
                                                                     /*V@93531*/
   /*  Ŀ                V@93531*/
   /*   Poll for DRQ and BSY up to WaitDRQCount times                V@93531*/
   /*                  V@93531*/
                                                                     /*V@93531*/
   do                                                                /*V@93531*/
   {                                                                 /*V@93531*/
      Status = GetRegister ( npACB, FI_PSTATUS );                    /*V@93531*/
      IODelay();                                                     /*V@93531*/
   } while ((   (Status & FX_BUSY) ||
                (Status & FX_DRQ ) ||
                Calibrate) &&
            --cMS);                                                  /*V@93531*/
     /* enddo */                                                     /*V@93531*/
                                                                     /*V@93531*/
   return (cMS);                                                     /*V@93531*/
}                                                                    /*V@93531*/


/*
ͻ
                                                                  
   VirtToPhys - Convert a virtual to physical address             
                                                                  
   Convert a virtual to a physical address.  This routine does    
   not use DevHlp_VirtToPhys since that devhlp is not callable    
   at interrupt time.                                             
                                                                  
   ULONG  VirtToPhys  (PBYTE VirtAddr)                            
                                                                  
   ENTRY:    VirtAddr         - 16:16 virutal address             
                                                                  
   RETURN:   ULONG            - 32 bit phys address               
                                                                  
ͼ
*/

ULONG VirtToPhys (PBYTE VirtAddr)
{

   USHORT rc;
   SCATGATENTRY ScatGatEntry;
   ULONG VirtLinAddr;
   ULONG ScatLinAddr;
   ULONG PageListCount;

   rc = DevHelp_VirtToLin((USHORT) (SELECTOROF(VirtAddr)),
                          (ULONG) (OFFSETOF(VirtAddr)),
                          (PLIN) &VirtLinAddr);

   rc = DevHelp_VirtToLin((USHORT) ( ((ULONG)((PVOID) &ScatGatEntry)) >> 16),
                          (ULONG)  ( (USHORT)((PVOID) &ScatGatEntry)),
                          (PLIN) &ScatLinAddr);

   rc = DevHelp_LinToPageList(VirtLinAddr, 1, ScatLinAddr,
                                              (PULONG) &PageListCount);

   return(ScatGatEntry.ppXferBuf);

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID NEAR SelectUnit( NPACB npACB, USHORT UnitId )
{
   USHORT        Port;
   USHORT        Data;

   Port                       = npACB->IOPorts[FI_PDRVSLCT];
   npACB->IORegs[FI_PDRVSLCT] =
                DEFAULT_ATAPI_DRV_SLCT_REG | ((UnitId == 0) ? UNIT0 : UNIT1 );
   Data                       = npACB->IORegs[FI_PDRVSLCT];

   outp( Port, Data );
   IODelay();
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
USHORT NEAR SuspendOtherAdd( NPACB npACB )
{
   PIORB_DEVICE_CONTROL  pIORB;
   NPUSHORT              npUS;

   DISABLE
   if ( npACB->iorbinuse )
   {
      _asm int 3
   }
   npACB->iorbinuse = 1;
   ENABLE

   pIORB = (PIORB_DEVICE_CONTROL) &npACB->IORB;
   setmem( (PVOID) pIORB, 0, sizeof(npACB->IORB));

   pIORB->iorbh.Length          = sizeof(IORB_DEVICE_CONTROL);
   pIORB->iorbh.UnitHandle      = npACB->SharedDriverUnitHandle;
   pIORB->iorbh.CommandCode     = IOCC_DEVICE_CONTROL;
   pIORB->iorbh.CommandModifier = IOCM_SUSPEND;
   pIORB->iorbh.RequestControl  = IORB_ASYNC_POST;
   pIORB->iorbh.NotifyAddress   = NotifySuspendResumeDone;
   pIORB->IRQHandlerAddress     = npACB->IRQHandler;                /*@V93531*/

   pIORB->Flags = DC_SUSPEND_DEFERRED | DC_SUSPEND_IRQADDR_VALID;   /*@V93531*/

   npUS = (NPUSHORT) pIORB->iorbh.DMWorkSpace;

   *npUS = (USHORT) npACB;

   (*npACB->SharedDriverEP) ((PVOID)(pIORB));

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
USHORT NEAR ResumeOtherAdd( NPACB npACB )
{
   PIORB_DEVICE_CONTROL  pIORB;
   NPUSHORT              npUS;

   DISABLE
   if ( npACB->iorbinuse )
   {
      _asm int 3
   }
   npACB->iorbinuse = 1;
   ENABLE

   pIORB = (PIORB_DEVICE_CONTROL) &npACB->IORB;
   setmem( (PVOID) pIORB, 0, sizeof(npACB->IORB));

   pIORB->iorbh.Length          = sizeof(IORB_DEVICE_CONTROL);
   pIORB->iorbh.UnitHandle      = npACB->SharedDriverUnitHandle;
   pIORB->iorbh.CommandCode     = IOCC_DEVICE_CONTROL;
   pIORB->iorbh.CommandModifier = IOCM_RESUME;
   pIORB->iorbh.RequestControl  = IORB_ASYNC_POST;
   pIORB->iorbh.NotifyAddress   = NotifySuspendResumeDone;

   npUS = (NPUSHORT) pIORB->iorbh.DMWorkSpace;

   *npUS = (USHORT) npACB;

   (*npACB->SharedDriverEP) ((PVOID)(pIORB));

}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
ULONG NEAR QueryOtherAdd( NPACB npACB )
{
   PIORB_DEVICE_CONTROL  pIORB;

   DISABLE
   if ( npACB->iorbinuse )
   {
      _asm int 3
   }
   npACB->iorbinuse = 1;
   ENABLE

   pIORB = (PIORB_DEVICE_CONTROL) &npACB->IORB;
   setmem( (PVOID) pIORB, 0, sizeof(npACB->IORB));

   pIORB->iorbh.Length          = sizeof(IORB_DEVICE_CONTROL);
   pIORB->iorbh.UnitHandle      = npACB->SharedDriverUnitHandle;
   pIORB->iorbh.CommandCode     = IOCC_DEVICE_CONTROL;
   pIORB->iorbh.CommandModifier = IOCM_GET_QUEUE_STATUS;
   pIORB->iorbh.RequestControl  = 0;
   pIORB->iorbh.NotifyAddress   = 0;

   (*npACB->SharedDriverEP) ((PVOID)(pIORB));
   while ( !(pIORB->iorbh.Status & IORB_DONE) )  /* Wait till done */
      ;

   npACB->iorbinuse = 0;
   return( pIORB->QueueStatus );
}

/*
ͻ
                                  
                                  
                                  
                                  
                                  
ͼ
*/
VOID   FAR  _loadds NotifySuspendResumeDone( PIORB pIORB )
{
   NPACB    npACB;


   npACB = ((NPACB *) pIORB->DMWorkSpace)[0];

   npACB->iorbinuse = 0;

   StartOSM( npACB );

}

/*
ͻ
                                  
                                  
                                  
 Note: can not be called at INT time
                                  
ͼ
*/
VOID HookIRQ( NPACB npACB )
{
   DISABLE
   if ( npACB->ResourceFlags & ACBRF_CURR_OWNER )
   {
      /* Already own IRQ */
      _asm INT 3
   }
   else
   {
      npACB->ResourceFlags |= ACBRF_CURR_OWNER;
      if ( DevHelp_SetIRQ( (NPFN)   npACB->IRQHandler,
                           (USHORT) npACB->IRQLevel,
                           (USHORT) 0                  ) )
      {
         /* Someone already has the IRQ */
         _asm INT 3
      }
   }
   ENABLE
}

///*
//ͻ
//                                  
//                                  
//                                  
//                                  
//ͼ
//*/
//VOID FAR Start_ResumeOtherAdd( NPACB npACB )
//{
//   ResumeOtherAdd( npACB );
//}

/*
ͻ
                                  
                                  
                                  
                                  
ͼ
*/
VOID FAR Start_HookIRQ( NPACB npACB )
{
   HookIRQ( npACB );
   StartOSM( npACB );
}

/*
ͻ
                                  
                                  
                                  
 Note: can not be called at INT time
                                  
ͼ
*/
VOID FAR Start_SuspendOtherAdd( NPACB npACB )
{
   SuspendOtherAdd( npACB );
}

/*
ͻ
                                  
                                  
                                  
 Note: can not be called at INT time
                                  
ͼ
*/
VOID UnHookIRQ( NPACB npACB )
{
   DISABLE
   if ( !( npACB->ResourceFlags & ACBRF_CURR_OWNER ) )
   {
      /* Don't own IRQ */
      _asm INT 3
   }
   else
   {
      npACB->ResourceFlags &= ~ACBRF_CURR_OWNER;
      DevHelp_UnSetIRQ ( npACB->IRQLevel );
   }
   ENABLE
}


/*
ͻ
                                  
                                  
                                  
                                  
ͼ
*/
VOID   FAR PASCAL StateCtxHookRtn( VOID )
{
   NPACB    npACB;
   VOID     (FAR *CtxHookRoutine)( NPACB npACB );

   _asm {  mov     npACB, ax

          _emit    66h
           push    si

          _emit    66h
           push    di

          _emit    66h
           push    bx

        }

    DISABLE
    if ( npACB->CtxHookRoutine )
    {
       CtxHookRoutine        = npACB->CtxHookRoutine;
       npACB->CtxHookRoutine = 0;
       ENABLE
       (*CtxHookRoutine)( npACB );
    }
    ENABLE

   _asm { _emit    66h
           pop     bx

          _emit    66h
           pop     di

          _emit    66h
           pop     si
        }
}


/*
ͻ
                                  
  IDECDStr                        
                                  
  Stategy Routine for IBMIDECD    
                                  
  Accepts only the Init Base      
  device drivers command (0x1B).  
  Returns unknown command for     
  all others.                     
                                  
ͼ
*/
VOID NEAR IDECDStr()
{
   PRPH     pRPH;
   USHORT   Cmd;

   _asm {
           mov word ptr pRPH[0], bx       /*  pRPH is initialized to          */
           mov word ptr pRPH[2], es       /*  ES:BX passed from the kernel    */
        }

   pRPH->Status = STATUS_DONE;
   Cmd = pRPH->Cmd;

   if ( Cmd == CMDInitBase )

      DriverInit( (PRPINITIN) pRPH );

   else
   {
      if ( Cmd == CMDInit )
      {
         Device_Help = ((PRPINITIN)pRPH)->DevHlpEP;
         TTYWrite ( UninstallMsg );
         TTYWrite ( DevEqualsMsg );
      }
      pRPH->Status =  STATUS_DONE | STATUS_ERR_UNKCMD;
   }
   _asm {
           leave
           retf
        }
} /* IDECDStr */

