/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIDAT.C
 *
 * DESCRIPTION : Global Data for ATAPI driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/
#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"

ACBPTRS      ACBPtrs[MAX_ADAPTERS] = { { 0, &AdapterIRQ0 },
                                       { 0, &AdapterIRQ1 },
                                       { 0, &AdapterIRQ2 },
                                       { 0, &AdapterIRQ3 } };
USHORT       InitComplete          = 0;
USHORT       startresume           = 0;
USHORT       startsuspend          = 0;
PFN          Device_Help           = 0L;
USHORT       ADDHandle             = 0;
USHORT       cAdapters             = 0;
USHORT       cUnits                = 0;
USHORT       InitActive            = 0;
USHORT       InitIOComplete        = 0;
USHORT       MachineID             = 0;
USHORT       Calibrate             = 0;
ULONG        WaitDRQCount          = 0;
ULONG        WaitBSYCount          = 0;                              /*V@93531*/
ULONG        CheckReadyCount       = 0;
ULONG        IODelayCount          = 0;
ULONG        ElapsedTimerHandle    = 0;
UCHAR        AdapterName[17]       = "ATAPI CDROM"; /* Adapter Name ASCII string */
LIN          plDataSeg             = 0;
LIN          plSwapCode            = 0;
USHORT       SwapCodeLen           = 0;
USHORT       ADDLockCount          = 0;
LIN          plADDLockHandle       = 0;
#define      TASKTIME               -1L
PULONG       pNestedIntCount       = 0;
USHORT       cInt                  = 0;
UCHAR        ADDLockHandle[12]     = { 0 };

UCHAR        SenseDataBuf[SENSE_DATA_BYTES] = { 0 };
ULONG        ppSenseDataBuf          = 0;
SCATGATENTRY SenseDataSGList         = { 0, SENSE_DATA_BYTES };

USHORT AddSenseDataMap[] = {
   0,                                /* 00h No sense information              */
   IOERR_RBA_ADDRESSING_ERROR,       /* 01h No index/sector signal            */
   IOERR_RBA_ADDRESSING_ERROR,       /* 02h No seek complete                  */
   IOERR_RBA_CRC_ERROR,              /* 03h Write fault                       */
   IOERR_UNIT_NOT_READY,             /* 04h Drive not ready                   */
   IOERR_ADAPTER_DEVICE_TIMEOUT,     /* 05h LUN not selected                  */
   IOERR_RBA_ADDRESSING_ERROR,       /* 06h No track zero found                           */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 07h Multiple drives selected          */
   IOERR_ADAPTER_DEVICE_TIMEOUT,     /* 08h Logical unit communication failure*/
   IOERR_RBA_ADDRESSING_ERROR,       /* 09h Track following error             */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Ah Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Bh Reserved                          */
   IOERR_RBA_CRC_ERROR,              /* 0Ch Write Error                       */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Dh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Eh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Fh Reserved                          */
   IOERR_RBA_ADDRESSING_ERROR,       /* 10h ID CRC or ECC error               */
   IOERR_RBA_CRC_ERROR,              /* 11h Unrecovered Read error            */
   IOERR_RBA_ADDRESSING_ERROR,       /* 12h No address mark found             */
   IOERR_RBA_ADDRESSING_ERROR,       /* 13h No addr mark in data field        */
   IOERR_RBA_ADDRESSING_ERROR,       /* 14h No record found                   */
   IOERR_RBA_ADDRESSING_ERROR,       /* 15h Seek positioning error            */
   IOERR_RBA_ADDRESSING_ERROR,       /* 16h Data synchroniztion mark error    */
   IOERR_RBA_CRC_ERROR,              /* 17h Recovered read w/ retries         */
   IOERR_RBA_CRC_ERROR,              /* 18h Recovered read data w/correction  */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 19h Defect list error                 */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Ah Parameter overrun                 */
   IOERR_ADAPTER_DEVICEBUSCHECK,     /* 1Bh Synchronous transfer err          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Ch Primary defect list not found     */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Dh Compare error                     */
   IOERR_RBA_ADDRESSING_ERROR,       /* 1Eh Recovered ID with ECC correction  */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Fh Reserved                          */
   IOERR_CMD_SYNTAX,                 /* 20h Invalid command op code           */
   IOERR_RBA_ADDRESSING_ERROR,       /* 21h Illegal logical blk addr          */
   IOERR_CMD_SYNTAX,                 /* 22h Illegal func for dev type         */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 23h Reserved                          */
   IOERR_CMD_SYNTAX,                 /* 24h Illegal field in CDW              */
   IOERR_CMD_SYNTAX,                 /* 25h Invalid LUN                       */
   IOERR_CMD_SYNTAX,                 /* 26h Invalid param list field          */
   IOERR_MEDIA_WRITE_PROTECT,        /* 27h Write protected                   */
   IOERR_MEDIA_CHANGED,              /* 28h Medium changed                    */
   IOERR_DEVICE_RESET,               /* 29h Power on reset or bus device reset*/
   IOERR_MEDIA_CHANGED,              /* 2Ah Mode select parameters changed    */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Bh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Ch Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Dh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Eh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Fh Reserved                          */
   IOERR_MEDIA_NOT_SUPPORTED,        /* 30h Incompatible cartridge            */
   IOERR_MEDIA_NOT_FORMATTED,        /* 31h Medium format corrupted           */
   IOERR_MEDIA_NOT_FORMATTED,        /* 32h No defect spare location available*/
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 33h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 34h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 35h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 36h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 37h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 38h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 39h Reserved                          */
   IOERR_MEDIA_NOT_PRESENT,          /* 3Ah Medium Not Present                */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Bh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Ch Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Dh Reserved                          */
   IOERR_UNIT_NOT_READY,             /* 3Eh LUN  not self-configured yet      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Fh Reserved                          */
   IOERR_DEVICE_DIAGFAIL,            /* 40h RAM failure                       */
   IOERR_DEVICE_DIAGFAIL,            /* 41h Data path diagnostic failure      */
   IOERR_DEVICE_DIAGFAIL,            /* 42h Power-on diag failure             */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 43h Message reject error              */
   IOERR_DEVICE,                     /* 44h Internal controller error         */
   IOERR_UNIT_NOT_READY,             /* 45h Select/reselect failed            */
   IOERR_DEVICE_BUSY,                /* 46h Unsuccessful soft reset           */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 47h SCSI interface parity error       */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 48h Initiator detected error          */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 49h Inappropriate/illegal message     */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 50H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 51H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 52H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 53H - Media Load or eject failed    */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 54H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 55H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 56H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 57H - Unable to recover TOC         */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 58H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 59H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5AH - Operator request/state change */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5BH - LOG exception                 */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5CH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5DH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5EH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5FH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 60H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 61H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 62H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 63H - End of User area encountered  */
   IOERR_MEDIA_NOT_SUPPORTED         /* 64H - Illegal Mode for this track   */
   };

   USHORT       MaxAddSenseDataEntry =
                                  ( sizeof(AddSenseDataMap) / sizeof(USHORT) );

USHORT       ACBPoolAvail          = ACB_POOL_SIZE + TIMER_POOL_SIZE +
                                     UNITINFO_POOL_SIZE;

UCHAR        ACBPool[ACB_POOL_SIZE + TIMER_POOL_SIZE +
                     UNITINFO_POOL_SIZE] = { 0 };

NPBYTE       npACBPool             = ACBPool;

/* The throw away section begins with npACBPool.  (At the end of init, it has
   been incremented by the amount of used memory for internal structures.  Any
   unused portion, and all the init data is then thrown away.) */

UCHAR        ScratchBuf[SCRATCH_BUF_SIZE]  = { 0 };
UCHAR        ScratchBuf1[SCRATCH_BUF_SIZE]  = { 0 };

USHORT       ComPort               = COM2ADDRESS;
USHORT       cResets               = 0;

ATBL         AdapterTable[MAX_ADAPTERS] =
{
   /*Ŀ
      Port, IRQ, IRQHandler,       Flags,            Status, npACB, cUnits 
                                            Unit Flags, Unit Status        
                                            Unit Flags, Unit Status        
     */
     {0,     0, &AdapterIRQ0, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} },

     {0,     0, &AdapterIRQ1, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} },

     {0,     0, &AdapterIRQ2, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} },

     {0,     0, &AdapterIRQ3, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} }
};




/*
Ŀ
                                    
    Initialization Data             
                                    
                                    
 This is the address of the         
 discardable data.  All data        
 references after this point will   
 be discarded after init.           
 */
UCHAR        BeginInitData         = 0;

BOOL         Verbose               = FALSE;
BOOL         Installed             = FALSE;

UCHAR       TimersCalibrated       = 0;


#define      MSG_REPLACEMENT_STRING  1178


MSGTABLE     InitMsg               = { MSG_REPLACEMENT_STRING,
                                       1,
                                       0                      };

UCHAR AdptMsg0[] = "OK";
UCHAR AdptMsg1[] = "Adapter not located";
UCHAR AdptMsg2[] = "Adapter skipped";
UCHAR AdptMsg3[] = "Failed to set IRQ";

NPSZ AdptMsgs[] = { AdptMsg0,
                    AdptMsg1,
                    AdptMsg2,
                    AdptMsg3 };

UCHAR UnitMsg0[] = "OK - Device Filtered";
UCHAR UnitMsg1[] = "";

NPSZ UnitMsgs[] = { UnitMsg0,
                    UnitMsg1 };

UCHAR ProtocolTypeMsg0[] = "     ATA";
UCHAR ProtocolTypeMsg1[] = "     ATA";
UCHAR ProtocolTypeMsg2[] = "   ATAPI";
UCHAR ProtocolTypeMsg3[] = "Reserved";

NPSZ ProtocolTypeMsgs[] = { ProtocolTypeMsg0,
                            ProtocolTypeMsg1,
                            ProtocolTypeMsg2,
                            ProtocolTypeMsg3 };

UCHAR DeviceTypeMsg0[] = "             Reserved";
UCHAR DeviceTypeMsg1[] = " Direct-Access Device";
UCHAR DeviceTypeMsg2[] = "               CD-ROM";
UCHAR DeviceTypeMsg3[] = "Optical Memory Device";
UCHAR DeviceTypeMsg4[] = "              Unknown";

NPSZ DeviceTypeMsgs[] = { DeviceTypeMsg1, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg2,
                          DeviceTypeMsg0, DeviceTypeMsg3,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg4 };

UCHAR CMDDRQTypeMsg0[] = "Microprocessor DRQ";
UCHAR CMDDRQTypeMsg1[] = "     Interrupt DRQ";
UCHAR CMDDRQTypeMsg2[] = "   Accelerated DRQ";
UCHAR CMDDRQTypeMsg3[] = "          Reserved";

NPSZ CMDDRQTypeMsgs[] = { CMDDRQTypeMsg0,
                          CMDDRQTypeMsg1,
                          CMDDRQTypeMsg2,
                          CMDDRQTypeMsg3 };

UCHAR        ParmErrMsg[]          = " Warning: IBMIDECD.FLT - Invalid CONFIG.SYS parameters";
UCHAR        UninstallMsg[]        = " Warning: IBMIDECD.FLT - Driver did not load";
UCHAR        VersionMsg[]          =
            "ͻ\r\n"
            "                                                           \r\n"
            " IBM ATAPI (IDE) CDROM Filter for OS/2 2.x & 3.x (v011095) \r\n"
            "                                                           \r\n"
            "ͼ\0";
UCHAR        DevEqualsMsg[]        =
                   "ͻ\r\n"
                   "                                                    \r\n"
                   " IBM ATAPI (IDE) CDROM Driver for OS/2 requires     \r\n"
                   " the following statement in your config.sys file:   \r\n"
                   "                                                    \r\n"
                   " BASEDEV=ibmidecd.flt                               \r\n"
                   "                                                    \r\n"
                   "ͼ\0";

ULONG        CalibrateTimerHandle   = 0;
ULONG        CallWorkerSync         = 0;
ULONG        CallWorker             = 0;

UCHAR                 StringBuffer[80] = { 0 };
UCHAR                 INTStringBuffer[80] = { 0 };
IORB_ADAPTER_PASSTHRU InitIORB = { 0 };
SCATGATENTRY          IdentifySGList         = { 0, 512 };

UCHAR        SearchKeytxt[]        = "IDE_0";
HDRIVER      hDriver               = 0L;
PFN          RM_Help               = 0L;
PFN          RM_Help0              = 0L;
PFN          RM_Help3              = 0L;
ULONG        RMFlags               = 0L;

UCHAR  DrvrNameTxt[]     = "IBMIDECD.FLT";
USHORT DrvrNameSize      = sizeof(DrvrNameTxt);
UCHAR  DrvrDescriptTxt[] = "IBM Filter Driver for IDE ATAPI CDROMs";
UCHAR  VendorNameTxt[]   = "IBM OS/2";

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1995,1,10,                                /* Date                    */
   0,                                        /* DrvrFlags               */
   DRT_ADDDM,                                /* DrvrType                */
   DRS_FILTER,                               /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Device Description                           */
/*----------------------------------------------*/
UCHAR DevDescriptNameTxt[] = "ATAPI_0 IDE CDROM Drive";

DEVICESTRUCT DevStruct =
{
   DevDescriptNameTxt,   /* DevDescriptName; */
   DS_FIXED_LOGICALNAME, /* DevFlags;        */
   DS_TYPE_CDROM         /* DevFlags;        */
};
