;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)ptvdm.asm	6.1 91/02/18
	PAGE	,132
	NAME	PTIMER
	TITLE	Physical Timer Device Driver

;***	Physical Clock Device Driver (PTD)
;
;	SCCSID = @(#)ptvdm.asm 1.00 90/10/10
;
;
;
;
;	PTD-VTD Communication Interface
;
;	DESCRIPTION
;	    This module contains all the PTD-VTD communication
;	    interface procedures.
;
;	MODIFICATION HISTORY
;	10/10/90 MTS	Created.


	.xlist
INCL_MI EQU	1
	include mvdm.inc	;mvdm definitions for dos macros
	include vtdptd.inc	;definitions common to both timer VDD and PDD
	include clkseg.inc	;segment definitions
	include clkdata.inc
	.list

	.386p


ClkData SEGMENT
	extrn	selClkData:word
	extrn	fsPTFlags:word
	extrn	fpfnVTProc:fword
ClkData ENDS


ClkCode SEGMENT

	extrn	PTT0Close:near
	extrn	PTBeepClose:near

EVEN					;make sure it's word aligned
PTFuncTable label word
	dw	offset ClkCode:PTRegister	;PTDCMD_REGISTER
	dw	offset ClkCode:PTDeRegister	;PTDCMD_DEREGISTER
	dw	offset ClkCode:PTEnableTick	;PTDCMD_ENABLETICK
	dw	offset ClkCode:PTDisableTick	;PTDCMD_DISABLETICK
PTMaxFunc	EQU	($-PTFuncTable)/2-1


;***LP	PTVDMProc(ulFunc, ul1, ul2) - VDD request router
;
;	This subroutine is registered by the PDD during system initialization
;	via DevHlp_RegisterPDD, and is called by the VDD to perform various
;	services.  See all the PTDCMD_* equates for a brief list of those
;	services.
;
;	ENTRY
;	    [sp+ 8] = ul2
;	    [sp+12] = ul1
;	    [sp+16] = ulFunc
;
;	    Refer to vtdptd.h for details of ul1 and ul2.
;
;	EXIT-SUCCESS
;	    (eax) = TRUE
;	EXIT-FAILURE
;	    (eax) = FALSE
;
;	USES
;	    All except bx,si,di,bp,ds,es
;
;	CONTEXT
;	    VDD Init-time
;	    VDM Task-time
;
;	PCODE
;	    route to appropriate PT* worker function;
;
;	NOTE
;	    Assume function code can be used as direct function table index.

	ASSUME	CS:ClkCode,DS:NOTHING,ES:NOTHING,SS:NOTHING
Procedure PTVDMProc,far

	?abase	= 8 + 2 		;%%% ret. addr. is 8 bytes, bp 2 bytes
	ArgVar	ul2,ULONG		;BUGBUG Procedure, EndProc should
	ArgVar	ul1,ULONG		;	be changed to support 16:32
	ArgVar	ulFunc,ULONG		;	type of procedure calling.

	EnterProc
	SaveReg <bx,si,di,ds,es>

	mov	ds,cs:[selClkData]
	ASSUME	DS:ClkData

	sub	eax,eax 		;assume failure

	mov	bx,WORD PTR [ulFunc]	;(bx)=ulFunc
	sub	bx,PTDCMD_REGISTER	;don't make assumptions on register equ
	cmp	bx,PTMaxFunc		;is it a valid function?
	ja	ptvx			;NO, goto error exit

	shl	bx,1			;adjust bx as word index

	mov	cx,WORD PTR [ul1+2]
	mov	si,WORD PTR [ul1]	;(cx:si)=ul1
	mov	dx,WORD PTR [ul2+2]
	mov	di,WORD PTR [ul2]	;(dx:di)=ul2

	call	cs:PTFuncTable[bx]	;process requested function

ptvx:	RestoreReg <es,ds,di,si,bx>
	ASSUME	DS:NOTHING

	LeaveProc

	retfd	?aframe 		;%%%

EndProc PTVDMProc


;***LP	PTRegister() - VDD registration
;
;	Record the entry point being registered for the VDD.  This is in
;	respond to PTDCMD_REGISTER and is invoked by the VDM manager
;	in VDHOpenPDD.
;
;	ENTRY
;	    (si:dx,di) = VDD entry point
;
;	EXIT
;	    (eax) = TRUE     //always successful
;
;	USES
;	    None
;
;	CONTEXT
;	    VDD Init-time
;
;	PCODE
;	    store the VDD entry point;
;	    release T0 and T2 ownership to vtimer;

	ASSUME	CS:ClkCode,DS:ClkData,ES:NOTHING,SS:NOTHING
Procedure PTRegister,near

	mov	word ptr [fpfnVTProc],di	;offset low word
	mov	word ptr [fpfnVTProc+2],dx	;offset high word
	mov	word ptr [fpfnVTProc+4],si	;selector

	call	PTT0Close			;release T0 ownership
	call	PTBeepClose			;release T2 ownership

	mov	eax,CTRUE			;return success

	ret

EndProc PTRegister


;***LP	PTDeRegister() - VDD de-registration
;
;	Zero the VDD entry point.  This is in respond to PTDCMD_DEREGISTER.
;
;	ENTRY
;	    None
;
;	EXIT
;	    (eax) = TRUE     //always successful
;
;	USES
;	    None
;
;	CONTEXT
;	    Task-time
;
;	PCODE
;	    zero the VDD entry point;
;	    make sure ptimer now owns both T0 and T2;

	ASSUME	CS:ClkCode,DS:ClkData,ES:NOTHING,SS:NOTHING
Procedure PTDeRegister,near

	xor	eax,eax
	mov	dword ptr [fpfnVTProc],eax	;offset
	mov	word ptr [fpfnVTProc+4],ax	;selector

	mov	[fsPTFlags],PTF_OWNT0+PTF_OWNT2 ;reset ptimer flags

	mov	eax,CTRUE			;return success

	ret

EndProc PTDeRegister


;***LP	PTEnableTick() - VDD request enable timer tick
;
;	Enable tick delivery to timer VDD.
;
;	ENTRY
;	    None
;
;	EXIT
;	    (eax) = TRUE     //always successful
;
;	USES
;	    None
;
;	CONTEXT
;	    VDM Task-time
;
;	PCODE
;	    indicate VDD needs tick;

	ASSUME	CS:ClkCode,DS:ClkData,ES:NOTHING,SS:NOTHING
Procedure PTEnableTick,near

	or	fsPTFlags,PTF_TICKENABLE
	mov	eax,CTRUE			;return success

	ret

EndProc PTEnableTick


;***LP	PTDisableTick() - VDD request disable timer tick
;
;	Disable tick delivery to timer VDD.
;
;	ENTRY
;	    None
;
;	EXIT
;	    (eax) = TRUE     //always successful
;
;	USES
;	    None
;
;	CONTEXT
;	    VDM Task-time
;
;	PCODE
;	    indicate VDD does not need tick;

	ASSUME	CS:ClkCode,DS:ClkData,ES:NOTHING,SS:NOTHING
Procedure PTDisableTick,near

	and	fsPTFlags,NOT PTF_TICKENABLE
	mov	eax,CTRUE			;return success

	ret

EndProc PTDisableTick

ClkCode ENDS


	END
