;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;SCCSID = @(#)clkdata.inc	6.3 91/04/29

BREAK <Clock Device Driver Data Declarations>

;
; segment 40: definitions for RTC functions INT 15, 83 86
;
BIOS_SEG        equ     040h            ; BIOS SEGMENT address (tiled)

USER_FLAG       equ     word ptr [098h] ; address of user byte (low)
USER_FLAG_SEG   equ     word ptr [09ah] ; address of user byte (high)
RTC_LOW         equ     word ptr [09ch] ; low word of timeout
RTC_HIGH        equ     word ptr [09eh] ; high word of timeout
RTC_WAIT_FLAG   equ     byte ptr [0a0h] ; timer interlock flag

; PTIMER EQUATES (fsPTFlags)

PTF_OWNT0       EQU     01h             ; ptimer owns T0
PTF_OWNT2       EQU     02h             ; ptimer owns T2
PTF_TICKENABLE  EQU     04h             ; enable vtimer ticks
PTF_DIRECTACC   EQU     08h             ; vtimer has direct access


RW_BYTES        EQU     6               ; number of bytes to Read / Write

BRKADR          EQU     6CH             ; 006C   BREAK VECTOR ADDRESS

SECP12          EQU     43200           ; Seconds in 12 hours
DAYS1           EQU      3652           ; Days 1-1-1970 through 12-31-79
DAYSINYR        EQU       365           ; days in a normal year
DAYSIN4YR       EQU      1461           ; days in a 4 year period

ERRDNR          EQU     02H             ; Device Not Ready error code
ERRCMD          EQU     03H             ; unknown Command error code
ERRGFAIL        EQU     0CH             ; General Failure error code

RTCHZINIT       EQU     32      ; Initial frequency of RTC periodic interrupt
RTCIRQ          EQU     008H    ; Clock is IRQ 8
RTCBit          EQU     001H    ; Bit in mask for IRQ 0 (RTC)

sizeof_lockhandle_s equ 12      ;BUGBUG vmdevhlp.c describes DevHlp_VMLock,
                                ;which takes: struct lockhandle_s *phlock
                                ;There is no easy way to get an equ to the
                                ;sizeof(struct lockhandle_s). Assume 96 bits.


BREAK <Binary Conversion Routines>
;********************** START OF SPECIFICATIONS *********************
;*
;* MODULE NAME:  BCD2BN
;*
;* DESCRIPTIVE NAME:  Convert BCD value to binary
;*
;* FUNCTION:
;*      Converts 2 digit BCD to 8 bit binary (00 - FFh) in AL.
;*
;* ENTRY POINT:  BCD2BN
;*    LINKAGE:   NEAR
;*
;* USES:  Preserves all registers except AL
;*
;* INPUT: AL = 2 digit BCD number to convert
;*
;* OUTPUT: AX = Binary equivalent (all in AL)
;*
;* EXIT-NORMAL:  AL = binary value of BCD input
;*
;* EXIT-ERROR:  none
;*
;* INTERNAL REFERENCES:
;*    ROUTINES: none
;*
;* EXTERNAL REFERENCES:
;*    ROUTINES: none
;*
;*********************** END OF SPECIFICATIONS **********************
BCD2BN  macro
        xor     ah,ah
        rol     ax,4
        ror     al,4
        aad
endm

BREAK
;********************** START OF SPECIFICATIONS *********************
;*
;* MODULE NAME:  BN2BCD
;*
;* DESCRIPTIVE NAME:  Convert binary value to BCD
;*
;* FUNCTION:
;*      Converts 8 bit binary (00 - FFh) in AL to 2 digit BCD.
;*
;* ENTRY POINT:  BN2BCD
;*    LINKAGE:   NEAR
;*
;* USES:  Preserves all registers except AX
;*
;* INPUT: AL = binary number to convert to 2 digit BCD
;*
;* OUTPUT: AX = 2 digit BCD in [AL], [AH] = 00
;*
;* EXIT-NORMAL:  AL =  BCD value
;*
;* EXIT-ERROR:  none
;*
;* INTERNAL REFERENCES:
;*    ROUTINES: none
;*
;* EXTERNAL REFERENCES:
;*    ROUTINES: none
;*
;*********************** END OF SPECIFICATIONS **********************
BN2BCD  macro
        xor     ah,ah
        aam
        rol     al,4
        ror     ax,4
endm
