/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/*********************************************************************/
/*                                                                   */
/*  SOURCE FILE NAME: svga.h                                         */
/*                                                                   */
/*  DESCRIPTIVE NAME: Include file for Dispinst                      */
/*                                                                   */
/*  FUNCTION:                                                        */
/*                                                                   */
/*  REFERENCES: None                                                 */
/*                                                                   */
/*********************************************************************/


/*
 *key values to add to the ini file
 */
#define MONITOR_RES         "MONITOR_RES"
#define MONITOR_INTERLACE   "MONITOR_INTERLACE"
#define MONITOR_VREFRESH    "MONITOR_VREFRESH"
#define SIZ_DATE_TIME        32


#define SIZ_PARMS           256
#define SIZ_TOWRITE         256
#define INDEX_RESOLUTION    0
#define INDEX_INTERLACE     1
#define INDEX_VREFRESH      2

#define AM_QUIT     WM_USER + 0
#define MAX_SIZ_KEY   64
#define SLEEP_TIME    1000
#define CSF_CIDENVR  "CAS_STATE"

/*
 *svga specific structure declarations
 */
typedef struct parms
{
     PSZ pszApplicationKey;
     PSZ pszParms;
     PSZ pszStringToWrite;
     PFN pfnWriteParmToIni;
}INIPARMS,*PINIPARMS;

typedef struct _resolutiondata
{
     ULONG Horiz;
     ULONG Vert;
     ULONG Colors;
}RESOLUTIONDATA,*PRESOLUTIONDATA;


typedef struct _svgautildata
{
    HAB  hab;
    PSZ  pszTitle;                 /* resource string */
    PSZ  pszMsg;                 /* resource string */
    PSZ  pszBuffer;              /* pointer for svga utility */
    BOOL fParms;                 /* flag for presence of svga util parameters */
}SVGAUTILDATA,*PSVGAUTILDATA;


typedef struct _SESSIONRESULT {
    USHORT usSessionID;
    USHORT usResultCode;
} SESSIONRESULT, *PSESSIONRESULT;


/*
 *application specific error
 *numbers
 */

#define WRITE_INI_ERROR   2




#define  ONCE            while(0)
#define  FOREVER         while(1)
#define  MAX_PARMS       3

/*
 *resource information for  the svga
 *dll
 */


#define ID_NULL                      -1
#define WM_INIT                     500
#define DID_LOCATE                  531
/*
      Dialog box ids    300 - ???  ------  Continued from dispres.h
*/
#define DLG_RUNSVGA                  315
#define DLG_SVGAUTIL                 316
#define DLG_SELECTSVGAUTIL           317

#define MAXDRIVES                    26
#define RESOLUTION_NUM                3

/* resource string ids */

#define MSG_BAD_RESOLUTIONS_FILE       0
#define MSG_UNABLE_TO_DETERMINE_HARD   1
#define MSG_GET_DLL_HANDLE             2
#define MSG_HARDWARE_CONFIG_ERROR      3
#define MSG_SVGAUTIL_NOT_FOUND         4
#define MSG_FILE_NOT_EXIST             5
#define MSG_SVGA_ERROR_TITLE           6
#define MSG_SVGA_INSTALL               7
#define MSG_MAINHELPTITLE              8
#define MSG_APPTITLE                   9
#define MSG_HELPNOTAVAIL              10
#define MSG_FILEDLG_TITLE             11

#define SVGA_MODULE                   "SVGAINST.DLL"
#define S3_MODULE                     "SVGA.DLL"
#define COMMAND_COM                   "COMMAND.COM"


HWND hwndHelpInstance;
CHAR szAutoExecDsp[] =     "C:\\OS2\\AUTOEXEC.DSP";
CHAR szConfigDsp[]   =     "C:\\OS2\\CONFIG.DSP";
CHAR szAutoExecName[]=     "C:\\AUTOEXEC.BAT";
CHAR szConfigSys[]   =     "C:\\CONFIG.SYS";
BOOL fSvgaUtilPresent=      FALSE;

