/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %%s %%s %%s */

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/*********************************************************************/
/*                                                                   */
/*  SOURCE FILE NAME: dispvars.h                                     */
/*                                                                   */
/*  DESCRIPTIVE NAME: Global variable file for DISPINST              */
/*                                                                   */
/*  FUNCTION: This include file contains the global variables.       */
/*                                                                   */
/*  ENTRY POINT: None                                                */
/*                                                                   */
/*  PARAMETERS: None                                                 */
/*   Input:                                                          */
/*   Output:                                                         */
/*                                                                   */
/*  REFERENCES: None                                                 */
/*                                                                   */
/*********************************************************************/

#if defined(DEF_PUBLIC)
  #define PUBLIC(a,b)   a = b
  #define PUBLICU(a)    a
#else
  #define PUBLIC(a,b)   extern a
  #define PUBLICU(a)    extern a
#endif

/* global variables */
PUBLICU (HWND    hwndMain);                 /* window handle for main thread */
PUBLICU (HWND    hwndMainFrame);
PUBLICU (HWND    hwndHelpInstance);

PUBLIC  (HWND    hwndProgress, 0);
PUBLICU (HAB     hab);
PUBLICU (HMQ     hmq);
PUBLICU (HAB     habWorker);
PUBLICU (HMQ     hmqWorker);
PUBLICU (TID     tidWorker);
PUBLICU (UCHAR   dbcs_mask_[256]);           /* the dbcs lead character mask */
PUBLIC  (PSZ     pszSourceDir, NULL);                          /* source dir */
PUBLICU (PSZ     pszDestDir);                                    /* dest dir */
PUBLICU (CHAR    szBootDrive[3]);                     /* bootdrive (i.e. C:) */
PUBLICU (PCHAR   achDSPBuffer);              /* buffer used by GetNextChar() */
PUBLICU (HFILE   hDDP);                  /* handle to current open .DDP file */
PUBLIC  (PVOID   pMemory,             NULL); /* memory allocated during init */
PUBLIC  (HMODULE hmodResource,        0);                 /* resource module */
PUBLIC  (USHORT  usCurrentTag,        TAG_INVALID);
PUBLIC  (CHAR    szErrFile[CCHMAXPATH],"");        /* store file that failed */
PUBLIC  (CHAR    szExecPath[CCHMAXPATH],"");     /* path where executed from */
PUBLIC  (BOOL    fConfigUpdated,      FALSE);             /* config updated? */
PUBLIC  (BOOL    fReplaceModule,      FALSE);       /* in-use file replaced? */
PUBLIC  (HEAD    headConfig,          {NULL});        /* store :CONFIG lines */
PUBLIC  (HEAD    headAdapterTypes,    {NULL});         /* store dispinst.cfg */
PUBLIC  (ULONG   ulGlobalExitCode,      0   );      /* return code from main */
PUBLIC  (BOOL    fFullInstall,        FALSE );     /* full install */

PUBLIC  (ULONG   ulGlobalInfoFlags,       0);

#define F_DOS_INSTALLED      0x00000001
#define F_WIN_INSTALLED      0x00000002
#define F_SC_VGA_ON_SVGA     0x00000004         /* special case: vga on svga */
#define F_BIDI_INSTALLED     0x00000008                  /* arabic or hebrew */
#define F_FERENGI_INSTALLED  0x00000010         /* FERENGI installed */
#define F_PRELOADED_SYSTEM   0x00000020         /* PRELOADED SYSTEM    @FERENGI*/
#define F_CID_ENVIRONMENT    0x00000040         /* CID environment */

/*      for warp code, so that install calls dspinstl to display video panels */
#define F_CALLED_BY_INSTALL_FOR_PRIMARY    0x10000000
#define F_CALLED_BY_INSTALL_FOR_SECONDARY  0x20000000

PUBLIC  (ADAPTERTYPE  adpinfoPrimary,        {0});
PUBLIC  (ADAPTERTYPE  adpinfoSecondary,      {0});
PUBLIC  (PADAPTERTYPE pAdapterTypePrimary,   NULL);
PUBLIC  (PADAPTERTYPE pAdapterTypeSecondary, NULL);
PUBLIC  (BOOL         fResponseFile,         FALSE);

/* global arrays */
PUBLICU (CHAR    **rcstringarray);                  /* resource string array */
PUBLICU (USHORT  DriveArray[26]);                        /* disk drive array */
/* string constants */
PUBLIC  (CHAR szSelf[],               ".");
PUBLIC  (CHAR szParent[],             "..");
PUBLIC  (CHAR szWildcard[],           "*");
PUBLIC  (CHAR szHelpFile[],           "C:\\OS2\\HELP\\DSPINSTL.HLP");
PUBLIC  (CHAR szConfigTag[],          ":CONFIG");
PUBLIC  (CHAR szFilesTag[],           ":FILES");
PUBLIC  (CHAR szOS2iniTag[],          ":OS2INI");
PUBLIC  (CHAR szTitleTag[],           ":TITLE");
PUBLIC  (CHAR szRunTag[],             ":RUN");
PUBLIC  (CHAR szKeyTag[],             ":KEY");
PUBLIC  (CHAR szWinIniTag[],          ":WININI");
PUBLIC  (CHAR szSystemIniTag[],       ":SYSTEM_INI");
PUBLIC  (CHAR szVideoParmsTag[],      ":VIDEO_PARMS");
PUBLIC  (CHAR szSetDriverTag[],       ":SET_DRIVER");
PUBLIC  (CHAR szSetResolutionTag[],   ":SET_RESOLUTION");
PUBLIC  (CHAR szAutoExecTag[],        ":AUTO_EXEC");
PUBLIC  (CHAR szDelConfigLines[],     ":DEL_CONFIG_LINE");
PUBLIC  (CHAR szAppendTag[],          ":APPEND");              //@FERENGI

PUBLIC  (CHAR szModeTag[],            ":MODE");
PUBLIC  (CHAR szPrimaryMode[],        "PRIMARY");
PUBLIC  (CHAR szSecondaryMode[],      "SECONDARY");
PUBLIC  (CHAR szDosMode[],            "DOS");
PUBLIC  (CHAR szWindowsMode[],        "WINDOWS");
PUBLIC  (CHAR szBidiMode[],           "BIDI");
PUBLIC  (CHAR szDualMode[],           "DUAL");

PUBLIC  (CHAR szNameKey[],            "NAME");
PUBLIC  (CHAR szDescKey[],            "DESC");
PUBLIC  (CHAR szPathNameKey[],        "PATHNAME");
PUBLIC  (CHAR szParmsKey[],           "PARMS");
PUBLIC  (CHAR szWidthKey[],           "WIDTH");
PUBLIC  (CHAR szHeightKey[],          "HEIGHT");
PUBLIC  (CHAR szColorsKey[],          "COLORS");
PUBLIC  (CHAR szPlanesKey[],          "PLANES");
PUBLIC  (CHAR szOptionsKey[],         "OPTIONS");

/* files on boot drive */
PUBLIC  (CHAR szConfigSys[],          "C:\\CONFIG.SYS");
PUBLIC  (CHAR szDosFile[],            "C:\\OS2\\MDOS\\DOSKRNL");
PUBLIC  (CHAR szSystemIni[CCHMAXPATH],   "C:\\OS2\\MDOS\\WINOS2\\SYSTEM.INI");   // @WIN@
PUBLIC  (CHAR szWinCom[CCHMAXPATH],      "C:\\OS2\\MDOS\\WINOS2\\WIN.COM");      // @WIN@
PUBLIC  (CHAR szWinIniPath[CCHMAXPATH],  "C:\\OS2\\MDOS\\WINOS2\\");             // @WIN@
PUBLIC  (CHAR szOs2IniPath[],         "C:\\OS2\\");
PUBLIC  (CHAR szOs2Ini[],             "C:\\OS2\\OS2.INI");
PUBLIC  (CHAR szOs2SysIni[],          "C:\\OS2\\OS2SYS.INI");
PUBLIC  (CHAR szReinstalIni[],        "C:\\OS2\\INSTALL\\REINSTAL.INI");  // @WIN@
PUBLIC  (CHAR szLogFile[],            "C:\\OS2\\INSTALL\\DSPINSTL.LOG");
PUBLIC  (CHAR szSystemMsgFile [],     "C:\\OS2\\SYSTEM\\OSO001.MSG");
PUBLIC  (CHAR szDummyModule[],        "C:\\OS2\\INSTALL\\DISP$DW");
PUBLIC  (CHAR szAutoExecName[],       "C:\\AUTOEXEC.BAT");
PUBLIC  (CHAR szWinDiskIns[],         "C:\\OS2\\INSTALL\\WINFILE.INS");   // @FERENGI


/* sprintf constants */
PUBLIC  (CHAR szDriveSelection[],     "[%c:]");
PUBLIC  (CHAR szDriveEntry[],         "%c:\\");
PUBLIC  (CHAR szPathBSlashPath[],     "%s\\%s");
PUBLIC  (CHAR szPathPath[],           "%s%s");
PUBLIC  (CHAR szIntToString[],        "%d;");        /* for Prf write of int */

/* Default Data variables */
PUBLICU  (CHAR szSourceDirectory[CCHMAXPATH] );
PUBLICU  (CHAR szResponseFileName[CCHMAXPATH]);

PUBLICU  (CHAR szDestination[CCHMAXPATH]);
PUBLICU  (CHAR szWindowsSourcePath[CCHMAXPATH]);
PUBLIC   (PSZ  pszResponseLogName, NULL);
PUBLICU  (CHAR szDefaultSourceDir[CCHMAXPATH]);
PUBLICU  (CHAR szTitleString     [SIZ_VALUE_STRING]);
PUBLICU  (CHAR szDisplayString   [SIZ_VALUE_STRING]);
PUBLIC   (PSZ  pszOs2RcName,     "INI.RC");
PUBLIC   (ULONG ulExecutionMode, PM_APPLICATION );
PUBLIC   (PSZ   pszPrimaryKey  , NULL           );
PUBLIC   (PSZ   pszSecondaryKey, NULL           );
PUBLIC   (PSZ   pszResolutionKey, NULL          );          //CID
PUBLIC   (BOOL  fSourcePathSet , 0              );
PUBLIC   (ULONG  ulPassedHandle , 0             );
PUBLIC   (BOOL   fInstallComplete, 0            );
PUBLIC   (BOOL   fAbiosPresent, 0               );  /* DonW 68000 */
PUBLIC   (HMTX   hmtxLog,(HMTX)0                );  //@MTD
PUBLIC   (HMTX   hmtxReportErr,(HMTX)0          );  //@MTD
PUBLIC   (ULONG  cFilesTotal, 0                 );  //D87507
