/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %%s %%s %%s */

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/*********************************************************************/
/*                                                                   */
/*  SOURCE FILE NAME: dispstrc.h                                     */
/*                                                                   */
/*  DESCRIPTIVE NAME: Structure file for DISPINST                    */
/*                                                                   */
/*  FUNCTION: This include file contains the structures.             */
/*                                                                   */
/*  ENTRY POINT: None                                                */
/*                                                                   */
/*  PARAMETERS: None                                                 */
/*   Input:                                                          */
/*   Output:                                                         */
/*                                                                   */
/*  REFERENCES: None                                                 */
/*                                                                   */
/*********************************************************************/

//////////////////////////////////////////////////////////////////
// structure used to "malloc" memory
//////////////////////////////////////////////////////////////////
typedef struct _MEMORYITEM
{
    ULONG cb;
    BYTE  mem[1];
} MEMORYITEM;
typedef MEMORYITEM *PMEMORYITEM;

//////////////////////////////////////////////////////////////////
// structure used to determine how much memory the system has
//////////////////////////////////////////////////////////////////
typedef struct _MEMINFO
 {
  USHORT usLowMemKB;
  ULONG  ulHighMemKB;
 } MEMINFO;

//////////////////////////////////////////////////////////////////
// structure used for linked lists
//////////////////////////////////////////////////////////////////
typedef struct _HEAD
{
    PVOID pFirst;
    PVOID pLast;
}HEAD,*PHEAD;

//////////////////////////////////////////////////////////////////
// structure for data returned by DosQueryFSAttach (FSQBUFFER2)
//////////////////////////////////////////////////////////////////
typedef struct _FSDINFO
{
    USHORT iType;
    USHORT cbName;
    USHORT cbFSDName;
    USHORT cbFSAData;
    UCHAR  szName[CCHMAXPATH];
    UCHAR  szFSDName[CCHMAXPATH];
    UCHAR  rgFSAData[CCHMAXPATH];
} FSDINFO;
typedef FSDINFO *PFSDINFO;

//////////////////////////////////////////////////////////////////
// window data for the main window
//////////////////////////////////////////////////////////////////
typedef struct _WINDATA
{
    BOOL   fSrcDirChecked;                     /* have we validated src dir? */
    PSZ    pszKey;
    ULONG  ulFlags;
    PSZ    pszVolumeLabel;
    PSZ    pszDiskettePrompt;
    PSZ    pszGeneralPrompt;
    HEAD   headDsps;
} WINDATA;
typedef WINDATA *PWINDATA;

//////////////////////////////////////////////////////////////////
// window data for file dialogs
//////////////////////////////////////////////////////////////////
typedef struct _FILDLG
{
    PWINDATA pwin;                              /* pointer to pwin structure */
    HWND     hwndEntryfield;                         /* hwnd for entry field */
    HWND     hwndListBox;                               /* hwnd for list box */
    BOOL     fEditing;           /* edit field has focus but has not changed */
    BOOL     fSelected;                   /* item in dir listbox is selected */
    CHAR     szDirectory[CCHMAXPATH];         /* current directory in dialog */
} FILDLG;
typedef FILDLG *PFILDLG;

//////////////////////////////////////////////////////////////////
// MPARAM data for the worker thread
//////////////////////////////////////////////////////////////////
typedef struct _WORKERMPARAM
{
    MPARAM mp1;
    MPARAM mp2;
} WORKERMPARAM;
typedef WORKERMPARAM *PWORKERMPARAM;

//////////////////////////////////////////////////////////////////
// structures used for storing .DSP file data
//////////////////////////////////////////////////////////////////
typedef struct _CONFIG
{
    struct _CONFIG *next;
    PSZ pszLine;
} CONFIG;
typedef CONFIG *PCONFIG;

///////////////////////////////////////////////////////
//structure to hold the global DSPINSTAL data structure
///////////////////////////////////////////////////////



                                 /* flags for ulFlags field of FILES */
#define F_PACKED     0x00000001  /* source is packed */
#define F_BUNDLE     0x00000002  /* source contains a bundle of packed files */

typedef struct _FILES
{
    struct _FILES *next;
    ULONG ulFlags;
    PSZ   pszSource;
    PSZ   pszDest;
} FILES;
typedef FILES *PFILES;

typedef struct _OS2INI
{
    struct _OS2INI *next;
    PSZ pszIniFile;
    PSZ pszApp;
    PSZ pszKey;
    PSZ pszValue;
} OS2INI;
typedef OS2INI *POS2INI;


//////////////////////////////////////////////////////////////////
// structures used for display adapter types
//////////////////////////////////////////////////////////////////

#define F_DEFAULT_PRIMARY     0x0001                    /* for usFlags below */
#define F_DEFAULT_SECONDARY   0x0002

typedef struct _KNOWN_ADAPTER  /* kadp */              /* for initialization */
{
    PSZ      pszKey;                                          /* default key */
    USHORT   usMid;                                /* msg id of adapter type */
    USHORT   usFlags;                                     /* see flags above */
    PUSHORT  pusMidSubtype;                                      /* for SVGA */
} KNOWN_ADAPTER;

typedef struct dspinstl_chain_element
{
     ULONG ulRevNum;
     struct dspinstl_chain_element  *pNextDspInstl;
     PSZ   pszKey;                                 //Key for action routine to modify
                                                   //i.e. ET4000 adapter type
     PSZ   pszGeneralPrompt;
     PSZ   pszDiskettePrompt;
     PSZ   pszVolumeLabel;
     PSZ   pszResolution;
}DSPINSTL_CHAIN,*PDSPINSTL_CHAIN;

typedef struct dspinstl_global_data
{
     ULONG rev_num;
     PFN   pfnLinkChainRoutine;
     PFN   pfnUnlinkChainRoutine;
     PFN   pfnNextElementRoutine;
     PFN   pfnGetResponseFile;
     PFN   pfnSpecifyResolution;
     PFN   pfnSpecifyVideoMonitor;
     PFN   pfnSpecifyDisplayAdapter;
     PFN   pfnLogFunction;
     PDSPINSTL_CHAIN  pHeadDspInstl_Chain;
     BOOL  fResponseInstall;
     PSZ   pszSourceDirectory;
     ULONG ulSizeSource;
     PSZ   pszResolutionString;                               //CID
}DSPINSTL_GLOBAL_DATA,*PDSPINSTL_GLOBAL_DATA;



#define F_LIST_ALL    0x00000001   /* show all valid available adapter types */

typedef struct _ADAPTERTYPE   /* adptype */
{
    struct      _ADAPTERTYPE  *pNextAdapter;
    PDSPINSTL_GLOBAL_DATA     pDspInstlHead;
    ULONG       ulCount;                     /* Number of Parameter Sets */
    BOOL        fSelectedPrimary;
    BOOL        fSelectedSecondary;
    ULONG       ulRevNum;
    PSZ         pszTitle;
    PSZ         pszKey;                      //SVGA or other known key value
    PSZ         pszActionDll;
    ULONG       ulFlags;                     /* see above */
    USHORT      iAdapter;                    /* index of known adapter type */
    USHORT      iAdapterSubtype;                           /* for SVGA @DSW@ */
    USHORT      usMonitor;                   /* Primary or secondary */
    USHORT      iAdapterChipSet;             /* adapter ChipSet; 90163 */
    PSZ         pszChipSets;                 /* SVGA Chipsets supported;90163 */
    LONG        iItem;                       /* item index in list box;90163 */
    PSZ         pszDSCfileName;              /* warp DSC file used for install */
} ADAPTERTYPE, *PADAPTERTYPE;

//typedef struct _ADAPTERINFO /* adpinfo */
//{
//  ULONG        ulRevNum;
//  USHORT       iAdapter;                    /* index of known adapter type */
//  PADAPTERTYPE padptype;                    /* Head of the adapter chain   */
//  CHAR         szKeyActual[MAX_KEY];        /* after action routine */
//  ULONG        ulFlags;                     /* see above */
//  USHORT       iAdapter;                    /* index of known adapter type */
//}ADAPTERINFO, *PADAPTERINFO;


//////////////////////////////////////////////////////////////////
// structures used for monitor.cfg
//////////////////////////////////////////////////////////////////

typedef struct _PARM   /* parm */
{
    struct _PARM *next;
    PSZ    pszParm;
} PARM, *PPARM;

typedef struct _MONITOR /* mtr */
{
    struct _MONITOR *next;
    PSZ    pszTitle;
    ULONG  cParmSets;
    ULONG  cParmsPerSet;
    HEAD   headParmSet;
} MONITOR, *PMONITOR;

typedef struct _DLGINFO /* dlginfo */
{
    PVOID  pvIn;
    PVOID  pvOut;
} DLGINFO, *PDLGINFO;


//////////////////////////////////////////////////////////////////
// structures used for adapter.cfg
//////////////////////////////////////////////////////////////////

typedef struct _ADAPTER /* adp */
{
    struct _ADAPTER *next;
    PSZ    pszTitle;
    ULONG  cParms;
    HEAD   headParms;
} ADAPTER, *PADAPTER;


//////////////////////////////////////////////////////////////////
// structures used to store DSPs
//////////////////////////////////////////////////////////////////

typedef struct _DSP        /* dsp */
{
    struct _DSP *next;
    PSZ pszDspFilename;
    HEAD headDspLines;
} DSP, *PDSP;

typedef struct _DSPLINE    /* dspln */
{
    struct _DSPLINE *next;
    ULONG  ulTag;                                            /* type of line */
    ULONG  ulFlags;                                       /* see flags below */
    ULONG  iTagLine;                          /* index of line following tag */
    PSZ    pszLine;
} DSPLINE, *PDSPLINE;

typedef struct _resolutions
{
    UCHAR  achResolutionString[MAX_RESOLUTION_STRING];
    ULONG  ulSelected;
}RESOLUTIONS,*PRESOLUTIONS;


typedef struct _winresolutiondata
{
     PRESOLUTIONS pResolutions;
     BOOL         bAllowMultipleResolutions;
     ULONG        ulCountResolutions;
     PDSPINSTL_GLOBAL_DATA pInstalData;
}WINRESOLUTIONDATA,*PWINRESOLUTIONDATA;

typedef struct _svgawaitdata
{
     HWND hwnd;
     ULONG ulSession;
     ULONG ulProcessid;
}SVGAWAITDATA,*PSVGAWAITDATA;

                                                /* flags for DSPLINE ulFlags */
#define F_MODE_PRIMARY    0x00000001
#define F_MODE_SECONDARY  0x00000002
#define F_MODE_DOS        0x00000004
#define F_MODE_WINDOWS    0x00000008
#define F_MODE_BIDI       0x00000010
#define F_MODE_DUAL       0x00000020


//////////////////////////////////////////////////////////////////
// structure used by Specify_Display_Adapter call-back function
//////////////////////////////////////////////////////////////////

typedef struct _ADAPTERENTRY  /* adpentry */
{
    CHAR   szTitle[CCH_MAX_TITLE];
    ULONG  cParms;
    CHAR   achParms[CCH_MAX_ADP_PARMS];
} ADAPTERENTRY, *PADAPTERENTRY;


//////////////////////////////////////////////////////////////////
// structures used by Specify_Video_Monitor call-back function
//////////////////////////////////////////////////////////////////

typedef struct _VIDEOPARM     /* vidparm */
{
    ULONG  cParms;
    CHAR   achParms[CCH_MAX_VID_PARMS];
} VIDEOPARM, *PVIDEOPARM;

typedef struct _VIDEOENTRY    /* videntry */
{
    CHAR      szTitle[CCH_MAX_TITLE];
    ULONG     cVideoParms;
    VIDEOPARM avidparm[C_MAX_VID_PARMS];
} VIDEOENTRY, *PVIDEOENTRY;


/*--------------------------------------------------------------*\
 * DLGINFO - This structure contains a semaphore and a window   *
 *         handle.  This information is used to corrdinate      *
 *         displaying of a dialog in the foreground thread from *
 *         the background thread (see MainDlgBox)               *
\*--------------------------------------------------------------*/

struct DLGINFO {  /* dlginfo */
    MRESULT mr;        /* returned.  For MainLoadDlg: hwnd of created window */
                                   /* For MainDlgBox: SHORT1(mr)=return code */
    HWND   hwndOwner;                      /* handle of owner window created */
    PFNWP  pfnDlgProc;                                /* function for dialog */
    USHORT idDlg;
    PVOID  pCreateParams;
    BOOL   fDestroy;   /* TRUE if window should be destroyed after displayed */
    HEV    hev;              /* RAM sem to indicate window creation complete */
};


/*--------------------------------------------------------------*\
 * MBXINFO - This structure contains a semaphore and a window   *
 *         handle.  This information is used to corrdinate      *
 *         displaying of a message box in the foreground thread *
 *         from the background thread (see MainMessageBox)      *
\*--------------------------------------------------------------*/

struct MBXINFO {  /* mbxinfo */
    ULONG   rc;                            /* return code from WinMessageBox */
    HWND    hwndOwner;                     /* handle of owner window created */
    HEV     hev;                 /* RAM sem to indicate WinMessageBox return */
    USHORT  id;                         /* message box id (for help manager) */
    USHORT  flStyle;                              /* defines buttons, others */
    PSZ     pszText;                              /* contents of message box */
    PSZ     pszTitle;
};



typedef struct DMQSdata
{                               /* DMQS data structure */               /*@ISO*/
   USHORT   next_DMQS_offset;                                           /*@ISO*/
   BYTE     slot_number;                                                /*@ISO*/
   USHORT   level_id;                                                   /*@ISO*/
   ULONG    vendor_id;                                                  /*@ISO*/
   USHORT   io_reg_base;                                                /*@ISO*/
   USHORT   mmio_regs;                                                  /*@ISO*/
   USHORT   one_meg_aperture;                                           /*@ISO*/
   USHORT   four_meg_aperture;                                          /*@ISO*/
   USHORT   vram_base;                                                  /*@ISO*/
   USHORT   monitor_id;                                                 /*@ISO*/
   BYTE     vram_size;                                                  /*@ISO*/
} DMQSDATA;                                                             /*@ISO*/

typedef struct  exec_tokens
{
     PSZ   pszToken;
     ULONG ulValue;
}EXEC_TOKENS,*PEXEC_TOKENS;


//////////////////////////////////////////////////////////////////
// structure used by IsAnyABIOSPresent().    DonW 68000
//////////////////////////////////////////////////////////////////

#define HW_CFG_MCA              0x00000001
#define HW_CFG_EISA             0x00000002
#define HW_CFG_ABIOS_SUPPORTED  0x00000004
#define HW_CFG_ABIOS_PRESENT    0x00000008

typedef struct _BIOSINFO {
    USHORT usModel;
    USHORT usSubmodel;
    USHORT usRevision;
    USHORT fABIOSPresent;
} BIOSINFO, FAR *PBIOSINFO;

typedef struct _THREADINFO {              //@MTD
   PHEAD  phead;                          //@MTD
   PHEAD  pheadNext;                      //@MTD
   BOOL   fSaveChanges;                   //@MTD
   ULONG rc;                              //@MTD
} THREADINFO, *PTHREADINFO;               //@MTD

TID   tidConfig;                          //@MTD
TID   tidOS2ini;                          //@MTD

/* D87507 */
typedef struct _STYLEDATA               /* style data for progress indicator */
{
    ULONG  ulBorder;                                         /* border width */
    ULONG  ulMargin;                                         /* margin width */
    ULONG  ulBmpID;                                             /* bitmap ID */
    COLOR  clrProg;                              /* progress indicator color */
    COLOR  clrSlider;                                    /* slider-bar color */
    COLOR  clrBorder;                                        /* border color */
} STYLEDATA, *PSTYLEDATA;

typedef struct _WINDATA2      /* window specific data for progress indicator */
{
    HWND       hwndSlider;                           /* handle to slider-bar */
    ULONG      ulBmpWidth;                                /* width of bitmap */
    HBITMAP    hbm;                                    /* handle to a bitmap */
    PSTYLEDATA pstyle;                            /* pointer to style struct */
} WINDATA2, *PWINDATA2;
