/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %%s %%s %%s */

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/*********************************************************************/
/*                                                                   */
/*  SOURCE FILE NAME: dispres.h                                      */
/*                                                                   */
/*  DESCRIPTIVE NAME: Define file for DISPINST                       */
/*                                                                   */
/*  FUNCTION: This include file contains the defines for resource    */
/*            files.                                                 */
/*                                                                   */
/*  ENTRY POINT: None                                                */
/*                                                                   */
/*  PARAMETERS: None                                                 */
/*   Input:                                                          */
/*   Output:                                                         */
/*                                                                   */
/*  REFERENCES: None                                                 */
/*                                                                   */
/*********************************************************************/

/*--------------------------------------------------------------*\
 *  Resource ids                     100-199                    *
\*--------------------------------------------------------------*/
#define IDR_FRAME                    100
#define IDR_IBMBMP                   101
#define IDR_DISPLAY                  102
#define IDR_35DISK                   103
#define IDR_OS2BMP                   104         /* D87507 */

/*--------------------------------------------------------------*\
 *  Menu ids                         200-299                    *
\*--------------------------------------------------------------*/
#define IDM_SYSMENU                  200

/*--------------------------------------------------------------*\
 *  Dialog box ids                   300-399                    *
\*--------------------------------------------------------------*/
#define DLG_MAIN                     300
#define DLG_ABOUT                    301
#define DLG_SELECTPRIMARY            302
#define DLG_SELECTSECONDARY          303
#define DLG_SELECTMONITOR            304
#define DLG_SELECTADAPTER            305
#define DLG_SELECTDIR                306
#define DLG_SOURCE                   307
#define DLG_SELECTDDP                308
#define DLG_INSTALL                  309
#define DLG_INSERT35DISK             310
#define DLG_SPECIFYRESOLUTION        311
#define DLG_INSERT35DISK_CANCEL      312
#define DLG_REPORTERROR              313
#define DLG_DSPLYLOGFILE             314
#define DLG_PROGRESS                 315      /* D87507 */

/*--------------------------------------------------------------*\
 *  Message box ids                  400-499                    *
\*--------------------------------------------------------------*/
#define MBX_SRCDIRERR                400
#define MBX_NODSPERR                 401
#define MBX_INSTERROR                402
#define MBX_EXIT                     403

/*--------------------------------------------------------------*\
 *  Control ids                      500-599                    *
\*--------------------------------------------------------------*/
#define ID_NULL                      -1
#define IDB_CHANGESOURCEDIR          500
#define IDB_CHANGEDESTDIR            501
#define IDB_HELP                     502
#define IDE_SOURCEDIR                503
#define IDE_DESTDIR                  504
#define IDE_DIRECTORY                505
#define IDL_DIRECTORIES              506
#define IDL_DDPTITLES                507
#define IDT_CHANGEDIR                508
#define IDT_LOGOTEXT                 509
#define IDT_DRIVERNAME               510
#define IDT_INSTTXT1                 511
#define IDT_INSTTXT2                 512
#define IDB_PRIMARY                  513
#define IDB_SECONDARY                514
#define IDT_PRIMARY                  515
#define IDT_SECONDARY                516
#define IDL_GENERAL                  517
#define IDT_TITLESOURCE              518
#define IDT_DISKTEXT                 519
#define IDT_DISK_LABEL               520
#define IDT_DISKPROMPT               521
#define IDT_ERRORMSG                 522
#define IDT_CONTINUE                 523
#define IDB_COMMANDPROMPT            524
#define IDB_YES                      525
#define IDB_NO                       526
#define IDD_MLE                      527
#define IDB_DSPLYLOGFILE             528
#define IDB_DEFAULTSETTINGS          529
#define IDB_SVGAUTIL                 530
#define IDD_GAUGE_BOX                531         /* D87507 */

/*--------------------------------------------------------------*\
 *  Help table ids                   900-999                    *
\*--------------------------------------------------------------*/
#define MAIN_HELP_TABLE              900

#define SUBTABLE_MAIN                910
#define SUBTABLE_DLG                 920
#define SUBTABLE_MBX                 930

/*--------------------------------------------------------------*\
 *  Help table ids                  1000-1999                   *
\*--------------------------------------------------------------*/
#define HELP_DLG_MAIN               1300
#define HELP_DLG_ABOUT              1301
#define HELP_DLG_SELECTPRIMARY      1302
#define HELP_DLG_SELECTSECONDARY    1303
#define HELP_DLG_SELECTMONITOR      1304
#define HELP_DLG_SELECTADAPTER      1305
#define HELP_DLG_SELECTDIR          1306
#define HELP_DLG_SOURCE             1307
#define HELP_DLG_SELECTDDP          1308
#define HELP_DLG_INSTALL            1309
#define HELP_DLG_SPECIFYRESOLUTION  1310
#define HELP_DLG_REPORTERROR        1311
#define HELP_DLG_SELECTSVGAUTIL     1312
#define HELP_DLG_SVGAUTIL           1313
#define HELP_DID_FILE_DIALOG        1314

#define HELP_MBX_SRCDIRERR          1400
#define HELP_MBX_NODSPERR           1401
#define HELP_MBX_INSTERROR          1402
#define HELP_MBX_EXIT               1403
#define KEYS_HELP_PANEL_ID           275

/*--------------------------------------------------------------*\
 *  String ids                    600-799                       *
\*--------------------------------------------------------------*/
#define ID_STRING_IDS                640                   /* multiple of 16 */

#define rcstring(id)              (rcstringarray[(id) - ID_STRING_IDS])

/* NOTE: The following strings are always used during display install.       */
/*       They are loaded into an array during initialization.                */
#define IDS_APPTITLE              (ID_STRING_IDS + 0)
#define IDS_SOURCEDIRIS           (ID_STRING_IDS + 1)
#define IDS_DESTDIRIS             (ID_STRING_IDS + 2)
#define IDMSG_INITFAILED          (ID_STRING_IDS + 3)
#define IDMSG_MAINWINCREATEFAILED (ID_STRING_IDS + 4)
#define IDMSG_EXIT                (ID_STRING_IDS + 5)
#define IDMSG_REBOOT              (ID_STRING_IDS + 6)
#define IDMSG_HELPFATALERR        (ID_STRING_IDS + 7)
#define IDMSG_HELPERROCCUR        (ID_STRING_IDS + 8)
#define IDMSG_HELPNOTAVAIL        (ID_STRING_IDS + 9)
#define IDS_MAINHELPTITLE         (ID_STRING_IDS + 10)
#define IDS_NOTITLE               (ID_STRING_IDS + 11)
#define IDMSG_NODSPERROR          (ID_STRING_IDS + 12)
#define IDMSG_SRCDIRERROR         (ID_STRING_IDS + 13)
#define IDMSG_DESTDIRERROR        (ID_STRING_IDS + 14)
#define IDMSG_REMOVABLEDST        (ID_STRING_IDS + 15)
#define IDMSG_SRCNOTREADY         (ID_STRING_IDS + 16)
#define IDMSG_DRIVENOTEXIST       (ID_STRING_IDS + 17)
#define IDMSG_NOSELECTERROR       (ID_STRING_IDS + 18)
#define IDS_CURRENTFILE           (ID_STRING_IDS + 19)
#define IDMSG_UPDATINGENV         (ID_STRING_IDS + 20)
#define IDS_ERRTITLE              (ID_STRING_IDS + 21)
#define IDMSG_DESTNEWER           (ID_STRING_IDS + 22)
#define IDMSG_STARTDRIVER         (ID_STRING_IDS + 23)
#define IDS_LOGSEP                (ID_STRING_IDS + 24)
#define IDMSG_COPY                (ID_STRING_IDS + 25)
#define IDMSG_SEVERALPREDICATE    (ID_STRING_IDS + 26)
#define IDS_FIRST_DISPLAY         IDS_DISPLAY_MPA
#define IDS_DISPLAY_MPA           (ID_STRING_IDS + 27)
#define IDS_DISPLAY_CGA           (ID_STRING_IDS + 28)
#define IDS_DISPLAY_EGA           (ID_STRING_IDS + 29)
#define IDS_DISPLAY_VGA           (ID_STRING_IDS + 30)
#define IDS_DISPLAY_8514          (ID_STRING_IDS + 31)
#define IDS_DISPLAY_XGA           (ID_STRING_IDS + 32)
#define IDS_DISPLAY_SVGA          (ID_STRING_IDS + 33)
#define IDS_DISPLAY_OTHER         (ID_STRING_IDS + 34)
#define IDS_DISPLAY_NONE          (ID_STRING_IDS + 35)
#define NUM_DISPLAYS              (IDS_DISPLAY_OTHER - IDS_FIRST_DISPLAY + 1)
#define IDS_FIRST_SVGAMFGR        IDS_SVGAMFGR_UNKNOWN              /* @DSW@ */
#define IDS_SVGAMFGR_UNKNOWN      (ID_STRING_IDS + 36)              /* @DSW@ */
#define IDS_SVGAMFGR_HEADLAND     (ID_STRING_IDS + 37)              /* @DSW@ */
#define IDS_SVGAMFGR_TRIDENT      (ID_STRING_IDS + 38)              /* @DSW@ */
#define IDS_SVGAMFGR_TSENG        (ID_STRING_IDS + 39)              /* @DSW@ */
#define IDS_SVGAMFGR_WESTDIG      (ID_STRING_IDS + 40)              /* @DSW@ */
#define IDS_SVGAMFGR_ATI          (ID_STRING_IDS + 41)              /* @DSW@ */
#define IDS_SVGAMFGR_SPEEDWAY     (ID_STRING_IDS + 42)              /* @DSW@ */
#define IDS_SVGAMFGR_CIRRUS       (ID_STRING_IDS + 43)              /* @TWM@ */
#define IDS_SVGAMFGR_S3           (ID_STRING_IDS + 44)              /* @TWM@ */
#define IDS_SVGAMFGR_CAT          (ID_STRING_IDS + 45)              /* @TWM@ */
#define IDS_SVGAMFGR_WEITEK       (ID_STRING_IDS + 46)              /* @TWM@ */
#define IDS_SVGAMFGR_NUMBER9      (ID_STRING_IDS + 47)              /* @TWM@ */
#define IDS_SVGAMFGR_GENERICPCI   (ID_STRING_IDS + 48)              /* @TWM@ */
#define NUM_SVGAMFGRS             (IDS_SVGAMFGR_GENERICPCI - IDS_FIRST_SVGAMFGR + 1) /* @DSW@ */
#define IDMSG_FERENGI_CONFIG      (ID_STRING_IDS + 49)              /*@FERENGI*/
#define IDMSG_FERENGI_INSTALL     (ID_STRING_IDS + 50)              /*@FERENGI*/
#define NUM_STRINGS                                51               /* @DSW@ */

/* NOTE: The following string ID's are used as return codes for fatal errors.*/
/*       The strings are WinLoadString'd during the reporting of the error.  */
/*       They are not loaded during initialization because they may not be   */
/*       used.                                                               */
#define MSG_DISP_DSP_OPEN_FAIL      (ID_STRING_IDS + NUM_STRINGS + 0)
#define MSG_DISP_DSP_INVALID        (ID_STRING_IDS + NUM_STRINGS + 1)
#define MSG_DISP_READ_FAULT         (ID_STRING_IDS + NUM_STRINGS + 2)
#define MSG_DISP_WRITE_FAULT        (ID_STRING_IDS + NUM_STRINGS + 3)
#define MSG_DISP_DISK_FULL          (ID_STRING_IDS + NUM_STRINGS + 4)
#define MSG_DISP_OPEN_FAIL          (ID_STRING_IDS + NUM_STRINGS + 5)
#define MSG_DISP_CANNOT_MAKE        (ID_STRING_IDS + NUM_STRINGS + 6)
#define MSG_DISP_OS2INI_FAIL        (ID_STRING_IDS + NUM_STRINGS + 7)
#define MSG_DISP_EXEC_FAIL          (ID_STRING_IDS + NUM_STRINGS + 8)
#define MSG_DISP_EXIT               (ID_STRING_IDS + NUM_STRINGS + 9)
#define MSG_DISP_NO_KEY_MATCH       (ID_STRING_IDS + NUM_STRINGS + 10)
#define MSG_DISP_INVALID_ACTION_DLL (ID_STRING_IDS + NUM_STRINGS + 11)
#define MSG_DISP_INSERT             (ID_STRING_IDS + NUM_STRINGS + 12)
#define MSG_DISP_DISK_MSG           (ID_STRING_IDS + NUM_STRINGS + 13)
#define MSG_NO_DSC_FILES            (ID_STRING_IDS + NUM_STRINGS + 14)
#define MSG_DSC_BAD_ARGCOUNT        (ID_STRING_IDS + NUM_STRINGS + 15)
#define MSG_BAD_ADAPTER_TYPE        (ID_STRING_IDS + NUM_STRINGS + 16)
#define MSG_PRI_SEC_SAME            (ID_STRING_IDS + NUM_STRINGS + 17)
#define MSG_INVALID_UNPACK          (ID_STRING_IDS + NUM_STRINGS + 18)
#define MSG_UNPACK_NOT_FOUND        (ID_STRING_IDS + NUM_STRINGS + 19)
#define MSG_FILE_NOT_FOUND          (ID_STRING_IDS + NUM_STRINGS + 20)
#define MSG_COPY_ERROR              (ID_STRING_IDS + NUM_STRINGS + 21)
#define MSG_DISP_WININI_FAIL        (ID_STRING_IDS + NUM_STRINGS + 22)
#define MSG_DISP_CONFIG_FAIL        (ID_STRING_IDS + NUM_STRINGS + 23)
#define MSG_DISP_SETDRIVER_FAIL     (ID_STRING_IDS + NUM_STRINGS + 24)
#define MSG_DISP_SETRES_FAIL        (ID_STRING_IDS + NUM_STRINGS + 25)
#define MSG_INVALID_VERSIONS        (ID_STRING_IDS + NUM_STRINGS + 26)
#define MSG_INVALID_DSC_FILE        (ID_STRING_IDS + NUM_STRINGS + 27)
#define MSG_PRESS_ENTER             (ID_STRING_IDS + NUM_STRINGS + 28)
#define MSG_UPDATING_DISPLAYS       (ID_STRING_IDS + NUM_STRINGS + 29)
#define MSG_ONE_MOMENT              (ID_STRING_IDS + NUM_STRINGS + 30)
#define MSG_PLS_WAIT                (ID_STRING_IDS + NUM_STRINGS + 31)
#define MSG_ADAPTER_NOT_COMPAT      (ID_STRING_IDS + NUM_STRINGS + 32)
#define MSG_DSC_NOT_COMPAT          (ID_STRING_IDS + NUM_STRINGS + 33)
#define MSG_DISP_AUTOEXEC_FAIL      (ID_STRING_IDS + NUM_STRINGS + 34)
#define MSG_DSC_NOT_FOUND           (ID_STRING_IDS + NUM_STRINGS + 35)
#define IDS_LIST_NONE               (ID_STRING_IDS + NUM_STRINGS + 36)
