/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %%s %%s %%s */

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/*********************************************************************/
/*                                                                   */
/*  SOURCE FILE NAME: dispdefs.h                                     */
/*                                                                   */
/*  DESCRIPTIVE NAME: Define file for DISPINST                       */
/*                                                                   */
/*  FUNCTION: This include file contains the defines.                */
/*                                                                   */
/*  ENTRY POINT: None                                                */
/*                                                                   */
/*  PARAMETERS: None                                                 */
/*   Input:                                                          */
/*   Output:                                                         */
/*                                                                   */
/*  REFERENCES: None                                                 */
/*                                                                   */
/*********************************************************************/

#include "dispres.h"                                     /* resource defines */

/* memory defines */
#define PAGE_SIZE               (ULONG)(4 * 1024)         /* 80386 page size */
#define MEMORY_ALLOCATION       PAGE_SIZE * 150        /* memory to allocate */
#define WORKER_STACK_SIZE       PAGE_SIZE * 4   /* worker threads stack size */
#define FILE_BUFFER_SIZE        PAGE_SIZE    /* size of buffer for .DDP file */
#define DSPTHREAD_STACK_SIZE    PAGE_SIZE * 2   /* @MTD DSP threads stack size */

/* general defines */
#define SAME_STRING             0
#define NEG1                    (USHORT)-1                   /* negative one */
#define EOL                     '\0'              /* end of line - zero byte */
#define EOFCHAR                 0x1a           /* char to denote end of file */
#define CR                      '\r'                      /* carriage return */
#define LF                      '\n'                            /* line feed */
#define FF                      '\f'                            /* form feed */
#define STAR                    '*'                              /* asterisk */
#define QMARK                   '?'                         /* question mark */
#define SPACE                   ' '                                 /* space */
#define TAB                     '\t'                                  /* tab */
#define COLON                   ':'                                 /* colon */
#define WNDCLASSNAME            "DISPCLASS"             /* main window class */
#define MAX_KEY                 64                  /* maximum length of key */
#define MAX_TITLE               256                   /* max length of title */
//D100432 #define MAX_RESOLUTIONS         32

 //maximum number of resolutions in svgadata.pmi; shouldn't be a limit though
#define MAX_RESOLUTIONS         128                 //D100432

#define MAX_GENERAL_PROMPT      64
#define MAX_DISKETTE_PROMPT     32
#define MAX_VOLUME_PROMPT       32
#define MAX_RESOLUTION_PROMPT   32
#define ANYSTRING_CHAR          '='          /* for removing win.ini strings */

                     /* finite state machine state definitions (see MainFSM) */
#define MAIN_STATE              0
#define ACTION_STATE            1
#define SOURCE_STATE            2

                                              /* oemhlp cat 80, fn 7 returns */
#define CGA_BIT        2
#define EGA_BIT        4
#define VGA_BIT        8

                                                            /* video defines */
#define VIO_MPA        0                                         /* adapters */
#define VIO_CGA        1
#define VIO_EGA        2
#define VIO_VGA        3
#define VIO_BGA        7
#define VIO_SVGA       8
#define VIO_XGA        9
#define VIO_OTHER      15
#define VIO_NONE       16

#define vioMono       0                                          /* displays */
#define vioColor      1
#define vioEnhanced   2
#define vio8503       3
#define vio8512_13    4
#define vioMono5550   5
#define vio5550       6
#define vio5570       7
#define vioFull5570   8
#define vio8514       9
#define vioPlasma     10
#define vioNewMono    11
#define vio8515       12

                     /* @DSW@ */     /* SVGA manufacturer codes from OEMHLP$ */
#define SVGA_UNKNOWN    0            /* @DSW@ */
#define SVGA_HEADLAND   1            /* @DSW@ */
#define SVGA_TRIDENT    2            /* @DSW@ */
#define SVGA_TSENG      3            /* @DSW@ */
#define SVGA_WESTDIG    4            /* @DSW@ */
#define SVGA_ATI        5            /* @DSW@ */
#define SVGA_SPEEDWAY   6            /* @DSW@ */
#define SVGA_CIRRUS     7            /* @TWM@ */
#define SVGA_S3         8            /* @TWM@ */

#define RETURN_GOOD                0
#define RETURN_ERROR               1
#define RETURN_CANCEL              2
#define RETURN_NODSP              -1
#define RETURN_FATAL              -1

/*
 *additional return codes from  the dll routines
 */
 #define CONTINUE_OPERATION  0x0000
 #define NO_STATE_CHANGE     0x0001
 #define CANCEL_OPERATION    0xFFFF
 #define CONTINUE_WITH_ERR   0xFFFE

/*
 *defines for next chain element
 *service
 */
 #define CHAIN_HEAD      0
 #define CHAIN_TAIL      1
 #define CHAIN_NEXT      2
 #define CHAIN_PREVIOUS  3

 /*
  *defines for the link element routines
  */
 #define ELEMENT_EXISTS  0
 #define ELEMENT_CREATE  1

 #define HEAD_POSITION   0
 #define TAIL_POSITION   1
 #define PREV_POSITION   2
 #define NEXT_POSITION   3



/* the min/max/restore bits mask */
#define SWP_MINMAXRES           (SWP_MINIMIZE | SWP_MAXIMIZE | SWP_RESTORE)

/* Logo Timer values */
#define TID_LOGO_WAIT            1                /* timer id for logo panel */
#define LOGO_WAIT_INDEFINITE    -1                        /* no logo timeout */
#define LOGO_WAIT_NOLOGO         0                                /* no logo */

/* disk drive attribute masks */
#define DRIVE_EXISTS            0x01
#define DRIVE_REMOTE            0x02
#define DRIVE_REMOVABLE         0x04

/* media type */
#define REMOVABLE_MEDIA         0
#define NON_REMOVABLE_MEDIA     1

/* DosError defines */
#define HARDERROR_DISABLE       0x0000
#define HARDERROR_ENABLE        0x0001

/* directory being changed */
#define CHANGE_SOURCE           0
#define CHANGE_DEST             1

/* application messages */
#define AM_WORKER               WM_USER + 0    /* message from worker thread */
#define AM_XFERDSPS             WM_USER + 1
#define AM_XFERDONE             WM_USER + 2
#define AM_SET_DRIVERNAME       WM_USER + 3
#define AM_SET_INSTTXT          WM_USER + 4
#define AM_FSM                  WM_USER + 5
#define AM_UPDATESLIDER         WM_USER + 6    /* 87507 */
#define AM_ADDFILE              WM_USER + 7    /* 87507 */
#define AM_ONEHUNDPERCENT       WM_USER + 8    /* 87507 */
#define AM_DSPINSTL_DONE        WM_USER + 29   /* Reserved to work with config*/
                                               /* utilities defines           */

/* application message parameters */
#define AC_INTERNALERROR        WM_USER + 100              /* internal error */
#define AC_LOADDLG              WM_USER + 101
#define AC_DLGBOX               WM_USER + 102
#define AC_MBXBOX               WM_USER + 103

                                                         /* DISPINST defines */
#define DSP_LINE_SIZE           1024           /* max size of .DDP file line */
#define SIZ_BUFFER              1024

#define TAG_INVALID             0                   /* invalid tag specified */
#define TAG_CONFIG              1                   /* :CONFIG tag specified */
#define TAG_FILES               2                   /* :FILES tag specified  */
#define TAG_OS2INI              3                   /* :OS2INI tag specified */
#define TAG_TITLE               4                   /* :TITLE tag specified  */
#define TAG_RUN                 5                      /* :RUN tag specified */
#define TAG_KEY                 6                      /* :KEY tag specified */
#define TAG_WININI              7                   /* :WININI tag specified */
#define TAG_SET_DRIVER          8               /* :SET_DRIVER tag specified */
#define TAG_SET_RESOLUTION      9           /* :SET_RESOLUTION tag specified */
#define TAG_AUTO_EXEC           10          /* :AUTO_EXEC       tag specified */
#define TAG_DEL_CONFIG_LINE     11          /* :DEL_CONFIG_LINE tag specified */
#define TAG_APPEND_FILES        12          /* :APPEND tag specified   @FERENGI */
#define NUMBER_TAGS             12                         /* number of tags */

                                              /* returned by SplitConfigLine */
#define CFG_VAR_LINE            0
#define CFG_KEYWORD_LINE        1
#define CFG_KEYVALUE_LINE       2
#define CFG_REM_LINE            3
#define CFG_OTHER_LINE          4


/* dbcs macros */
#define MAX_DBCSEV_NUMBER       8                 /* size on range structure */
#define isdbcsleadbyte(c)       (dbcs_mask_[(unsigned char)(c)])
#define isdbcschar(c)           ((c) & 0xFF00)
#define dbcsleadbyte(c)         ((c) >> 8)
#define MAX_RESOLUTION_STRING   64
#define RESOLUTIONS_FILE        "C:\\OS2\\SVGADATA.PMI"
#define SVGATMP_BAT             "C:\\OS2\\SVGATMP.BAT"
#define GRAPHICS_MODE           "Graphics Mode"

#define HELPFILE               "DSPINSTL.HLP"

/*
 *version history
 */
#define VERSION1                1

#define ONCE                    while(0)
#define FOREVER                 while(1)
#define PRIMARY                 1
#define SECONDARY               2
#define SVGA_PROGRAM            "SVGA.EXE"

#define STACK_SIZE_THRD         8192

/*
 *application specific error messages
 */
#define ERROR_DSP_BAD_ARGCOUNT       1001
#define ERROR_INVALID_UNPACK_VER     1003

/*
 *response file error/exit codes
 */
 #define  MSG_NO_RESPONSE_FILE          26
 #define  MSG_RESPONSE_FILE_NOT_FOUND   27
 #define  MSG_RESPONSE_FILE_INVALID     28
 #define  MSG_BUFFER_TOO_SMALL          28
 #define  MSG_PARAMETER_NOT_FOUND       28




#define SIZ_VALUE_STRING              256
#define TITLE_STRING                  "TitleString"
#define DISPLAY                       "Display"

//////////////////////////////////////////////////////////////////
// miscellaneous constants
//////////////////////////////////////////////////////////////////

#define CCH_MAX_TITLE         256
#define CCH_MAX_ADP_PARMS     256
#define CCH_MAX_VID_PARMS     256
#define C_MAX_VID_PARMS         9
#define RESPONSE_APPLICATION   0
#define PM_APPLICATION         1
#define CHILD_APPLICATION      2

//////////////////////////////////////////////////////////////////
// action routine function names
//////////////////////////////////////////////////////////////////

#define DEFAULT_PRIMARY_NAME    "DEFAULT_PRIMARY"
#define DEFAULT_SECONDARY_NAME  "DEFAULT_SECONDARY"
#define SELECTED_PRIMARY_NAME   "SELECTED_PRIMARY"
#define SELECTED_SECONDARY_NAME "SELECTED_SECONDARY"


#define PM_DISPLAYDRIVERS       "PM_DISPLAYDRIVERS"
#define SIZ_RC_SPACING          6


/*-----------------------------------------
 *defines to detect iso - compliant
 *gear
 */

#define OEMHLP_DMQS_INFO      10   /* get pointer to DMQS data */       /*@ISO*/

/*+--------------------------------------------------------------------------+*/
/*| Display Composite ID returned through monitor_id                         |*/
/*+--------------------------------------------------------------------------+*/
#define COMP_ID_9515       0x0F9FF                                      /*@ISO*/
#define COMP_ID_9517       0x099F0                                      /*@ISO*/
#define COMP_ID_9518       0x0F9F0                                      /*@ISO*/

#define OEMHLPDD_NAME   "OEMHLP$"  /* name of OEMHLP device driver        */

/*
 *tokens for
 *the autoexec update routines
 */
#define SET_TOKEN       0
#define FILES_TOKEN     1
#define DEVICE_TOKEN    2
#define PATH_TOKEN      3
#define OTHER_TOKEN     4

/*
 *defines for command line parser
 */
#define TOKEN_ERROR          0
#define TOKEN_SOURCE         1
#define TOKEN_PRIMARY_KEY    2
#define TOKEN_SECONDARY_KEY  3
#define TOKEN_RESPONSE_FILE  4
#define TOKEN_DESTINATION    5
#define TOKEN_LOGNAME        6
#define TOKEN_OVER_DAT_TIM   7
#define TOKEN_MANUFAC_CODE   8
#define TOKEN_PRIMDSCFILENAME  9
#define TOKEN_SECDSCFILENAME  10
#define TOKEN_INS             11                                    // warp
#define TOKEN_RESOLUTION      12                                    //CID
#define TOKEN_NVDM            13                                    //D99901
#define TOKEN_WINHANDLE       14
#define TOKEN_LAST            14                                    // warp


#define REPERR_SYSTEM_ERR   0x00000001
#define REPERR_FATAL_ERR    0x00000002
#define REPERR_LOG          0x00000004

#define RSP_APPLICATION_ERROR      (REPERR_LOG | REPERR_FATAL_ERR )

                                                           /* bidi countries */
#define ARABIC      785
#define HEBREW      972

/*
 * Secondary display configuration = none,  need to write out to reinstal.ini file.
 * The value nine is an index into a structure in pminstal\instdata.c, 9 = null
 */

#define SECONDARY_NONE_APP    "InstallWindow"
#define SECONDARY_NONE_KEY    "VIOADAPTER2STR"
#define SECONDARY_NONE_VALUE  "9"
